/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Clauses;
import org.sat4j.minisat.core.Constr;
import org.sat4j.pb.constraints.AbstractPBDataStructureFactory;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public abstract class AbstractPBClauseCardConstrDataStructure
extends AbstractPBDataStructureFactory {
    private static final long serialVersionUID = 1L;
    static final BigInteger MAX_INT_VALUE;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.AbstractPBClauseCardConstrDataStructure");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        MAX_INT_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    }

    protected Constr constraintFactory(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        if (bigInteger.equals(BigInteger.ONE)) {
            IVecInt iVecInt = Clauses.sanityCheck(new VecInt(nArray), this.getVocabulary(), this.solver);
            if (iVecInt == null) {
                return null;
            }
            return this.constructClause(iVecInt);
        }
        if (AbstractPBClauseCardConstrDataStructure.coefficientsEqualToOne(bigIntegerArray)) {
            if (!$assertionsDisabled && bigInteger.compareTo(MAX_INT_VALUE) >= 0) {
                throw new AssertionError();
            }
            return this.constructCard(new VecInt(nArray), bigInteger.intValue());
        }
        return this.constructPB(nArray, bigIntegerArray, bigInteger);
    }

    protected Constr learntConstraintFactory(IDataStructurePB iDataStructurePB) {
        if (iDataStructurePB.getDegree().equals(BigInteger.ONE)) {
            VecInt vecInt = new VecInt();
            Vec<BigInteger> vec = new Vec<BigInteger>();
            iDataStructurePB.buildConstraintFromConflict(vecInt, vec);
            int n = iDataStructurePB.getAssertiveLiteral();
            if (n > -1) {
                int n2 = vecInt.get(n);
                vecInt.set(n, vecInt.get(0));
                vecInt.set(0, n2);
            }
            return this.constructLearntClause(vecInt);
        }
        if (iDataStructurePB.isCardinality()) {
            return this.constructLearntCard(iDataStructurePB);
        }
        return this.constructLearntPB(iDataStructurePB);
    }

    static boolean coefficientsEqualToOne(BigInteger[] bigIntegerArray) {
        int n = 0;
        while (n < bigIntegerArray.length) {
            if (!bigIntegerArray[n].equals(BigInteger.ONE)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected abstract Constr constructClause(IVecInt var1);

    protected abstract Constr constructCard(IVecInt var1, int var2) throws ContradictionException;

    protected abstract Constr constructPB(int[] var1, BigInteger[] var2, BigInteger var3) throws ContradictionException;

    protected abstract Constr constructLearntClause(IVecInt var1);

    protected abstract Constr constructLearntCard(IDataStructurePB var1);

    protected abstract Constr constructLearntPB(IDataStructurePB var1);
}

