/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractLauncher;
import org.sat4j.core.ASolverFactory;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.reader.PBInstanceReader;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.SearchListener;
import org.sat4j.tools.DotSearchTracing;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lanceur
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    protected ASolverFactory<ISolver> factory;
    private String filename;
    private int k = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.sat.Lanceur");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static void main(String[] stringArray) {
        Lanceur lanceur = new Lanceur();
        lanceur.run(stringArray);
        System.exit(lanceur.getExitCode().value());
    }

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("l", "library", true, "specifies the name of the library used (minisat by default)");
        options.addOption("s", "solver", true, "specifies the name of a prebuilt solver from the library");
        options.addOption("S", "Solver", true, "setup a solver using a solver config string");
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("C", "conflictbased", false, "conflict based timeout (for deterministic behavior)");
        options.addOption("d", "dot", true, "create a sat4j.dot file in current directory representing the search");
        options.addOption("f", "filename", true, "specifies the file to use (in conjunction with -d for instance)");
        options.addOption("m", "mute", false, "Set launcher in silent mode");
        options.addOption("k", "kleast", true, "limit the search to models having at least k variables set to false");
        options.addOption("r", "trace", true, "Search Listener to use for tracing the behavior of the solver");
        Option option = options.getOption("l");
        option.setArgName("libname");
        option = options.getOption("s");
        option.setArgName("solvername");
        option = options.getOption("S");
        option.setArgName("solverStringDefinition");
        option = options.getOption("t");
        option.setArgName("number");
        option = options.getOption("T");
        option.setArgName("number");
        option = options.getOption("C");
        option.setArgName("number");
        option = options.getOption("k");
        option.setArgName("number");
        option = options.getOption("d");
        option.setArgName("filename");
        option = options.getOption("f");
        option.setArgName("filename");
        option = options.getOption("r");
        option.setArgName("searchlistener");
        return options;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ISolver configureSolver(String[] stringArray) {
        Options options = this.createCLIOptions();
        if (stringArray.length == 0) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j.jar", options, true);
            return null;
        }
        try {
            String string;
            Object object;
            Serializable serializable;
            CommandLine commandLine = new PosixParser().parse(options, stringArray);
            String string2 = commandLine.getOptionValue("l");
            if (string2 == null) {
                string2 = "minisat";
            }
            try {
                serializable = Class.forName(new StringBuffer("org.sat4j.").append(string2).append(".SolverFactory").toString());
                Class[] classArray = new Class[]{};
                object = ((Class)serializable).getMethod("instance", classArray);
                this.factory = (ASolverFactory)((Method)object).invoke(null, null);
            }
            catch (Exception exception) {
                this.log(new StringBuffer("Wrong framework: ").append(string2).append(". Using minisat instead.").toString());
                this.factory = SolverFactory.instance();
            }
            if (commandLine.hasOption("s")) {
                this.log(new StringBuffer("Available solvers: ").append(Arrays.asList(this.factory.solverNames())).toString());
                String string3 = commandLine.getOptionValue("s");
                serializable = string3 == null ? this.factory.defaultSolver() : this.factory.createSolverByName(string3);
            } else {
                serializable = this.factory.defaultSolver();
            }
            if (commandLine.hasOption("S")) {
                String string4 = commandLine.getOptionValue("S");
                if (string4 == null) {
                    this.stringUsage();
                    return null;
                }
                serializable = this.configureFromString(string4, (ISolver)serializable);
            }
            if ((string = commandLine.getOptionValue("t")) == null) {
                String string5 = commandLine.getOptionValue("T");
                if (string5 != null) {
                    serializable.setTimeoutMs(Long.parseLong(string5));
                }
            } else if (commandLine.hasOption("C")) {
                serializable.setTimeoutOnConflicts(Integer.parseInt(string));
            } else {
                serializable.setTimeout(Integer.parseInt(string));
            }
            this.filename = commandLine.getOptionValue("f");
            if (commandLine.hasOption("d")) {
                object = null;
                if (this.filename != null) {
                    object = commandLine.getOptionValue("d");
                }
                if (object == null) {
                    object = "sat4j.dot";
                }
                serializable.setSearchListener(new DotSearchTracing((String)object, null));
            }
            if (commandLine.hasOption("m")) {
                this.setSilent(true);
            }
            if (commandLine.hasOption("k") && (object = Integer.valueOf(commandLine.getOptionValue("k"))) != null) {
                this.k = (Integer)object;
            }
            if (commandLine.hasOption("r")) {
                object = commandLine.getOptionValue("r");
                try {
                    Class<?> clazz;
                    Class[] classArray = new Class[1];
                    try {
                        clazz = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    classArray[0] = clazz;
                    SearchListener searchListener = (SearchListener)Class.forName((String)object).getConstructor(classArray).newInstance("sat4j.trace");
                    serializable.setSearchListener(searchListener);
                }
                catch (InstantiationException instantiationException) {
                    this.log(new StringBuffer("wrong parameter for search listener: ").append(instantiationException.getLocalizedMessage()).toString());
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.log(new StringBuffer("wrong parameter for search listener: ").append(illegalAccessException.getLocalizedMessage()).toString());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.log(new StringBuffer("wrong parameter for search listener: ").append((String)object).toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.log(new StringBuffer("wrong parameter for search listener: ").append(illegalArgumentException.getLocalizedMessage()).toString());
                }
                catch (SecurityException securityException) {
                    this.log(new StringBuffer("wrong parameter for search listener: ").append(securityException.getLocalizedMessage()).toString());
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.log(new StringBuffer("wrong parameter for search listener: ").append(invocationTargetException.getLocalizedMessage()).toString());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.log(new StringBuffer("wrong parameter for search listener: ").append(noSuchMethodException.getLocalizedMessage()).toString());
                }
            }
            int n = 0;
            String[] stringArray2 = commandLine.getArgs();
            if (this.filename == null && stringArray2.length > 0) {
                this.filename = stringArray2[n++];
            }
            while (true) {
                if (n >= stringArray2.length) {
                    this.getLogWriter().println(serializable.toString("c "));
                    return serializable;
                }
                String[] stringArray3 = stringArray2[n].split("=");
                if (!$assertionsDisabled && stringArray3.length != 2) {
                    throw new AssertionError();
                }
                this.log(new StringBuffer("setting ").append(stringArray3[0]).append(" to ").append(stringArray3[1]).toString());
                try {
                    BeanUtils.setProperty(serializable, stringArray3[0], stringArray3[1]);
                }
                catch (Exception exception) {
                    this.log(new StringBuffer("Cannot set parameter : ").append(stringArray[n]).toString());
                }
                ++n;
            }
        }
        catch (ParseException parseException) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j.jar", options, true);
            this.usage();
            return null;
        }
    }

    @Override
    protected Reader createReader(ISolver iSolver, String string) {
        if (iSolver instanceof IPBSolver) {
            return new PBInstanceReader((IPBSolver)iSolver);
        }
        return new InstanceReader(iSolver);
    }

    @Override
    public void displayLicense() {
        super.displayLicense();
        this.log("This software uses some libraries from the Jakarta Commons project. See jakarta.apache.org for details.");
    }

    @Override
    public void usage() {
        this.showAvailableSolvers(this.factory);
    }

    @Override
    protected String getInstanceName(String[] stringArray) {
        return this.filename;
    }

    private final ISolver configureFromString(String string, ISolver iSolver) {
        String string2;
        SearchParams searchParams;
        String string3;
        RestartStrategy restartStrategy;
        IPhaseSelectionStrategy iPhaseSelectionStrategy;
        IOrder iOrder;
        LearningStrategy learningStrategy;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Properties properties = new Properties();
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            String[] stringArray = string4.split("=");
            properties.setProperty(stringArray[0], stringArray[1]);
        }
        Solver solver = (Solver)iSolver;
        DataStructureFactory dataStructureFactory = (DataStructureFactory)this.setupObject("DSF", properties);
        if (dataStructureFactory != null) {
            solver.setDataStructureFactory(dataStructureFactory);
        }
        if ((learningStrategy = (LearningStrategy)this.setupObject("LEARNING", properties)) != null) {
            solver.setLearner(learningStrategy);
            learningStrategy.setSolver(solver);
        }
        if ((iOrder = (IOrder)this.setupObject("ORDER", properties)) != null) {
            solver.setOrder(iOrder);
        }
        if ((iPhaseSelectionStrategy = (IPhaseSelectionStrategy)this.setupObject("PHASE", properties)) != null) {
            solver.getOrder().setPhaseSelectionStrategy(iPhaseSelectionStrategy);
        }
        if ((restartStrategy = (RestartStrategy)this.setupObject("RESTARTS", properties)) != null) {
            solver.setRestartStrategy(restartStrategy);
        }
        if ((string3 = properties.getProperty("SIMP")) != null) {
            solver.setSimplifier(string3);
        }
        if ((searchParams = (SearchParams)this.setupObject("PARAMS", properties)) != null) {
            solver.setSearchParams(searchParams);
        }
        if ("GLUCOSE".equalsIgnoreCase(string2 = properties.getProperty("MEMORY"))) {
            this.log("configuring MEMORY");
            solver.setLearnedConstraintsDeletionStrategy(solver.glucose);
        }
        return iSolver;
    }

    private void stringUsage() {
        this.log("Available building blocks: DSF, LEARNING, ORDER, PHASE, RESTARTS, SIMP, PARAMS");
        this.log("Example: -S RESTARTS=org.sat4j.minisat.restarts.LubyRestarts/factor:512,LEARNING=org.sat4j.minisat.learning.MiniSATLearning");
    }

    private final <T> T setupObject(String string, Properties properties) {
        String string2;
        block9: {
            string2 = properties.getProperty(string);
            if (string2 != null) break block9;
            return null;
        }
        try {
            this.log(new StringBuffer("configuring ").append(string).toString());
            String[] stringArray = string2.split("/");
            Object obj = Class.forName(stringArray[0]).newInstance();
            int n = 1;
            while (n < stringArray.length) {
                String[] stringArray2 = stringArray[n].split(":");
                if (!$assertionsDisabled && stringArray2.length != 2) {
                    throw new AssertionError();
                }
                try {
                    BeanUtils.getProperty(obj, stringArray2[0]);
                    BeanUtils.setProperty(obj, stringArray2[0], stringArray2[1]);
                }
                catch (Exception exception) {
                    this.log(new StringBuffer("Problem with component ").append(stringArray[0]).append(" ").append(exception).toString());
                }
                ++n;
            }
            return (T)obj;
        }
        catch (InstantiationException instantiationException) {
            this.log(new StringBuffer("Problem with component ").append(string).append(" ").append(instantiationException).toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log(new StringBuffer("Problem with component ").append(string).append(" ").append(illegalAccessException).toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log(new StringBuffer("Problem with component ").append(string).append(" ").append(classNotFoundException).toString());
        }
        return null;
    }

    @Override
    protected IProblem readProblem(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        ISolver iSolver = (ISolver)super.readProblem(string);
        if (this.k > 0) {
            VecInt vecInt = new VecInt();
            int n = 1;
            while (n <= iSolver.nVars()) {
                vecInt.push(-n);
                ++n;
            }
            iSolver.addAtLeast(vecInt, this.k);
            this.log(new StringBuffer("Limiting solutions to those having at least ").append(this.k).append(" variables assigned to false").toString());
        }
        return iSolver;
    }
}

