/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.DimacsStringSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LPStringSolver
extends DimacsStringSolver
implements IPBSolver {
    private static final String FAKE_I_CONSTR_MSG = "Fake IConstr";
    private static final long serialVersionUID = 1L;
    private int indxConstrObj;
    private int nbOfConstraints;
    private ObjectiveFunction obj;
    private boolean inserted = false;
    private static final IConstr FAKE_CONSTR = new IConstr(){

        public int size() {
            throw new UnsupportedOperationException(LPStringSolver.FAKE_I_CONSTR_MSG);
        }

        public boolean learnt() {
            throw new UnsupportedOperationException(LPStringSolver.FAKE_I_CONSTR_MSG);
        }

        public double getActivity() {
            throw new UnsupportedOperationException(LPStringSolver.FAKE_I_CONSTR_MSG);
        }

        public int get(int n) {
            throw new UnsupportedOperationException(LPStringSolver.FAKE_I_CONSTR_MSG);
        }

        public boolean canBePropagatedMultipleTimes() {
            throw new UnsupportedOperationException(LPStringSolver.FAKE_I_CONSTR_MSG);
        }
    };

    public LPStringSolver() {
    }

    public LPStringSolver(int n) {
        super(n);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n = iteratorInt.next();
            if (n > 0) {
                this.getOut().append("x" + n + " >= 1 \n");
            } else {
                this.getOut().append("- x" + -n + " >= 0 \n");
            }
            ++this.nbOfConstraints;
        }
        throw new TimeoutException();
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        return super.isSatisfiable(iVecInt, bl);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        if (bl) {
            return this.addAtLeast(iVecInt, iVec, bigInteger);
        }
        return this.addAtMost(iVecInt, iVec, bigInteger);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.obj = objectiveFunction;
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        int n2 = 0;
        boolean bl = true;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n3 = iteratorInt.next();
            assert (n3 != 0);
            if (bl) {
                if (n3 > 0) {
                    this.getOut().append("x" + n3 + " ");
                } else {
                    this.getOut().append("- x" + -n3 + " ");
                    ++n2;
                }
                bl = false;
                continue;
            }
            if (n3 > 0) {
                stringBuffer.append("+ x" + n3 + " ");
                continue;
            }
            stringBuffer.append("- x" + -n3 + " ");
            ++n2;
        }
        stringBuffer.append(">= " + (n - n2) + " \n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        int n2 = 0;
        boolean bl = true;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n3 = iteratorInt.next();
            assert (n3 != 0);
            if (bl) {
                if (n3 > 0) {
                    this.getOut().append("- x" + n3 + " ");
                } else {
                    this.getOut().append("x" + -n3 + " ");
                    ++n2;
                }
                bl = false;
                continue;
            }
            if (n3 > 0) {
                stringBuffer.append("- x" + n3 + " ");
                continue;
            }
            stringBuffer.append("+ x" + -n3 + " ");
            ++n2;
        }
        stringBuffer.append(">= " + (-n + n2) + " \n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        boolean bl = true;
        int n = 0;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n2 = iteratorInt.next();
            if (bl) {
                if (n2 > 0) {
                    stringBuffer.append("x" + n2 + " ");
                } else {
                    stringBuffer.append("-x" + -n2 + " ");
                    ++n;
                }
                bl = false;
                continue;
            }
            if (n2 > 0) {
                stringBuffer.append("+ x" + n2 + " ");
                continue;
            }
            stringBuffer.append("- x" + -n2 + " ");
            ++n;
        }
        stringBuffer.append(">= " + (1 - n) + "\n");
        return FAKE_CONSTR;
    }

    public String getExplanation() {
        return null;
    }

    public void setListOfVariablesForExplanation(IVecInt iVecInt) {
    }

    public void objectiveFunctionToLP(ObjectiveFunction objectiveFunction, StringBuffer stringBuffer) {
        stringBuffer.append("Minimize \n");
        stringBuffer.append("obj: ");
        IVecInt iVecInt = objectiveFunction.getVars();
        IVec<BigInteger> iVec = objectiveFunction.getCoeffs();
        int n = iVecInt.size();
        if (n > 0) {
            stringBuffer.append(iVec.get(0));
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(0));
            stringBuffer.append(" ");
        }
        for (int i = 1; i < n; ++i) {
            BigInteger bigInteger = iVec.get(i);
            if (bigInteger.signum() > 0) {
                stringBuffer.append("+ " + bigInteger);
            } else {
                stringBuffer.append("- " + bigInteger.negate());
            }
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(i));
            stringBuffer.append(" ");
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = this.getOut();
        if (!this.inserted) {
            StringBuffer stringBuffer2 = new StringBuffer();
            if (this.obj != null) {
                this.objectiveFunctionToLP(this.obj, stringBuffer2);
                stringBuffer2.append("\n");
                stringBuffer2.append("Subject To\n ");
            }
            stringBuffer.insert(this.indxConstrObj, stringBuffer2.toString());
            this.inserted = true;
        }
        stringBuffer.append("Binary \n");
        for (int i = 1; i <= this.nVars(); ++i) {
            stringBuffer.append("x" + i + "\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("End");
        return stringBuffer.toString();
    }

    @Override
    public String toString(String string) {
        return this.toString();
    }

    @Override
    public int newVar(int n) {
        StringBuffer stringBuffer = this.getOut();
        this.setNbVars(n);
        this.indxConstrObj = stringBuffer.length();
        stringBuffer.append("\n");
        return n;
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.obj;
    }

    @Override
    public int nConstraints() {
        return this.nbOfConstraints;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        assert (iVecInt.size() == iVecInt2.size());
        ++this.nbOfConstraints;
        int n2 = iVecInt.size();
        if (n2 > 0) {
            stringBuffer.append(-iVecInt2.get(0));
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(0));
            stringBuffer.append(" ");
        }
        for (int i = 1; i < n2; ++i) {
            int n3 = iVecInt2.get(i);
            if (n3 > 0) {
                stringBuffer.append("+ " + -n3);
            } else {
                stringBuffer.append("- " + n3);
            }
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(i));
            stringBuffer.append(" ");
        }
        stringBuffer.append(">= ");
        stringBuffer.append(-n);
        stringBuffer.append(" \n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        assert (iVecInt.size() == iVec.size());
        ++this.nbOfConstraints;
        int n = iVecInt.size();
        if (n > 0) {
            stringBuffer.append(iVec.get(0).negate());
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(0));
            stringBuffer.append(" ");
        }
        for (int i = 1; i < n; ++i) {
            BigInteger bigInteger2 = iVec.get(i);
            if (bigInteger2.signum() < 0) {
                stringBuffer.append("+ " + bigInteger2.negate());
            } else {
                stringBuffer.append("- " + bigInteger2);
            }
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(i));
            stringBuffer.append(" ");
        }
        stringBuffer.append(">= ");
        stringBuffer.append(bigInteger.negate());
        stringBuffer.append(" \n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        assert (iVecInt.size() == iVecInt2.size());
        ++this.nbOfConstraints;
        int n2 = iVecInt.size();
        if (n2 > 0) {
            stringBuffer.append(iVecInt2.get(0));
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(0));
            stringBuffer.append(" ");
        }
        for (int i = 1; i < n2; ++i) {
            int n3 = iVecInt2.get(i);
            if (n3 > 0) {
                stringBuffer.append("+ " + n3);
            } else {
                stringBuffer.append("- " + n3 * -1);
            }
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(i));
            stringBuffer.append(" ");
        }
        stringBuffer.append(">= ");
        stringBuffer.append(n);
        stringBuffer.append(" \n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        assert (iVecInt.size() == iVec.size());
        ++this.nbOfConstraints;
        int n = iVecInt.size();
        if (n > 0) {
            stringBuffer.append(iVec.get(0));
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(0));
            stringBuffer.append(" ");
        }
        for (int i = 1; i < n; ++i) {
            BigInteger bigInteger2 = iVec.get(i);
            if (bigInteger2.signum() > 0) {
                stringBuffer.append("+ " + bigInteger2);
            } else {
                stringBuffer.append("- " + bigInteger2.negate());
            }
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(i));
            stringBuffer.append(" ");
        }
        stringBuffer.append(">= ");
        stringBuffer.append(bigInteger);
        stringBuffer.append(" \n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        assert (iVecInt.size() == iVecInt2.size());
        ++this.nbOfConstraints;
        int n2 = iVecInt.size();
        if (n2 > 0) {
            stringBuffer.append(iVecInt2.get(0));
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(0));
            stringBuffer.append(" ");
        }
        for (int i = 1; i < n2; ++i) {
            int n3 = iVecInt2.get(i);
            if (n3 > 0) {
                stringBuffer.append("+ " + n3);
            } else {
                stringBuffer.append("- " + n3 * -1);
            }
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(i));
            stringBuffer.append(" ");
        }
        stringBuffer.append("= ");
        stringBuffer.append(n);
        stringBuffer.append(" \n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        assert (iVecInt.size() == iVec.size());
        ++this.nbOfConstraints;
        int n = iVecInt.size();
        if (n > 0) {
            stringBuffer.append(iVec.get(0));
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(0));
            stringBuffer.append(" ");
        }
        for (int i = 1; i < n; ++i) {
            BigInteger bigInteger2 = iVec.get(i);
            if (bigInteger2.signum() > 0) {
                stringBuffer.append("+ " + bigInteger2);
            } else {
                stringBuffer.append("- " + bigInteger2.negate());
            }
            stringBuffer.append("x");
            stringBuffer.append(iVecInt.get(i));
            stringBuffer.append(" ");
        }
        stringBuffer.append("= ");
        stringBuffer.append(bigInteger);
        stringBuffer.append(" \n");
        return FAKE_CONSTR;
    }
}

