/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.SolverFactory;
import org.sat4j.pb.reader.OPBReader2007;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.GateTranslator;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoBitsAdderDecorator
extends SolverDecorator<IPBSolver>
implements IPBSolver {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction objfct;
    private final GateTranslator gator;
    private final IPBSolver solver;

    public PseudoBitsAdderDecorator(IPBSolver iPBSolver) {
        super(iPBSolver);
        this.gator = new GateTranslator(iPBSolver);
        this.solver = iPBSolver;
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.objfct = objectiveFunction;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        if (this.objfct == null) {
            return this.gator.isSatisfiable(iVecInt);
        }
        System.out.println("c Original number of variables and constraints");
        System.out.println("c #vars: " + this.gator.nVars() + " #constraints: " + this.gator.nConstraints());
        VecInt vecInt = new VecInt();
        System.out.println("c Creating optimization constraints ....");
        try {
            this.gator.optimisationFunction(this.objfct.getVars(), this.objfct.getCoeffs(), vecInt);
        }
        catch (ContradictionException contradictionException) {
            return false;
        }
        System.out.println("c ... done. " + vecInt);
        System.out.println("c New number of variables and constraints");
        System.out.println("c #vars: " + this.gator.nVars() + " #constraints: " + this.gator.nConstraints());
        VecInt vecInt2 = new VecInt(vecInt.size());
        VecInt vecInt3 = new VecInt(iVecInt.size() + vecInt.size());
        int n = vecInt.size() - 1;
        while (n >= 0) {
            iVecInt.copyTo(vecInt3);
            vecInt2.copyTo(vecInt3);
            vecInt3.push(-vecInt.get(n));
            for (int i = n - 1; i >= 0; --i) {
                vecInt3.push(vecInt.get(i));
            }
            System.out.println("c assumptions " + vecInt3);
            boolean bl = this.gator.isSatisfiable(vecInt3, true);
            if (bl) {
                vecInt2.push(-vecInt.get(n--));
                BigInteger bigInteger = this.objfct.calculateDegree(this.gator);
                System.out.println("o " + bigInteger);
                System.out.println("c current objective value with fixed lits " + vecInt2);
            } else {
                vecInt2.push(vecInt.get(n--));
                System.out.println("c unsat. fixed lits " + vecInt2);
            }
            vecInt3.clear();
        }
        assert (vecInt2.size() == vecInt.size());
        iVecInt.copyTo(vecInt3);
        vecInt2.copyTo(vecInt3);
        return this.gator.isSatisfiable(vecInt3);
    }

    public static void main(String[] stringArray) {
        PseudoBitsAdderDecorator pseudoBitsAdderDecorator = new PseudoBitsAdderDecorator(SolverFactory.newDefault());
        pseudoBitsAdderDecorator.setVerbose(false);
        OPBReader2007 oPBReader2007 = new OPBReader2007(pseudoBitsAdderDecorator);
        long l = System.currentTimeMillis();
        try {
            IProblem iProblem = oPBReader2007.parseInstance(stringArray[0]);
            if (iProblem.isSatisfiable()) {
                System.out.println("s OPTIMUM FOUND");
                System.out.println("v " + oPBReader2007.decode(iProblem.model()));
                if (pseudoBitsAdderDecorator.objfct != null) {
                    System.out.println("c objective function=" + pseudoBitsAdderDecorator.objfct.calculateDegree(pseudoBitsAdderDecorator.gator));
                }
            } else {
                System.out.println("s UNSAT");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (ParseFormatException parseFormatException) {
            parseFormatException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ContradictionException contradictionException) {
            System.out.println("s UNSAT");
            System.out.println("c trivial inconsistency");
        }
        catch (TimeoutException timeoutException) {
            System.out.println("s UNKNOWN");
        }
        long l2 = System.currentTimeMillis();
        System.out.println("c Total wall clock time: " + (double)(l2 - l) / 1000.0 + " seconds");
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        return this.solver.addPseudoBoolean(iVecInt, iVec, bl, bigInteger);
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.objfct;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        throw new UnsupportedOperationException();
    }
}

