/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectiveReducerPBSolverDecorator
implements IPBSolver {
    private static final long serialVersionUID = -1637773414229087105L;
    private final IPBSolver decorated;
    private final List<IVecInt> atMostOneCstrs = new ArrayList<IVecInt>();

    public ObjectiveReducerPBSolverDecorator(IPBSolver iPBSolver) {
        this.decorated = iPBSolver;
    }

    @Override
    public int[] model() {
        return this.decorated.model();
    }

    @Override
    public int newVar() {
        return this.decorated.newVar();
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        return this.decorated.addPseudoBoolean(iVecInt, iVec, bl, bigInteger);
    }

    @Override
    public boolean model(int n) {
        return this.decorated.model(n);
    }

    @Override
    public int nextFreeVarId(boolean bl) {
        return this.decorated.nextFreeVarId(bl);
    }

    @Override
    public int[] primeImplicant() {
        return this.decorated.primeImplicant();
    }

    @Override
    public boolean primeImplicant(int n) {
        return this.decorated.primeImplicant(n);
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        IteratorInt iteratorInt = iVecInt2.iterator();
        while (iteratorInt.hasNext()) {
            if (iteratorInt.next() == n) continue;
            return this.decorated.addAtMost(iVecInt, iVecInt2, n);
        }
        this.atMostOneCstrs.add(iVecInt);
        return this.decorated.addAtMost(iVecInt, iVecInt2, n);
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.decorated.isSatisfiable();
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        return this.decorated.isSatisfiable(iVecInt, bl);
    }

    @Override
    public void registerLiteral(int n) {
        this.decorated.registerLiteral(n);
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.decorated.setExpectedNumberOfClauses(n);
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        Iterator<BigInteger> iterator = iVec.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().equals(bigInteger)) continue;
            return this.decorated.addAtMost(iVecInt, iVec, bigInteger);
        }
        this.atMostOneCstrs.add(iVecInt);
        return this.decorated.addAtMost(iVecInt, iVec, bigInteger);
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        return this.decorated.isSatisfiable(bl);
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        return this.decorated.addClause(iVecInt);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        return this.decorated.isSatisfiable(iVecInt);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        return this.decorated.addAtLeast(iVecInt, iVecInt2, n);
    }

    @Override
    public int[] findModel() throws TimeoutException {
        return this.decorated.findModel();
    }

    @Override
    public IConstr addBlockingClause(IVecInt iVecInt) throws ContradictionException {
        return this.decorated.addBlockingClause(iVecInt);
    }

    @Override
    public boolean removeConstr(IConstr iConstr) {
        return this.decorated.removeConstr(iConstr);
    }

    @Override
    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        return this.decorated.findModel(iVecInt);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        return this.decorated.addAtLeast(iVecInt, iVec, bigInteger);
    }

    @Override
    public boolean removeSubsumedConstr(IConstr iConstr) {
        return this.decorated.removeSubsumedConstr(iConstr);
    }

    @Override
    public int nConstraints() {
        return this.decorated.nConstraints();
    }

    @Override
    public int newVar(int n) {
        return this.decorated.newVar(n);
    }

    @Override
    public void addAllClauses(IVec<IVecInt> iVec) throws ContradictionException {
        Iterator<IVecInt> iterator = iVec.iterator();
        while (iterator.hasNext()) {
            this.addClause(iterator.next());
        }
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        return this.decorated.addExactly(iVecInt, iVecInt2, n);
    }

    @Override
    public int nVars() {
        return this.decorated.nVars();
    }

    @Override
    public void printInfos(PrintWriter printWriter, String string) {
        this.decorated.printInfos(printWriter, string);
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        if (n == 1) {
            this.atMostOneCstrs.add(iVecInt);
        }
        return this.decorated.addAtMost(iVecInt, n);
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        return this.decorated.addExactly(iVecInt, iVec, bigInteger);
    }

    @Override
    public void printInfos(PrintWriter printWriter) {
        this.decorated.printInfos(printWriter);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        return this.decorated.addAtLeast(iVecInt, n);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        if (objectiveFunction != null) {
            VecInt vecInt = new VecInt();
            Vec<BigInteger> vec = new Vec<BigInteger>();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            IVecInt iVecInt = objectiveFunction.getVars();
            IVec<BigInteger> iVec = objectiveFunction.getCoeffs();
            int n = this.processAtMostOneCstrs(objectiveFunction, vecInt, vec, hashSet);
            System.out.println("c " + n + " reductions due to atMostOne constraints");
            for (int i = 0; i < iVecInt.size(); ++i) {
                if (hashSet.contains(iVecInt.get(i))) continue;
                vecInt.push(iVecInt.get(i));
                vec.push(iVec.get(i));
            }
            objectiveFunction = new ObjectiveFunction(vecInt, vec);
        }
        this.decorated.setObjectiveFunction(objectiveFunction);
    }

    private int processAtMostOneCstrs(ObjectiveFunction objectiveFunction, IVecInt iVecInt, IVec<BigInteger> iVec, Set<Integer> set) {
        System.out.println("c " + this.atMostOneCstrs.size() + " atMostOne constraints found");
        int n = 0;
        IVecInt iVecInt2 = objectiveFunction.getVars();
        IVec<BigInteger> iVec2 = objectiveFunction.getCoeffs();
        for (IVecInt iVecInt3 : this.atMostOneCstrs) {
            int n2;
            boolean bl = true;
            IteratorInt iteratorInt = iVecInt3.iterator();
            while (iteratorInt.hasNext()) {
                int n3 = iteratorInt.next();
                if (set.contains(n3)) {
                    bl = false;
                    break;
                }
                n2 = iVecInt2.indexOf(n3);
                if (n2 != -1 && iVec2.get(n2).equals(BigInteger.ONE)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            int n4 = this.nextFreeVarId(true);
            try {
                IteratorInt iteratorInt2 = iVecInt3.iterator();
                while (iteratorInt2.hasNext()) {
                    n2 = iteratorInt2.next();
                    this.decorated.addClause(new VecInt(new int[]{n2, n4}));
                    set.add(n2);
                    ++n;
                }
            }
            catch (ContradictionException contradictionException) {
                contradictionException.printStackTrace();
            }
            iVecInt.push(n4);
            iVec.push(BigInteger.ONE);
            --n;
        }
        return n;
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.decorated.getObjectiveFunction();
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, int n) throws ContradictionException {
        return this.decorated.addExactly(iVecInt, n);
    }

    @Override
    public void setTimeout(int n) {
        this.decorated.setTimeout(n);
    }

    @Override
    public void setTimeoutOnConflicts(int n) {
        this.decorated.setTimeoutOnConflicts(n);
    }

    @Override
    public void setTimeoutMs(long l) {
        this.decorated.setTimeoutMs(l);
    }

    @Override
    public int getTimeout() {
        return this.decorated.getTimeout();
    }

    @Override
    public long getTimeoutMs() {
        return this.decorated.getTimeoutMs();
    }

    @Override
    public void expireTimeout() {
        this.decorated.expireTimeout();
    }

    @Override
    public void reset() {
        this.decorated.reset();
    }

    @Override
    public void printStat(PrintStream printStream, String string) {
        this.decorated.printStat(printStream, string);
    }

    @Override
    public void printStat(PrintWriter printWriter, String string) {
        this.decorated.printStat(printWriter, string);
    }

    @Override
    public void printStat(PrintWriter printWriter) {
        this.decorated.printStat(printWriter);
    }

    @Override
    public Map<String, Number> getStat() {
        return this.decorated.getStat();
    }

    @Override
    public String toString(String string) {
        return this.decorated.toString(string);
    }

    @Override
    public void clearLearntClauses() {
        this.decorated.clearLearntClauses();
    }

    @Override
    public void setDBSimplificationAllowed(boolean bl) {
        this.decorated.setDBSimplificationAllowed(bl);
    }

    @Override
    public boolean isDBSimplificationAllowed() {
        return this.decorated.isDBSimplificationAllowed();
    }

    @Override
    public <S extends ISolverService> void setSearchListener(SearchListener<S> searchListener) {
        this.decorated.setSearchListener(searchListener);
    }

    @Override
    public <S extends ISolverService> SearchListener<S> getSearchListener() {
        return this.decorated.getSearchListener();
    }

    @Override
    public boolean isVerbose() {
        return this.decorated.isVerbose();
    }

    @Override
    public void setVerbose(boolean bl) {
        this.decorated.setVerbose(bl);
    }

    @Override
    public void setLogPrefix(String string) {
        this.decorated.setLogPrefix(string);
    }

    @Override
    public String getLogPrefix() {
        return this.decorated.getLogPrefix();
    }

    @Override
    public IVecInt unsatExplanation() {
        return this.decorated.unsatExplanation();
    }

    @Override
    public int[] modelWithInternalVariables() {
        return this.decorated.modelWithInternalVariables();
    }

    @Override
    public int realNumberOfVariables() {
        return this.decorated.realNumberOfVariables();
    }

    @Override
    public boolean isSolverKeptHot() {
        return this.decorated.isSolverKeptHot();
    }

    @Override
    public void setKeepSolverHot(boolean bl) {
        this.decorated.setKeepSolverHot(bl);
    }

    @Override
    public ISolver getSolvingEngine() {
        return this.decorated.getSolvingEngine();
    }
}

