/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Collection;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.pb.tools.DependencyHelper;
import org.sat4j.pb.tools.LexicoDecoratorPB;
import org.sat4j.pb.tools.WeightedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicoHelper<T, C>
extends DependencyHelper<T, C> {
    private final LexicoDecoratorPB lexico = (LexicoDecoratorPB)((PBSolverDecorator)this.getSolver()).decorated();

    public LexicoHelper(IPBSolver iPBSolver) {
        super(new OptToPBSATAdapter(new LexicoDecoratorPB(iPBSolver)));
    }

    public LexicoHelper(IPBSolver iPBSolver, boolean bl, boolean bl2) {
        super(new OptToPBSATAdapter(new LexicoDecoratorPB(iPBSolver)), bl, bl2);
    }

    public LexicoHelper(IPBSolver iPBSolver, boolean bl) {
        super(new OptToPBSATAdapter(new LexicoDecoratorPB(iPBSolver)), bl);
    }

    public void addCriterion(Collection<T> collection) {
        VecInt vecInt = new VecInt(collection.size());
        for (T t : collection) {
            vecInt.push(this.getIntValue(t));
        }
        this.lexico.addCriterion(vecInt);
    }

    public void addWeightedCriterion(Collection<WeightedObject<T>> collection) {
        VecInt vecInt = new VecInt(collection.size());
        Vec<BigInteger> vec = new Vec<BigInteger>(collection.size());
        for (WeightedObject<T> weightedObject : collection) {
            vecInt.push(this.getIntValue(weightedObject.thing));
            vec.push(weightedObject.getWeight());
        }
        this.lexico.addCriterion(vecInt, vec);
    }

    public boolean isOptimal() {
        return ((OptToPBSATAdapter)this.getSolver()).isOptimal();
    }
}

