/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.sat4j.core.ASolverFactory;
import org.sat4j.maxsat.WeightedMaxSatDecorator;
import org.sat4j.maxsat.reader.MSInstanceReader;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.ICDCL;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.LearnedConstraintsEvaluationType;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SimplificationType;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.pb.ConstraintRelaxingPseudoOptDecorator;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.orders.RandomWalkDecoratorObjective;
import org.sat4j.pb.orders.VarOrderHeapObjective;
import org.sat4j.pb.reader.PBInstanceReader;
import org.sat4j.pb.tools.ClausalConstraintsDecorator;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.sat.CleanCommandComponent;
import org.sat4j.sat.HotSolverCommandComponent;
import org.sat4j.sat.PhaseCommandComponent;
import org.sat4j.sat.ProblemType;
import org.sat4j.sat.RandomWalkCommandComponent;
import org.sat4j.sat.RemoteControlFrame;
import org.sat4j.sat.RemoteControlStrategy;
import org.sat4j.sat.RestartCommandComponent;
import org.sat4j.sat.SimplifierCommandComponent;
import org.sat4j.sat.SolverController;
import org.sat4j.sat.Solvers;
import org.sat4j.sat.StartSolverEnum;
import org.sat4j.sat.visu.ChartBasedVisualizationTool;
import org.sat4j.sat.visu.GnuplotBasedSolverVisualisation;
import org.sat4j.sat.visu.JChartBasedSolverVisualisation;
import org.sat4j.sat.visu.SolverVisualisation;
import org.sat4j.sat.visu.TraceComposite;
import org.sat4j.sat.visu.VisuPreferences;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.Lbool;
import org.sat4j.specs.RandomAccessModel;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ClausalCardinalitiesDecorator;
import org.sat4j.tools.ConflictDepthTracing;
import org.sat4j.tools.ConflictLevelTracing;
import org.sat4j.tools.DecisionTracing;
import org.sat4j.tools.FileBasedVisualizationTool;
import org.sat4j.tools.HeuristicsTracing;
import org.sat4j.tools.LearnedClausesSizeTracing;
import org.sat4j.tools.LearnedTracing;
import org.sat4j.tools.MultiTracing;
import org.sat4j.tools.SpeedTracing;
import org.sat4j.tools.encoding.EncodingStrategy;
import org.sat4j.tools.encoding.EncodingStrategyAdapter;
import org.sat4j.tools.encoding.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetailedCommandPanel
extends JPanel
implements SolverController,
SearchListener<ISolverService>,
ILogAble {
    private static final String EXACTLY_1 = "Exactly 1:";
    private static final String EXACTLY_K = "Exactly K:";
    private static final String AT_MOST_1 = "At Most 1:";
    private static final String AT_MOST_K = "At Most K:";
    private Policy encodingPolicy = new Policy();
    private static final long serialVersionUID = 1L;
    public static final EmptyBorder BORDER5 = new EmptyBorder(5, 5, 5, 5);
    private String ramdisk;
    private RemoteControlStrategy telecomStrategy;
    private RandomWalkDecorator randomWalk;
    private ISolver solver;
    private Reader reader;
    private IProblem problem;
    private ProblemType problemType;
    private boolean optimizationMode;
    private boolean equivalenceMode;
    private boolean lowerMode;
    private String[] commandLines;
    private boolean firstStart;
    private StartSolverEnum startConfig;
    private StringWriter stringWriter;
    private JPanel aboutSolverPanel;
    private JTextArea textArea;
    private JPanel instancePanel;
    private static final String INSTANCE_PANEL = "Instance";
    private JLabel instanceLabel;
    private static final String INSTANCE = "Path to instance: ";
    private JTextField instancePathField;
    private String instancePath;
    private JButton browseButton;
    private static final String BROWSE = "Browse";
    private String whereToWriteFiles;
    private static final String MINISAT_PREFIX = "minisat";
    private static final String PB_PREFIX = "pb";
    private static final String MAXSAT_PREFIX = "maxsat";
    private JPanel choixSolverPanel;
    private static final String CHOIX_SOLVER_PANEL = "Solver";
    private JLabel choixSolver;
    private static final String CHOIX_SOLVER = "Choose solver: ";
    private JComboBox listeSolvers;
    private static final String OPTMIZATION_MODE = "Optimization problem";
    private JCheckBox optimisationModeCB;
    private static final String EQUIVALENCE = "Use equivalence instead of implication";
    private JCheckBox equivalenceCB;
    private static final String LOWER = "Search solution by lower bounding instead of upper bounding";
    private JCheckBox lowerCB;
    private JComboBox atMostKCB;
    private JComboBox atMost1CB;
    private JComboBox exactlyKCB;
    private JComboBox exactly1CB;
    private JRadioButton solverLineParamLineRadio;
    private JRadioButton solverLineParamRemoteRadio;
    private JRadioButton solverListParamListRadio;
    private JRadioButton solverListParamRemoteRadio;
    private static final String SOLVER_LINE_PARAM_LINE_CONFIG = "Start customized solver as given in command line";
    private static final String SOLVER_LINE_PARAM_REMOTE_CONFIG = "Start customized solver as given in command line with configuration given in the remote";
    private static final String SOLVER_LIST_PARAM_LIST_CONFIG = "Start solver as chosen in list with its default configuration";
    private static final String SOLVER_LIST_PARAM_REMOTE_CONFIG = "Start solver as chosen in list with configuration given in the remote";
    private static final String CHOOSE_START_CONFIG = "Choose start configuration : ";
    private JButton startStopButton;
    private static final String START = "Start";
    private static final String STOP = "Stop";
    private JButton pauseButton;
    private static final String PAUSE = "Pause";
    private static final String RESUME = "Resume";
    private static final String RESTART_PANEL = "Restart strategy";
    private RestartCommandComponent restartPanel;
    private static final String RW_PANEL = "Random Walk";
    private RandomWalkCommandComponent rwPanel;
    private static final String CLEAN_PANEL = "Learned Constraint Deletion Strategy";
    private CleanCommandComponent cleanPanel;
    private PhaseCommandComponent phasePanel;
    private static final String PHASE_PANEL = "Phase Strategy";
    private SimplifierCommandComponent simplifierPanel;
    private static final String SIMPLIFIER_PANEL = "Simplification strategy";
    private HotSolverCommandComponent hotSolverPanel;
    private static final String HOT_SOLVER_PANEL = "Hot solver";
    private JTextArea console;
    private boolean isPlotActivated;
    private SolverVisualisation solverVisu;
    private VisuPreferences visuPreferences;
    private boolean gnuplotBased = false;
    private boolean chartBased = false;
    private RemoteControlFrame frame;
    private long begin;
    private long end;
    private int propagationsCounter;
    private int conflictCounter;
    private PrintStream outSolutionFound;

    public DetailedCommandPanel(String string, RemoteControlFrame remoteControlFrame) {
        this(string, "", remoteControlFrame);
    }

    public DetailedCommandPanel(String string, String string2, RemoteControlFrame remoteControlFrame) {
        this(string, string2, new String[0], remoteControlFrame);
    }

    public DetailedCommandPanel(String string, String string2, String[] stringArray, RemoteControlFrame remoteControlFrame) {
        this.frame = remoteControlFrame;
        this.visuPreferences = new VisuPreferences();
        this.telecomStrategy = new RemoteControlStrategy(this);
        this.instancePath = string;
        this.ramdisk = string2;
        this.console = new JTextArea();
        this.commandLines = (String[])stringArray.clone();
        if (stringArray.length > 0) {
            this.solver = Solvers.configureSolver(stringArray, this);
            this.optimizationMode = Solvers.containsOptValue(stringArray);
        }
        this.equivalenceMode = false;
        this.lowerMode = false;
        this.isPlotActivated = false;
        this.startConfig = this.solver != null ? StartSolverEnum.SOLVER_LINE_PARAM_LINE : StartSolverEnum.SOLVER_LIST_PARAM_DEFAULT;
        this.firstStart = true;
        this.setPreferredSize(new Dimension(800, 800));
        this.setLayout(new BoxLayout(this, 1));
        this.createInstancePanel();
        this.createChoixSolverPanel();
        this.restartPanel = new RestartCommandComponent(RESTART_PANEL, this, this.telecomStrategy.getRestartStrategy().getClass().getSimpleName(), this);
        this.rwPanel = new RandomWalkCommandComponent(RW_PANEL, this);
        this.cleanPanel = new CleanCommandComponent(CLEAN_PANEL, this);
        this.phasePanel = new PhaseCommandComponent(PHASE_PANEL, this, this.telecomStrategy.getPhaseSelectionStrategy().getClass().getSimpleName());
        this.simplifierPanel = new SimplifierCommandComponent(SIMPLIFIER_PANEL, this);
        this.hotSolverPanel = new HotSolverCommandComponent(HOT_SOLVER_PANEL, this);
        JScrollPane jScrollPane = new JScrollPane(this.console);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        jScrollPane.getVerticalScrollBar().setValue(jScrollPane.getVerticalScrollBar().getMaximum());
        MyTabbedPane myTabbedPane = new MyTabbedPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.instancePanel);
        jPanel.add(this.choixSolverPanel);
        myTabbedPane.addTab(CHOIX_SOLVER_PANEL, null, jPanel, "instance & solver options");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)this.restartPanel, gridBagConstraints);
        myTabbedPane.addTab("Restart", null, jPanel2, "restart strategy & options");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 19;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 0.2;
        jPanel4.add((Component)this.rwPanel, gridBagConstraints3);
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weighty = 0.2;
        jPanel4.add((Component)this.phasePanel, gridBagConstraints3);
        gridBagConstraints3.gridy = 2;
        jPanel4.add((Component)this.hotSolverPanel, gridBagConstraints3);
        jPanel3.add((Component)jPanel4, gridBagConstraints2);
        myTabbedPane.addTab("Heuristics", null, jPanel3, "random walk and phase strategy");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 19;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 0.2;
        jPanel6.add((Component)this.cleanPanel, gridBagConstraints5);
        gridBagConstraints5.gridy = 1;
        jPanel6.add((Component)this.simplifierPanel, gridBagConstraints5);
        jPanel5.add((Component)jPanel6, gridBagConstraints4);
        myTabbedPane.addTab("Learned Constraints", null, jPanel5, "deletion and simplification strategy");
        this.aboutSolverPanel = new JPanel();
        this.textArea = new JTextArea("No solver is running at the moment");
        this.textArea.setColumns(50);
        this.aboutSolverPanel.add(this.textArea);
        myTabbedPane.addTab("About Solver", null, this.aboutSolverPanel, "information about solver");
        this.add(myTabbedPane);
        this.add(jScrollPane);
        this.restartPanel.setRestartPanelEnabled(false);
        this.rwPanel.setRWPanelEnabled(false);
        this.cleanPanel.setCleanPanelEnabled(false);
        this.phasePanel.setPhasePanelEnabled(false);
        this.simplifierPanel.setSimplifierPanelEnabled(false);
        this.hotSolverPanel.setKeepSolverHotPanelEnabled(false);
        this.solverVisu = new JChartBasedSolverVisualisation(this.visuPreferences);
        this.updateWriter();
    }

    private void createInstancePanel() {
        this.instancePanel = new JPanel();
        this.instancePanel.setName(INSTANCE_PANEL);
        this.instancePanel.setBorder(new CompoundBorder(new TitledBorder(null, this.instancePanel.getName(), 1, 2), BORDER5));
        this.instancePanel.setLayout(new BorderLayout(0, 0));
        this.instanceLabel = new JLabel(INSTANCE);
        this.instancePathField = new JTextField(20);
        this.instancePathField.setText(this.instancePath);
        this.instanceLabel.setLabelFor(this.instancePathField);
        this.browseButton = new JButton(BROWSE);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.openFileChooser();
                DetailedCommandPanel.this.updateListOfSolvers();
            }
        });
        this.optimisationModeCB = new JCheckBox(OPTMIZATION_MODE);
        this.optimisationModeCB.setSelected(this.optimizationMode);
        this.equivalenceCB = new JCheckBox(EQUIVALENCE);
        this.equivalenceCB.setSelected(this.equivalenceMode);
        this.lowerCB = new JCheckBox(LOWER);
        this.lowerCB.setSelected(this.lowerMode);
        JPanel jPanel = new JPanel();
        jPanel.add(this.instanceLabel);
        jPanel.add(this.instancePathField);
        jPanel.add(this.browseButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.optimisationModeCB);
        jPanel2.add(this.equivalenceCB);
        jPanel2.add(this.lowerCB);
        this.optimisationModeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.setOptimisationMode(DetailedCommandPanel.this.optimisationModeCB.isSelected());
                DetailedCommandPanel.this.log("use optimization mode: " + DetailedCommandPanel.this.optimizationMode);
                DetailedCommandPanel.this.updateListOfSolvers();
            }
        });
        this.equivalenceCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.equivalenceMode = DetailedCommandPanel.this.equivalenceCB.isSelected();
            }
        });
        this.lowerCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.lowerMode = DetailedCommandPanel.this.lowerCB.isSelected();
            }
        });
        this.instancePanel.setLayout(new BoxLayout(this.instancePanel, 1));
        this.instancePanel.add(jPanel);
        this.instancePanel.add(jPanel2);
    }

    private void createChoixSolverPanel() {
        this.choixSolverPanel = new JPanel();
        this.choixSolverPanel.setName(CHOIX_SOLVER_PANEL);
        this.choixSolverPanel.setBorder(new CompoundBorder(new TitledBorder(null, this.choixSolverPanel.getName(), 1, 2), BORDER5));
        this.choixSolverPanel.setLayout(new BoxLayout(this.choixSolverPanel, 1));
        this.choixSolver = new JLabel(CHOIX_SOLVER);
        this.listeSolvers = new JComboBox();
        this.updateListOfSolvers();
        JPanel jPanel = new JPanel();
        jPanel.add(this.choixSolver);
        jPanel.add(this.listeSolvers);
        this.startStopButton = new JButton(START);
        this.startStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.manageStartStopButton();
            }
        });
        this.pauseButton = new JButton(PAUSE);
        this.pauseButton.setEnabled(false);
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DetailedCommandPanel.this.pauseButton.getText().equals(DetailedCommandPanel.PAUSE)) {
                    DetailedCommandPanel.this.pauseButton.setText(DetailedCommandPanel.RESUME);
                    DetailedCommandPanel.this.telecomStrategy.setInterrupted(true);
                } else {
                    DetailedCommandPanel.this.pauseButton.setText(DetailedCommandPanel.PAUSE);
                    DetailedCommandPanel.this.telecomStrategy.setInterrupted(false);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setName("Cardinality Constraints Encodings");
        jPanel2.setBorder(new CompoundBorder(new TitledBorder(null, jPanel2.getName(), 1, 2), BORDER5));
        JLabel jLabel = new JLabel(AT_MOST_K);
        this.atMostKCB = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getListOfEncodings(AT_MOST_K).toArray()));
        JLabel jLabel2 = new JLabel(AT_MOST_1);
        this.atMost1CB = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getListOfEncodings(AT_MOST_1).toArray()));
        JLabel jLabel3 = new JLabel(EXACTLY_K);
        this.exactlyKCB = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getListOfEncodings(EXACTLY_K).toArray()));
        JLabel jLabel4 = new JLabel(EXACTLY_1);
        this.exactly1CB = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getListOfEncodings(EXACTLY_1).toArray()));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)this.atMostKCB, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)this.exactlyKCB, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.atMost1CB, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.exactly1CB, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 21;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridx = 0;
        jPanel3.setName(CHOOSE_START_CONFIG);
        jPanel3.setBorder(new CompoundBorder(new TitledBorder(null, jPanel3.getName(), 1, 2), BORDER5));
        this.solverLineParamLineRadio = new JRadioButton(SOLVER_LINE_PARAM_LINE_CONFIG);
        this.solverLineParamRemoteRadio = new JRadioButton(SOLVER_LINE_PARAM_REMOTE_CONFIG);
        this.solverListParamRemoteRadio = new JRadioButton(SOLVER_LIST_PARAM_REMOTE_CONFIG);
        this.solverListParamListRadio = new JRadioButton(SOLVER_LIST_PARAM_LIST_CONFIG);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.solverLineParamLineRadio);
        buttonGroup.add(this.solverLineParamRemoteRadio);
        buttonGroup.add(this.solverListParamListRadio);
        buttonGroup.add(this.solverListParamRemoteRadio);
        this.solverListParamListRadio.setSelected(true);
        this.startConfig = StartSolverEnum.SOLVER_LIST_PARAM_DEFAULT;
        gridBagConstraints2.gridy = 0;
        jPanel3.add((Component)this.solverLineParamLineRadio, gridBagConstraints2);
        gridBagConstraints2.gridy = 1;
        jPanel3.add((Component)this.solverLineParamRemoteRadio, gridBagConstraints2);
        gridBagConstraints2.gridy = 2;
        jPanel3.add((Component)this.solverListParamListRadio, gridBagConstraints2);
        gridBagConstraints2.gridy = 3;
        jPanel3.add((Component)this.solverListParamRemoteRadio, gridBagConstraints2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        jPanel4.add(this.startStopButton);
        jPanel4.add(this.pauseButton);
        this.choixSolverPanel.add(jPanel);
        this.choixSolverPanel.add(jPanel2);
        this.choixSolverPanel.add(jPanel3);
        this.choixSolverPanel.add(jPanel4);
        this.atMostKCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.encodingPolicy.setAtMostKEncoding((EncodingStrategy)((Object)DetailedCommandPanel.this.atMostKCB.getSelectedItem()));
            }
        });
        this.atMost1CB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.encodingPolicy.setAtMostOneEncoding((EncodingStrategy)((Object)DetailedCommandPanel.this.atMost1CB.getSelectedItem()));
            }
        });
        this.exactlyKCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.encodingPolicy.setExactlyKEncoding((EncodingStrategy)((Object)DetailedCommandPanel.this.exactlyKCB.getSelectedItem()));
            }
        });
        this.exactly1CB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.encodingPolicy.setExactlyOneEncoding((EncodingStrategy)((Object)DetailedCommandPanel.this.exactly1CB.getSelectedItem()));
            }
        });
        this.solverLineParamLineRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DetailedCommandPanel.this.solverLineParamLineRadio.isSelected()) {
                    DetailedCommandPanel.this.startConfig = StartSolverEnum.SOLVER_LINE_PARAM_LINE;
                }
            }
        });
        this.solverLineParamRemoteRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DetailedCommandPanel.this.solverLineParamRemoteRadio.isSelected()) {
                    DetailedCommandPanel.this.startConfig = StartSolverEnum.SOLVER_LINE_PARAM_REMOTE;
                }
            }
        });
        this.solverListParamListRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DetailedCommandPanel.this.solverListParamListRadio.isSelected()) {
                    DetailedCommandPanel.this.startConfig = StartSolverEnum.SOLVER_LIST_PARAM_DEFAULT;
                }
            }
        });
        this.solverListParamRemoteRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DetailedCommandPanel.this.solverListParamRemoteRadio.isSelected()) {
                    DetailedCommandPanel.this.startConfig = StartSolverEnum.SOLVER_LIST_PARAM_REMOTE;
                }
            }
        });
        this.setChoixSolverPanelEnabled(true);
        if (this.solver == null) {
            this.solverLineParamLineRadio.setEnabled(false);
            this.solverLineParamRemoteRadio.setEnabled(false);
        }
        if (this.firstStart) {
            this.solverLineParamRemoteRadio.setEnabled(false);
            this.solverListParamRemoteRadio.setEnabled(false);
        }
    }

    public void manageStartStopButton() {
        if (this.startStopButton.getText().equals(START)) {
            this.launchSolverWithConfigs();
            this.pauseButton.setEnabled(true);
            this.setInstancePanelEnabled(false);
            this.restartPanel.setRestartPanelEnabled(true);
            this.rwPanel.setRWPanelEnabled(true);
            this.cleanPanel.setCleanPanelEnabled(true);
            this.cleanPanel.setCleanPanelOriginalStrategyEnabled(true);
            this.phasePanel.setPhasePanelEnabled(true);
            this.setChoixSolverPanelEnabled(false);
            this.simplifierPanel.setSimplifierPanelEnabled(true);
            this.hotSolverPanel.setKeepSolverHotPanelEnabled(true);
            this.startStopButton.setText(STOP);
            this.solverListParamListRadio.setSelected(true);
            this.startConfig = StartSolverEnum.SOLVER_LIST_PARAM_DEFAULT;
            this.getThis().paintAll(this.getThis().getGraphics());
            this.frame.setActivateTracingEditableUnderCondition(false);
            this.frame.setActivateRadioTracing(false);
        } else {
            ((ISolver)this.problem).expireTimeout();
            this.pauseButton.setEnabled(false);
            this.log("Asked the solver to stop");
            this.setInstancePanelEnabled(true);
            this.setChoixSolverPanelEnabled(true);
            this.startStopButton.setText(START);
            this.getThis().paintAll(this.getThis().getGraphics());
            this.frame.setActivateTracingEditable(true);
            this.frame.setActivateRadioTracing(true);
        }
    }

    public String getStartStopText() {
        return this.startStopButton.getText();
    }

    public void setOptimisationMode(boolean bl) {
        this.optimizationMode = bl;
        this.optimisationModeCB.setSelected(bl);
    }

    public void launchSolverWithConfigs() {
        Object object;
        ICDCL iCDCL;
        switch (this.startConfig) {
            case SOLVER_LIST_PARAM_REMOTE: {
                String string = (String)this.listeSolvers.getSelectedItem();
                String[] stringArray = string.split("\\.");
                assert (stringArray.length == 2);
                assert (stringArray[0].equals(MINISAT_PREFIX) || stringArray[0].equals(PB_PREFIX) || stringArray[0].equals(MAXSAT_PREFIX));
                ASolverFactory aSolverFactory = stringArray[0].equals(MINISAT_PREFIX) ? SolverFactory.instance() : (stringArray[0].equals(PB_PREFIX) ? org.sat4j.pb.SolverFactory.instance() : org.sat4j.maxsat.SolverFactory.instance());
                this.solver = (ICDCL)aSolverFactory.createSolverByName(stringArray[1]);
                iCDCL = (ICDCL)this.solver.getSolvingEngine();
                this.telecomStrategy.setSolver(iCDCL);
                iCDCL.setRestartStrategy(this.telecomStrategy);
                iCDCL.setOrder(this.randomWalk);
                iCDCL.getOrder().setPhaseSelectionStrategy(this.telecomStrategy);
                this.restartPanel.hasClickedOnRestart();
                this.rwPanel.hasClickedOnApplyRW();
                this.phasePanel.hasClickedOnApplyPhase();
                this.simplifierPanel.hasClickedOnApplySimplification();
                break;
            }
            case SOLVER_LINE_PARAM_LINE: {
                this.solver = Solvers.configureSolver(this.commandLines, this);
                iCDCL = (ICDCL)this.solver.getSolvingEngine();
                this.telecomStrategy.setSolver(iCDCL);
                this.telecomStrategy.setRestartStrategy(iCDCL.getRestartStrategy());
                iCDCL.setRestartStrategy(this.telecomStrategy);
                this.restartPanel.setCurrentRestart(this.telecomStrategy.getRestartStrategy().getClass().getSimpleName());
                IOrder iOrder = iCDCL.getOrder();
                double d = 0.0;
                if (this.optimizationMode) {
                    if (iOrder instanceof RandomWalkDecoratorObjective) {
                        this.randomWalk = (RandomWalkDecorator)iOrder;
                        d = this.randomWalk.getProbability();
                    } else if (iOrder instanceof VarOrderHeapObjective) {
                        this.randomWalk = new RandomWalkDecoratorObjective((VarOrderHeapObjective)iOrder, 0.0);
                    }
                } else if (iCDCL.getOrder() instanceof RandomWalkDecorator) {
                    this.randomWalk = (RandomWalkDecorator)iOrder;
                    d = this.randomWalk.getProbability();
                } else {
                    this.randomWalk = new RandomWalkDecorator((VarOrderHeap)iOrder, 0.0);
                }
                this.randomWalk.setProbability(d);
                this.rwPanel.setProba(d);
                iCDCL.setOrder(this.randomWalk);
                this.telecomStrategy.setPhaseSelectionStrategy(iCDCL.getOrder().getPhaseSelectionStrategy());
                iCDCL.getOrder().setPhaseSelectionStrategy(this.telecomStrategy);
                this.phasePanel.setPhaseListSelectedItem(this.telecomStrategy.getPhaseSelectionStrategy().getClass().getSimpleName());
                this.simplifierPanel.setSelectedSimplification(iCDCL.getSimplifier().toString());
                this.phasePanel.repaint();
                break;
            }
            case SOLVER_LINE_PARAM_REMOTE: {
                this.solver = Solvers.configureSolver(this.commandLines, this);
                iCDCL = (ICDCL)this.solver.getSolvingEngine();
                iCDCL.setRestartStrategy(this.telecomStrategy);
                iCDCL.setOrder(this.randomWalk);
                iCDCL.getOrder().setPhaseSelectionStrategy(this.telecomStrategy);
                this.restartPanel.hasClickedOnRestart();
                this.rwPanel.hasClickedOnApplyRW();
                this.phasePanel.hasClickedOnApplyPhase();
                this.simplifierPanel.hasClickedOnApplySimplification();
                break;
            }
            default: {
                String string = (String)this.listeSolvers.getSelectedItem();
                String[] stringArray = string.split("\\.");
                assert (stringArray.length == 2);
                assert (stringArray[0].equals(MINISAT_PREFIX) || stringArray[0].equals(PB_PREFIX) || stringArray[0].equals(MAXSAT_PREFIX));
                ASolverFactory aSolverFactory = stringArray[0].equals(MINISAT_PREFIX) ? SolverFactory.instance() : (stringArray[0].equals(PB_PREFIX) ? org.sat4j.pb.SolverFactory.instance() : org.sat4j.maxsat.SolverFactory.instance());
                this.solver = aSolverFactory.createSolverByName(stringArray[1]);
                iCDCL = (ICDCL)this.solver.getSolvingEngine();
                this.telecomStrategy.setSolver(iCDCL);
                this.telecomStrategy.setRestartStrategy(iCDCL.getRestartStrategy());
                iCDCL.setRestartStrategy(this.telecomStrategy);
                this.restartPanel.setCurrentRestart(this.telecomStrategy.getRestartStrategy().getClass().getSimpleName());
                IOrder iOrder = iCDCL.getOrder();
                double d = 0.0;
                if (this.optimizationMode) {
                    if (iOrder instanceof RandomWalkDecoratorObjective) {
                        this.randomWalk = (RandomWalkDecorator)iOrder;
                        d = this.randomWalk.getProbability();
                    } else if (iOrder instanceof VarOrderHeapObjective) {
                        this.randomWalk = new RandomWalkDecoratorObjective((VarOrderHeapObjective)iOrder, 0.0);
                    }
                } else if (iCDCL.getOrder() instanceof RandomWalkDecorator) {
                    this.randomWalk = (RandomWalkDecorator)iOrder;
                    d = this.randomWalk.getProbability();
                } else {
                    this.randomWalk = new RandomWalkDecorator((VarOrderHeap)iOrder, 0.0);
                }
                this.randomWalk.setProbability(d);
                this.rwPanel.setProba(d);
                iCDCL.setOrder(this.randomWalk);
                this.telecomStrategy.setPhaseSelectionStrategy(iCDCL.getOrder().getPhaseSelectionStrategy());
                this.phasePanel.setPhaseListSelectedItem(this.telecomStrategy.getPhaseSelectionStrategy().getClass().getSimpleName());
                iCDCL.getOrder().setPhaseSelectionStrategy(this.telecomStrategy);
                this.simplifierPanel.setSelectedSimplification(iCDCL.getSimplifier().toString());
            }
        }
        this.whereToWriteFiles = this.instancePath;
        if (this.ramdisk.length() > 0) {
            object = this.instancePath.split("/");
            this.whereToWriteFiles = this.ramdisk + "/" + object[((String[])object).length - 1];
        }
        this.solver.setVerbose(true);
        this.initSearchListeners();
        iCDCL.setLogger(this);
        try {
            switch (this.problemType) {
                case PB_OPT: {
                    this.solver = new ClausalConstraintsDecorator((IPBSolver)this.solver, (EncodingStrategyAdapter)this.encodingPolicy);
                    this.solver = this.lowerMode ? new ConstraintRelaxingPseudoOptDecorator((IPBSolver)this.solver) : new PseudoOptDecorator((IPBSolver)this.solver);
                    this.reader = this.createReader(this.solver, this.instancePath);
                    this.problem = this.reader.parseInstance(this.instancePath);
                    this.problem = new OptToPBSATAdapter((IOptimizationProblem)this.problem);
                    break;
                }
                case CNF_MAXSAT: 
                case WCNF_MAXSAT: {
                    this.solver = new ClausalConstraintsDecorator((IPBSolver)this.solver, (EncodingStrategyAdapter)this.encodingPolicy);
                    this.solver = new WeightedMaxSatDecorator((IPBSolver)this.solver, this.equivalenceMode);
                    this.reader = this.createReader(this.solver, this.instancePath);
                    this.problem = this.reader.parseInstance(this.instancePath);
                    this.problem = this.lowerMode ? new ConstraintRelaxingPseudoOptDecorator((WeightedMaxSatDecorator)this.problem) : new PseudoOptDecorator((WeightedMaxSatDecorator)this.problem, false, !this.equivalenceMode);
                    this.problem = new OptToPBSATAdapter((IOptimizationProblem)this.problem);
                    break;
                }
                case PB_SAT: {
                    this.solver = new ClausalConstraintsDecorator((IPBSolver)this.solver, (EncodingStrategyAdapter)this.encodingPolicy);
                    this.reader = this.createReader(this.solver, this.instancePath);
                    this.problem = this.reader.parseInstance(this.instancePath);
                    break;
                }
                default: {
                    this.solver = new ClausalCardinalitiesDecorator<ISolver>(this.solver, this.encodingPolicy);
                    this.reader = this.createReader(this.solver, this.instancePath);
                    this.problem = this.reader.parseInstance(this.instancePath);
                    break;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log(fileNotFoundException.getMessage());
        }
        catch (ParseFormatException parseFormatException) {
            this.log(parseFormatException.getMessage());
        }
        catch (IOException iOException) {
            this.log(iOException.getMessage());
        }
        catch (ContradictionException contradictionException) {
            this.log("Unsatisfiable (trivial)!");
            return;
        }
        this.log("# Started solver " + this.solver.getSolvingEngine().getClass().getSimpleName());
        this.log("# on instance " + this.instancePath);
        this.log("# Optimisation = " + this.optimizationMode);
        this.log("# Restart strategy = " + this.telecomStrategy.getRestartStrategy().getClass().getSimpleName());
        this.log("# Random walk probability = " + this.randomWalk.getProbability());
        this.log("# variables : " + this.solver.nVars());
        object = new Thread(){

            public void run() {
                try {
                    DetailedCommandPanel.this.stringWriter = new StringWriter();
                    if (DetailedCommandPanel.this.problem.isSatisfiable()) {
                        DetailedCommandPanel.this.log("Satisfiable !");
                        if (DetailedCommandPanel.this.problem instanceof OptToPBSATAdapter) {
                            DetailedCommandPanel.this.log(((OptToPBSATAdapter)DetailedCommandPanel.this.problem).getCurrentObjectiveValue() + "");
                            DetailedCommandPanel.this.reader.decode(((OptToPBSATAdapter)DetailedCommandPanel.this.problem).model(new PrintWriter(DetailedCommandPanel.this.stringWriter)), new PrintWriter(DetailedCommandPanel.this.stringWriter));
                        } else {
                            DetailedCommandPanel.this.reader.decode(DetailedCommandPanel.this.problem.model(), new PrintWriter(DetailedCommandPanel.this.stringWriter));
                        }
                        DetailedCommandPanel.this.log(DetailedCommandPanel.this.stringWriter.toString());
                    } else {
                        DetailedCommandPanel.this.log("Unsatisfiable !");
                    }
                }
                catch (TimeoutException timeoutException) {
                    DetailedCommandPanel.this.log("Timeout, sorry!");
                }
            }
        };
        ((Thread)object).start();
        if (this.isPlotActivated) {
            this.solverVisu.setnVar(this.solver.nVars());
            this.startVisu();
        }
    }

    public void initSearchListeners() {
        ArrayList arrayList = new ArrayList();
        if (this.isPlotActivated) {
            if (this.gnuplotBased) {
                this.solverVisu = new GnuplotBasedSolverVisualisation(this.visuPreferences, this.solver.nVars(), this.instancePath, this);
                if (this.visuPreferences.isDisplayClausesEvaluation()) {
                    arrayList.add(new LearnedTracing(new FileBasedVisualizationTool(this.whereToWriteFiles + "-learned")));
                }
                if (this.visuPreferences.isDisplayClausesSize()) {
                    arrayList.add(new LearnedClausesSizeTracing(new FileBasedVisualizationTool(this.whereToWriteFiles + "-learned-clauses-size"), new FileBasedVisualizationTool(this.whereToWriteFiles + "-learned-clauses-size-restart"), new FileBasedVisualizationTool(this.whereToWriteFiles + "-learned-clauses-size-clean")));
                }
                if (this.visuPreferences.isDisplayConflictsDecision()) {
                    arrayList.add(new ConflictLevelTracing(new FileBasedVisualizationTool(this.whereToWriteFiles + "-conflict-level"), new FileBasedVisualizationTool(this.whereToWriteFiles + "-conflict-level-restart"), new FileBasedVisualizationTool(this.whereToWriteFiles + "-conflict-level-clean")));
                }
                if (this.visuPreferences.isDisplayConflictsTrail()) {
                    arrayList.add(new ConflictDepthTracing(new FileBasedVisualizationTool(this.whereToWriteFiles + "-conflict-depth"), new FileBasedVisualizationTool(this.whereToWriteFiles + "-conflict-depth-restart"), new FileBasedVisualizationTool(this.whereToWriteFiles + "-conflict-depth-clean")));
                }
                if (this.visuPreferences.isDisplayDecisionIndexes()) {
                    arrayList.add(new DecisionTracing(new FileBasedVisualizationTool(this.whereToWriteFiles + "-decision-indexes-pos"), new FileBasedVisualizationTool(this.whereToWriteFiles + "-decision-indexes-neg"), new FileBasedVisualizationTool(this.whereToWriteFiles + "-decision-indexes-restart"), new FileBasedVisualizationTool(this.whereToWriteFiles + "-decision-indexes-clean")));
                }
                if (this.visuPreferences.isDisplaySpeed()) {
                    arrayList.add(new SpeedTracing(new FileBasedVisualizationTool(this.whereToWriteFiles + "-speed"), new FileBasedVisualizationTool(this.whereToWriteFiles + "-speed-clean"), new FileBasedVisualizationTool(this.whereToWriteFiles + "-speed-restart")));
                }
                if (this.visuPreferences.isDisplayVariablesEvaluation()) {
                    arrayList.add(new HeuristicsTracing(new FileBasedVisualizationTool(this.whereToWriteFiles + "-heuristics")));
                }
            } else if (this.chartBased) {
                if (this.solverVisu != null) {
                    this.solverVisu.end();
                }
                this.solverVisu = new JChartBasedSolverVisualisation(this.visuPreferences);
                ((JChartBasedSolverVisualisation)this.solverVisu).setnVar(this.solver.nVars());
                if (this.visuPreferences.isDisplayClausesEvaluation()) {
                    arrayList.add(new LearnedTracing(new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getClausesEvaluationTrace())));
                }
                if (this.visuPreferences.isDisplayClausesSize()) {
                    arrayList.add(new LearnedClausesSizeTracing(new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getLearnedClausesSizeTrace()), new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getLearnedClausesSizeRestartTrace()), new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getLearnedClausesSizeCleanTrace())));
                }
                if (this.visuPreferences.isDisplayConflictsDecision()) {
                    arrayList.add(new ConflictLevelTracing(new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getConflictLevelTrace()), new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getConflictLevelRestartTrace()), new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getConflictLevelCleanTrace())));
                }
                if (this.visuPreferences.isDisplayConflictsTrail()) {
                    arrayList.add(new ConflictDepthTracing(new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getConflictDepthTrace()), new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getConflictDepthRestartTrace()), new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getConflictDepthCleanTrace())));
                }
                if (this.visuPreferences.isDisplayDecisionIndexes()) {
                    arrayList.add(new DecisionTracing(new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getPositiveDecisionTrace()), new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getNegativeDecisionTrace()), new ChartBasedVisualizationTool(new TraceComposite(((JChartBasedSolverVisualisation)this.solverVisu).getRestartPosDecisionTrace(), ((JChartBasedSolverVisualisation)this.solverVisu).getRestartNegDecisionTrace())), new ChartBasedVisualizationTool(new TraceComposite(((JChartBasedSolverVisualisation)this.solverVisu).getCleanPosDecisionTrace(), ((JChartBasedSolverVisualisation)this.solverVisu).getCleanNegDecisionTrace()))));
                }
                if (this.visuPreferences.isDisplaySpeed()) {
                    arrayList.add(new SpeedTracing(new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getSpeedTrace()), new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getSpeedCleanTrace()), new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getSpeedRestartTrace())));
                }
                if (this.visuPreferences.isDisplayVariablesEvaluation()) {
                    arrayList.add(new HeuristicsTracing(new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getHeuristicsTrace())));
                }
            }
        }
        arrayList.add(this);
        this.solver.setSearchListener(new MultiTracing(arrayList));
    }

    @Override
    public int getNVar() {
        if (this.solver != null) {
            return this.solver.nVars();
        }
        return 0;
    }

    @Override
    public void setPhaseSelectionStrategy(IPhaseSelectionStrategy iPhaseSelectionStrategy) {
        this.telecomStrategy.setPhaseSelectionStrategy(iPhaseSelectionStrategy);
        this.log("Told the solver to apply a new phase strategy :" + iPhaseSelectionStrategy.getClass().getSimpleName());
    }

    @Override
    public void shouldRestartNow() {
        this.telecomStrategy.setHasClickedOnRestart(true);
    }

    @Override
    public void setRestartStrategy(RestartStrategy restartStrategy) {
        this.telecomStrategy.setRestartStrategy(restartStrategy);
        this.log("Set Restart to " + restartStrategy);
    }

    @Override
    public RestartStrategy getRestartStrategy() {
        return this.telecomStrategy.getRestartStrategy();
    }

    @Override
    public SearchParams getSearchParams() {
        return this.telecomStrategy.getSearchParams();
    }

    @Override
    public SolverStats getSolverStats() {
        return this.telecomStrategy.getSolverStats();
    }

    @Override
    public void init(SearchParams searchParams, SolverStats solverStats) {
        this.telecomStrategy.init(searchParams, solverStats);
        this.log("Init restart with params");
    }

    @Override
    public void setNbClausesAtWhichWeShouldClean(int n) {
        this.telecomStrategy.setNbClausesAtWhichWeShouldClean(n);
        this.log("Changed number of conflicts before cleaning to " + n);
    }

    @Override
    public void setUseTelecomStrategyAsLearnedConstraintsDeletionStrategy() {
        this.telecomStrategy.setUseTelecomStrategyAsLearnedConstraintsDeletionStrategy(true);
        this.log("Solver now cleans clauses every " + this.cleanPanel.getCleanSliderValue() + " conflicts and bases evaluation of clauses on activity");
    }

    @Override
    public void setLearnedDeletionStrategyTypeToSolver(LearnedConstraintsEvaluationType learnedConstraintsEvaluationType) {
        ((ICDCL)this.solver.getSolvingEngine()).setLearnedConstraintsDeletionStrategy(this.telecomStrategy, learnedConstraintsEvaluationType);
        this.log("Changed clauses evaluation type to " + (Object)((Object)learnedConstraintsEvaluationType));
    }

    public LearnedConstraintsEvaluationType getLearnedConstraintsEvaluationType() {
        return LearnedConstraintsEvaluationType.ACTIVITY;
    }

    @Override
    public void shouldCleanNow() {
        this.log("Told the solver to clean");
        this.telecomStrategy.setHasClickedOnClean(true);
    }

    @Override
    public void setKeepSolverHot(boolean bl) {
        this.solver.setKeepSolverHot(bl);
        if (bl) {
            this.log("Keep hot solver is now activated");
        } else {
            this.log("Keep hot solver is now desactivated");
        }
    }

    public boolean isGnuplotBased() {
        return this.gnuplotBased;
    }

    public void setGnuplotBased(boolean bl) {
        this.gnuplotBased = bl;
    }

    public boolean isChartBased() {
        return this.chartBased;
    }

    public void setChartBased(boolean bl) {
        this.chartBased = bl;
    }

    public boolean isPlotActivated() {
        return this.isPlotActivated;
    }

    public void setPlotActivated(boolean bl) {
        this.isPlotActivated = bl;
    }

    @Override
    public void setRandomWalkProba(double d) {
        this.randomWalk.setProbability(d);
        this.log("Set probability to " + d);
    }

    @Override
    public void setSimplifier(SimplificationType simplificationType) {
        ((ICDCL)this.solver.getSolvingEngine()).setSimplifier(simplificationType);
        this.log("Told the solver to use " + (Object)((Object)simplificationType));
    }

    public List<String> getListOfSolvers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ASolverFactory aSolverFactory = SolverFactory.instance();
        for (String string : aSolverFactory.solverNames()) {
            arrayList.add("minisat." + string);
        }
        aSolverFactory = org.sat4j.pb.SolverFactory.instance();
        for (String string : aSolverFactory.solverNames()) {
            arrayList.add("pb." + string);
        }
        Collections.sort(arrayList);
        aSolverFactory = org.sat4j.maxsat.SolverFactory.instance();
        for (String string : aSolverFactory.solverNames()) {
            arrayList.add("maxsat." + string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<String> getListOfSatSolvers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        SolverFactory solverFactory = SolverFactory.instance();
        for (String string : solverFactory.solverNames()) {
            arrayList.add("minisat." + string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<String> getListOfPBSolvers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        org.sat4j.pb.SolverFactory solverFactory = org.sat4j.pb.SolverFactory.instance();
        for (String string : solverFactory.solverNames()) {
            arrayList.add("pb." + string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<String> getListOfMaxsatSolvers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        org.sat4j.pb.SolverFactory solverFactory = org.sat4j.pb.SolverFactory.instance();
        for (String string : solverFactory.solverNames()) {
            arrayList.add("maxsat." + string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<EncodingStrategy> getListOfEncodings(String string) {
        ArrayList<EncodingStrategy> arrayList = new ArrayList<EncodingStrategy>();
        arrayList.add(EncodingStrategy.NATIVE);
        if (string.equals(AT_MOST_K) || string.equals(AT_MOST_1)) {
            arrayList.add(EncodingStrategy.BINARY);
            arrayList.add(EncodingStrategy.BINOMIAL);
            arrayList.add(EncodingStrategy.COMMANDER);
        }
        if (string.equals(AT_MOST_K)) {
            arrayList.add(EncodingStrategy.SEQUENTIAL);
        }
        if (string.equals(AT_MOST_1) || string.equals(EXACTLY_1)) {
            arrayList.add(EncodingStrategy.LADDER);
        }
        if (string.equals(AT_MOST_1)) {
            arrayList.add(EncodingStrategy.PRODUCT);
        }
        return arrayList;
    }

    @Override
    public void log(String string) {
        this.logsameline(string + "\n");
    }

    public void logsameline(String string) {
        if (this.console != null) {
            this.console.append(string);
            this.console.setCaretPosition(this.console.getDocument().getLength());
            this.console.repaint();
        }
        this.repaint();
    }

    public void openFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showDialog(this, "Choose instance");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.instancePath = file.getAbsolutePath();
            this.instancePathField.setText(this.instancePath);
            this.updateListOfSolvers();
        }
    }

    protected Reader createReader(ISolver iSolver, String string) {
        InstanceReader instanceReader = new InstanceReader(iSolver);
        switch (this.problemType) {
            case CNF_MAXSAT: 
            case WCNF_MAXSAT: {
                instanceReader = new MSInstanceReader((WeightedMaxSatDecorator)iSolver);
                break;
            }
            case PB_OPT: 
            case PB_SAT: {
                instanceReader = new PBInstanceReader((IPBSolver)iSolver);
                break;
            }
            case CNF_SAT: {
                instanceReader = new InstanceReader(iSolver);
            }
        }
        return instanceReader;
    }

    public void updateListOfSolvers() {
        List<Object> list = new ArrayList();
        String string = "";
        if (this.instancePath == null || this.instancePath.length() == 0) {
            list = this.getListOfSolvers();
            string = "minisat.Default";
            this.problemType = ProblemType.CNF_SAT;
            this.equivalenceCB.setEnabled(false);
            this.lowerCB.setEnabled(false);
        } else if (this.instancePath.endsWith(".cnf")) {
            this.optimisationModeCB.setEnabled(true);
            if (this.optimizationMode) {
                list.addAll(this.getListOfMaxsatSolvers());
                list.addAll(this.getListOfPBSolvers());
                string = "maxsat.Default";
                this.equivalenceCB.setEnabled(true);
                this.lowerCB.setEnabled(true);
                this.problemType = ProblemType.CNF_MAXSAT;
                this.log("cnf file + opt => pb/maxsat solvers");
            } else {
                list.addAll(this.getListOfSatSolvers());
                list.addAll(this.getListOfPBSolvers());
                string = "minisat.Default";
                this.log("cnf file + non opt => sat/pb solvers");
                this.problemType = ProblemType.CNF_SAT;
                this.equivalenceCB.setEnabled(false);
                this.lowerCB.setEnabled(false);
            }
        } else if (this.instancePath.endsWith(".opb")) {
            this.optimisationModeCB.setEnabled(true);
            list.addAll(this.getListOfPBSolvers());
            string = "pb.Default";
            if (this.optimizationMode) {
                this.problemType = ProblemType.PB_OPT;
                this.equivalenceCB.setEnabled(true);
                this.lowerCB.setEnabled(true);
            } else {
                this.problemType = ProblemType.PB_SAT;
                this.equivalenceCB.setEnabled(false);
                this.lowerCB.setEnabled(false);
            }
            this.log("opb file => pb solvers");
        } else if (this.instancePath.endsWith(".wcnf")) {
            this.equivalenceCB.setEnabled(true);
            this.lowerCB.setEnabled(true);
            list.addAll(this.getListOfMaxsatSolvers());
            list.addAll(this.getListOfPBSolvers());
            string = "maxsat.Default";
            this.optimisationModeCB.setSelected(true);
            this.optimisationModeCB.setEnabled(false);
            this.problemType = ProblemType.WCNF_MAXSAT;
            this.log("wcnf file => pb/maxsat solvers");
        }
        this.listeSolvers.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.listeSolvers.setSelectedItem(string);
        this.choixSolverPanel.repaint();
    }

    public void setInstancePanelEnabled(boolean bl) {
        this.instanceLabel.setEnabled(bl);
        this.instancePathField.setEnabled(bl);
        this.browseButton.setEnabled(bl);
        this.instancePanel.repaint();
    }

    public void setChoixSolverPanelEnabled(boolean bl) {
        this.listeSolvers.setEnabled(bl);
        this.choixSolver.setEnabled(bl);
        this.solverLineParamLineRadio.setEnabled(bl);
        this.solverLineParamRemoteRadio.setEnabled(bl);
        this.solverListParamListRadio.setEnabled(bl);
        this.solverListParamRemoteRadio.setEnabled(bl);
        this.choixSolverPanel.repaint();
    }

    public void setSolverVisualisation(SolverVisualisation solverVisualisation) {
        this.solverVisu = solverVisualisation;
    }

    public void activateGnuplotTracing(boolean bl) {
        this.isPlotActivated = bl;
        if (this.solver != null) {
            this.initSearchListeners();
        }
    }

    public void startVisu() {
        this.solverVisu.start();
    }

    public void stopVisu() {
        this.solverVisu.end();
    }

    public VisuPreferences getGnuplotPreferences() {
        return this.visuPreferences;
    }

    public void setGnuplotPreferences(VisuPreferences visuPreferences) {
        this.visuPreferences = visuPreferences;
    }

    public DetailedCommandPanel getThis() {
        return this;
    }

    public ISolver getSolver() {
        return (ISolver)this.problem;
    }

    private void updateWriter() {
        try {
            this.outSolutionFound = new PrintStream(new FileOutputStream(this.whereToWriteFiles + "_solutions.dat"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.outSolutionFound = System.out;
        }
    }

    @Override
    public void init(ISolverService iSolverService) {
        this.conflictCounter = 0;
    }

    @Override
    public void assuming(int n) {
    }

    @Override
    public void propagating(int n, IConstr iConstr) {
        this.end = System.currentTimeMillis();
        if (this.end - this.begin >= 2000L) {
            long l = this.end - this.begin;
            this.cleanPanel.setSpeedLabeltext((long)this.propagationsCounter / l * 1000L + "");
            this.begin = System.currentTimeMillis();
            this.propagationsCounter = 0;
        }
        ++this.propagationsCounter;
    }

    @Override
    public void backtracking(int n) {
    }

    @Override
    public void adding(int n) {
    }

    @Override
    public void learn(IConstr iConstr) {
    }

    @Override
    public void delete(int[] nArray) {
    }

    @Override
    public void conflictFound(IConstr iConstr, int n, int n2) {
        ++this.conflictCounter;
    }

    @Override
    public void conflictFound(int n) {
    }

    @Override
    public void solutionFound(int[] nArray, RandomAccessModel randomAccessModel) {
        this.log("Found a solution !! ");
        this.logsameline(this.stringWriter.toString());
        this.stringWriter.getBuffer().delete(0, this.stringWriter.getBuffer().length());
        this.outSolutionFound.println(this.conflictCounter + "\t");
    }

    @Override
    public void beginLoop() {
    }

    @Override
    public void start() {
    }

    @Override
    public void end(Lbool lbool) {
    }

    @Override
    public void restarting() {
        this.end = System.currentTimeMillis();
        if (this.end != this.begin) {
            this.cleanPanel.setSpeedLabeltext((long)this.propagationsCounter / (this.end - this.begin) * 1000L + "");
        }
    }

    @Override
    public void backjump(int n) {
    }

    @Override
    public void cleaning() {
        this.end = System.currentTimeMillis();
        this.cleanPanel.setSpeedLabeltext((long)this.propagationsCounter / (this.end - this.begin) * 1000L + "");
    }

    public class MyTabbedPane
    extends JTabbedPane {
        private static final long serialVersionUID = 1L;

        public void setSelectedIndex(int n) {
            if (this.getTabCount() == 5 && n == 4) {
                if (DetailedCommandPanel.this.solver != null && DetailedCommandPanel.this.startStopButton.getText().equals(DetailedCommandPanel.STOP)) {
                    String string = DetailedCommandPanel.this.solver.toString();
                    String string2 = DetailedCommandPanel.this.solver.toString();
                    int n2 = 0;
                    for (int i = 0; i < string.length(); ++i) {
                        n2 = string.charAt(i) != '\n' ? ++n2 : 0;
                        if (n2 <= 80) continue;
                        string2 = new StringBuffer(string2).insert(i, '\n').toString();
                        n2 = 0;
                    }
                    DetailedCommandPanel.this.textArea.setText(string2);
                    DetailedCommandPanel.this.textArea.setEditable(false);
                    DetailedCommandPanel.this.textArea.repaint();
                    DetailedCommandPanel.this.aboutSolverPanel.paint(DetailedCommandPanel.this.aboutSolverPanel.getGraphics());
                    DetailedCommandPanel.this.aboutSolverPanel.repaint();
                } else {
                    DetailedCommandPanel.this.textArea.setText("No solver is running at the moment");
                    DetailedCommandPanel.this.textArea.repaint();
                    DetailedCommandPanel.this.textArea.setEditable(false);
                    DetailedCommandPanel.this.aboutSolverPanel.paint(DetailedCommandPanel.this.aboutSolverPanel.getGraphics());
                    DetailedCommandPanel.this.aboutSolverPanel.repaint();
                }
            }
            super.setSelectedIndex(n);
        }
    }
}

