/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.sat4j.sat.CommandComponent;
import org.sat4j.sat.DetailedCommandPanel;
import org.sat4j.sat.SolverController;

public class HotSolverCommandComponent
extends CommandComponent {
    private static final long serialVersionUID = 1L;
    private SolverController controller;
    private JCheckBox keepSolverHotCB;
    private static final String KEEP_SOLVER_HOT = "Keep solver hot";
    private JButton applyHotSolver;
    private static final String HOT_APPLY = "Apply";

    public HotSolverCommandComponent(String string, SolverController solverController) {
        this.setName(string);
        this.controller = solverController;
        this.createPanel();
    }

    public void createPanel() {
        this.createHotSolverPanel();
    }

    public void createHotSolverPanel() {
        this.setBorder(new CompoundBorder(new TitledBorder(null, this.getName(), 1, 2), DetailedCommandPanel.BORDER5));
        this.setLayout(new BorderLayout());
        this.keepSolverHotCB = new JCheckBox(KEEP_SOLVER_HOT);
        this.add((Component)this.keepSolverHotCB, "Center");
        JPanel jPanel = new JPanel();
        this.applyHotSolver = new JButton(HOT_APPLY);
        jPanel.add(this.applyHotSolver);
        this.add((Component)jPanel, "South");
        this.applyHotSolver.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HotSolverCommandComponent.this.controller.setKeepSolverHot(HotSolverCommandComponent.this.keepSolverHotCB.isSelected());
            }
        });
    }

    public void setKeepSolverHotPanelEnabled(boolean bl) {
        this.keepSolverHotCB.setEnabled(bl);
        this.applyHotSolver.setEnabled(bl);
        this.repaint();
    }
}

