/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ICDCL;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.core.IPBCDCLSolver;
import org.sat4j.pb.reader.PBInstanceReader;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.sat.RemoteControlFrame;
import org.sat4j.sat.Solvers;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ConflictDepthTracing;
import org.sat4j.tools.ConflictLevelTracing;
import org.sat4j.tools.DecisionTracing;
import org.sat4j.tools.DotSearchTracing;
import org.sat4j.tools.FileBasedVisualizationTool;
import org.sat4j.tools.LearnedClausesSizeTracing;
import org.sat4j.tools.MultiTracing;

@Deprecated
public class Lanceur
extends AbstractLauncher
implements ILogAble {
    private static final String NUMBER = "number";
    private static final long serialVersionUID = 1L;
    private static final String CURRENT_OPTIMUM_VALUE_PREFIX = "o ";
    private boolean incomplete = false;
    private boolean isModeOptimization = false;
    private IProblem problem;
    private boolean modeTracing = false;
    private boolean launchRemoteControl;
    private static AbstractLauncher lanceur;
    private String filename;
    private int k = -1;

    public static void main(String[] stringArray) {
        lanceur = new Lanceur();
        lanceur.run(stringArray);
    }

    protected ICDCL configureSolver(String[] stringArray) {
        Options options = Lanceur.createCLIOptions();
        try {
            String[] stringArray2;
            Object object;
            Serializable serializable;
            CommandLine commandLine = new PosixParser().parse(options, stringArray);
            if (commandLine.hasOption("opt")) {
                this.isModeOptimization = true;
            }
            String string = commandLine.getOptionValue("l");
            if (this.isModeOptimization) {
                string = "pb";
            } else if (string == null) {
                string = "minisat";
            }
            try {
                serializable = Class.forName("org.sat4j." + string + ".SolverFactory");
                object = new Class[]{};
                stringArray2 = ((Class)serializable).getMethod("instance", (Class<?>)object);
            }
            catch (Exception exception) {
                this.log("Wrong framework: " + string + ". Using minisat instead.");
            }
            serializable = Solvers.configureSolver(stringArray, this);
            this.launchRemoteControl = commandLine.hasOption("remote");
            this.filename = commandLine.getOptionValue("f");
            if (commandLine.hasOption("d")) {
                object = null;
                if (this.filename != null) {
                    object = commandLine.getOptionValue("d");
                }
                if (object == null) {
                    object = "sat4j.dot";
                }
                serializable.setSearchListener(new DotSearchTracing((String)object, null));
            }
            if (commandLine.hasOption("m")) {
                this.setSilent(true);
            }
            if (commandLine.hasOption("k") && (object = Integer.valueOf(commandLine.getOptionValue("k"))) != null) {
                this.k = (Integer)object;
            }
            if (this.isModeOptimization) {
                assert (serializable instanceof IPBSolver);
                this.problem = new PseudoOptDecorator((IPBCDCLSolver)serializable);
            }
            int n = 0;
            stringArray2 = commandLine.getArgs();
            if (this.filename == null && stringArray2.length > 0) {
                this.filename = stringArray2[n++];
            }
            if (commandLine.hasOption("r")) {
                this.modeTracing = true;
                if (!commandLine.hasOption("remote")) {
                    serializable.setSearchListener(new MultiTracing(new ConflictLevelTracing(new FileBasedVisualizationTool(this.filename + "-conflict-level"), new FileBasedVisualizationTool(this.filename + "-conflict-level-restart"), new FileBasedVisualizationTool(this.filename + "-conflict-level-clean")), new DecisionTracing(new FileBasedVisualizationTool(this.filename + "-decision-indexes-pos"), new FileBasedVisualizationTool(this.filename + "-decision-indexes-neg"), new FileBasedVisualizationTool(this.filename + "-decision-indexes-restart"), new FileBasedVisualizationTool(this.filename + "-decision-indexes-clean")), new LearnedClausesSizeTracing(new FileBasedVisualizationTool(this.filename + "-learned-clauses-size"), new FileBasedVisualizationTool(this.filename + "-learned-clauses-size-restart"), new FileBasedVisualizationTool(this.filename + "-learned-clauses-size-clean")), new ConflictDepthTracing(new FileBasedVisualizationTool(this.filename + "-conflict-depth"), new FileBasedVisualizationTool(this.filename + "-conflict-depth-restart"), new FileBasedVisualizationTool(this.filename + "-conflict-depth-clean"))));
                }
            }
            while (n < stringArray2.length) {
                String[] stringArray3 = stringArray2[n].split("=");
                assert (stringArray3.length == 2);
                this.log("setting " + stringArray3[0] + " to " + stringArray3[1]);
                try {
                    BeanUtils.setProperty(serializable, stringArray3[0], stringArray3[1]);
                }
                catch (Exception exception) {
                    this.log("Cannot set parameter : " + stringArray[n]);
                }
                ++n;
            }
            this.getLogWriter().println(serializable.toString("c "));
            return serializable;
        }
        catch (ParseException parseException) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j.jar", options, true);
            this.usage();
            return null;
        }
    }

    protected Reader createReader(ISolver iSolver, String string) {
        if (iSolver instanceof IPBSolver) {
            return new PBInstanceReader((IPBSolver)iSolver);
        }
        return new InstanceReader(iSolver);
    }

    public void displayLicense() {
        super.displayLicense();
        this.log("This software uses some libraries from the Jakarta Commons project. See jakarta.apache.org for details.");
    }

    protected String getInstanceName(String[] stringArray) {
        return this.filename;
    }

    protected IProblem readProblem(String string) throws ParseFormatException, IOException, ContradictionException {
        ISolver iSolver = (ISolver)super.readProblem(string);
        if (this.k > 0) {
            VecInt vecInt = new VecInt();
            for (int i = 1; i <= iSolver.nVars(); ++i) {
                vecInt.push(-i);
            }
            iSolver.addAtLeast(vecInt, this.k);
            this.log("Limiting solutions to those having at least " + this.k + " variables assigned to false");
        }
        return iSolver;
    }

    protected void solve(IProblem iProblem) throws TimeoutException {
        block12: {
            if (this.isModeOptimization) {
                boolean bl = false;
                IOptimizationProblem iOptimizationProblem = (IOptimizationProblem)iProblem;
                try {
                    while (iOptimizationProblem.admitABetterSolution()) {
                        if (!bl) {
                            if (iOptimizationProblem.nonOptimalMeansSatisfiable()) {
                                this.setExitCode(ExitCode.SATISFIABLE);
                                if (iOptimizationProblem.hasNoObjectiveFunction()) {
                                    return;
                                }
                                this.log("SATISFIABLE");
                            } else if (this.incomplete) {
                                this.setExitCode(ExitCode.UPPER_BOUND);
                            }
                            bl = true;
                            this.log("OPTIMIZING...");
                        }
                        this.log("Got one! Elapsed wall clock time (in seconds):" + (double)(System.currentTimeMillis() - this.getBeginTime()) / 1000.0);
                        this.getLogWriter().println(CURRENT_OPTIMUM_VALUE_PREFIX + iOptimizationProblem.getObjectiveValue());
                        iOptimizationProblem.discardCurrentSolution();
                    }
                    if (bl) {
                        this.setExitCode(ExitCode.OPTIMUM_FOUND);
                        break block12;
                    }
                    this.setExitCode(ExitCode.UNSATISFIABLE);
                }
                catch (ContradictionException contradictionException) {
                    assert (bl);
                    this.setExitCode(ExitCode.OPTIMUM_FOUND);
                }
            } else {
                this.exitCode = iProblem.isSatisfiable() ? ExitCode.SATISFIABLE : ExitCode.UNSATISFIABLE;
            }
        }
    }

    protected void displayResult() {
        if (this.isModeOptimization) {
            this.displayAnswer();
            this.log("Total wall clock time (in seconds): " + (double)(System.currentTimeMillis() - this.getBeginTime()) / 1000.0);
        } else {
            super.displayResult();
        }
    }

    protected void displayAnswer() {
        if (this.solver == null) {
            return;
        }
        System.out.flush();
        PrintWriter printWriter = this.getLogWriter();
        printWriter.flush();
        this.solver.printStat(printWriter, "c ");
        this.solver.printInfos(printWriter, "c ");
        ExitCode exitCode = this.getExitCode();
        printWriter.println("s " + exitCode);
        if (exitCode == ExitCode.SATISFIABLE || exitCode == ExitCode.OPTIMUM_FOUND || this.incomplete && exitCode == ExitCode.UPPER_BOUND) {
            IOptimizationProblem iOptimizationProblem;
            printWriter.print("v ");
            this.getReader().decode(this.problem.model(), printWriter);
            printWriter.println();
            if (this.isModeOptimization && !(iOptimizationProblem = (IOptimizationProblem)this.problem).hasNoObjectiveFunction()) {
                this.log("objective function=" + iOptimizationProblem.getObjectiveValue());
            }
        }
    }

    public void run(String[] stringArray) {
        block13: {
            try {
                String string;
                this.displayHeader();
                this.solver = this.configureSolver(stringArray);
                if (this.solver == null) {
                    this.usage();
                    return;
                }
                if (!this.silent) {
                    this.solver.setVerbose(true);
                }
                if ((string = this.getInstanceName(stringArray)) == null) {
                    this.usage();
                    return;
                }
                this.beginTime = System.currentTimeMillis();
                if (!this.launchRemoteControl) {
                    this.readProblem(string);
                    try {
                        if (this.problem != null) {
                            this.solve(this.problem);
                        } else {
                            this.solve(this.solver);
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        this.log("timeout");
                    }
                    System.exit(lanceur.getExitCode().value());
                    break block13;
                }
                RemoteControlFrame remoteControlFrame = new RemoteControlFrame(this.filename, "", stringArray);
                remoteControlFrame.activateTracing(this.modeTracing);
                remoteControlFrame.setOptimisationMode(this.isModeOptimization);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("FATAL " + fileNotFoundException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                System.err.println("FATAL " + iOException.getLocalizedMessage());
            }
            catch (ContradictionException contradictionException) {
                this.exitCode = ExitCode.UNSATISFIABLE;
                this.log("(trivial inconsistency)");
            }
            catch (ParseFormatException parseFormatException) {
                System.err.println("FATAL " + parseFormatException.getLocalizedMessage());
            }
        }
    }

    public void usage() {
        Solvers.usage(this);
    }

    public static Options createCLIOptions() {
        Options options = new Options();
        options.addOption("l", "library", true, "specifies the name of the library used (minisat by default)");
        options.addOption("s", "solver", true, "specifies the name of a prebuilt solver from the library");
        options.addOption("S", "Solver", true, "setup a solver using a solver config string");
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("C", "conflictbased", false, "conflict based timeout (for deterministic behavior)");
        options.addOption("d", "dot", true, "creates a sat4j.dot file in current directory representing the search");
        options.addOption("f", "filename", true, "specifies the file to use (in conjunction with -d for instance)");
        options.addOption("m", "mute", false, "Set launcher in silent mode");
        options.addOption("k", "kleast", true, "limit the search to models having at least k variables set to false");
        options.addOption("r", "trace", false, "traces the behavior of the solver");
        options.addOption("opt", "optimize", false, "uses solver in optimize mode instead of sat mode (default)");
        options.addOption("rw", "randomWalk", true, "specifies the random walk probability ");
        options.addOption("remote", "remoteControl", false, "launches remote control");
        options.addOption("H", "hot", false, "keep the solver hot (do not reset heuristics) when a model is found");
        options.addOption("y", "simplify", false, "simplify the set of clauses is possible");
        Option option = options.getOption("l");
        option.setArgName("libname");
        option = options.getOption("s");
        option.setArgName("solvername");
        option = options.getOption("S");
        option.setArgName("solverStringDefinition");
        option = options.getOption("t");
        option.setArgName(NUMBER);
        option = options.getOption("T");
        option.setArgName(NUMBER);
        option = options.getOption("C");
        option.setArgName(NUMBER);
        option = options.getOption("k");
        option.setArgName(NUMBER);
        option = options.getOption("d");
        option.setArgName("filename");
        option = options.getOption("f");
        option.setArgName("filename");
        option = options.getOption("r");
        option.setArgName("searchlistener");
        option = options.getOption("rw");
        option.setArgName(NUMBER);
        return options;
    }
}

