/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.sat4j.sat.CommandComponent;
import org.sat4j.sat.DetailedCommandPanel;
import org.sat4j.sat.SolverController;

public class RandomWalkCommandComponent
extends CommandComponent {
    private static final long serialVersionUID = 1L;
    private SolverController controller;
    private JLabel probaRWLabel;
    private JTextField probaRWField;
    private JButton applyRWButton;
    private static final String RW_LABEL = "Probabilty : ";
    private static final String RW_APPLY = "Apply";

    public RandomWalkCommandComponent(String string, SolverController solverController) {
        this.controller = solverController;
        this.setName(string);
        this.createPanel();
    }

    public void createPanel() {
        this.createRWPanel();
    }

    public void createRWPanel() {
        this.setBorder(new CompoundBorder(new TitledBorder(null, this.getName(), 1, 2), DetailedCommandPanel.BORDER5));
        this.setLayout(new BorderLayout());
        this.probaRWLabel = new JLabel(RW_LABEL);
        this.probaRWField = new JTextField("0", 10);
        this.probaRWLabel.setLabelFor(this.probaRWField);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.probaRWLabel);
        jPanel.add(this.probaRWField);
        JPanel jPanel2 = new JPanel();
        this.applyRWButton = new JButton(RW_APPLY);
        this.applyRWButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RandomWalkCommandComponent.this.hasClickedOnApplyRW();
            }
        });
        jPanel2.add(this.applyRWButton);
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
    }

    public void hasClickedOnApplyRW() {
        double d = 0.0;
        if (this.probaRWField != null) {
            d = Double.parseDouble(this.probaRWField.getText());
        }
        this.controller.setRandomWalkProba(d);
    }

    public void setRWPanelEnabled(boolean bl) {
        this.probaRWLabel.setEnabled(bl);
        this.probaRWField.setEnabled(bl);
        this.applyRWButton.setEnabled(bl);
        this.repaint();
    }

    public void setProba(double d) {
        this.probaRWField.setText(d + "");
        this.repaint();
    }
}

