/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import org.sat4j.sat.DetailedCommandPanel;
import org.sat4j.sat.visu.VisuPreferencesFrame;
import org.sat4j.specs.ILogAble;

public class RemoteControlFrame
extends JFrame
implements ILogAble {
    private static final long serialVersionUID = 1L;
    private JMenuItem activateTracing;
    private JRadioButtonMenuItem gnuplotBasedRadio;
    private JRadioButtonMenuItem jChartBasedRadio;
    private DetailedCommandPanel commandePanel;
    private String filename;
    private String ramdisk;
    private String[] args;
    private VisuPreferencesFrame visuFrame;
    private static final String ACTIVATE = "Activate Tracing";
    private static final String DEACTIVATE = "Deactivate Tracing";

    public RemoteControlFrame(String string, String string2, String[] stringArray) {
        super("Remote Control");
        this.filename = string;
        this.ramdisk = string2;
        this.args = (String[])stringArray.clone();
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.createAndShowGUI();
    }

    public RemoteControlFrame(String string, String string2) {
        this(string, string2, new String[0]);
    }

    public RemoteControlFrame(String string) {
        this(string, "", new String[0]);
    }

    public RemoteControlFrame(String string, String[] stringArray) {
        this(string, "", stringArray);
    }

    public void reinitialiser() {
    }

    public void setActivateGnuplot(boolean bl) {
        this.activateTracing.setSelected(bl);
        this.activateTracing(bl);
    }

    private void createAndShowGUI() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.createMenuBar();
        this.commandePanel = new DetailedCommandPanel(this.filename, this.ramdisk, this.args, this);
        this.commandePanel.setChartBased(true);
        this.commandePanel.activateGnuplotTracing(true);
        this.visuFrame = new VisuPreferencesFrame(this.commandePanel.getGnuplotPreferences());
        JScrollPane jScrollPane = new JScrollPane(this.commandePanel);
        this.add(jScrollPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RemoteControlFrame.this.commandePanel.stopVisu();
                RemoteControlFrame.this.setVisible(false);
                RemoteControlFrame.this.dispose();
            }
        });
        this.pack();
        this.setVisible(true);
    }

    public void clickOnAboutSolver() {
        if (this.commandePanel.getSolver() != null) {
            JOptionPane.showMessageDialog(this, this.commandePanel.getSolver().toString());
        } else {
            JOptionPane.showMessageDialog(this, "No solver is running at the moment. Please start solver.");
        }
    }

    public void setActivateTracingEditableUnderCondition(boolean bl) {
        if (this.activateTracing.getText().equals(ACTIVATE)) {
            this.activateTracing.setEnabled(bl);
        }
    }

    public void setActivateTracingEditable(boolean bl) {
        this.activateTracing.setEnabled(bl);
    }

    public void setActivateRadioTracing(boolean bl) {
        this.gnuplotBasedRadio.setEnabled(bl);
        this.jChartBasedRadio.setEnabled(bl);
    }

    public void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        this.activateTracing = new JMenuItem(DEACTIVATE);
        jMenu.add(this.activateTracing);
        this.activateTracing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteControlFrame.this.activateTracing(RemoteControlFrame.this.activateTracing.getText().equals(RemoteControlFrame.ACTIVATE));
            }
        });
        jMenu.addSeparator();
        this.gnuplotBasedRadio = new JRadioButtonMenuItem("Trace with Gnuplot");
        this.jChartBasedRadio = new JRadioButtonMenuItem("Trace with Java");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.gnuplotBasedRadio);
        buttonGroup.add(this.jChartBasedRadio);
        jMenu.add(this.gnuplotBasedRadio);
        this.gnuplotBasedRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteControlFrame.this.commandePanel.setGnuplotBased(true);
                RemoteControlFrame.this.commandePanel.setChartBased(false);
                RemoteControlFrame.this.commandePanel.activateGnuplotTracing(RemoteControlFrame.this.activateTracing.getText().equals(RemoteControlFrame.DEACTIVATE));
                RemoteControlFrame.this.log("Use gnuplot tracing");
            }
        });
        this.jChartBasedRadio.setSelected(true);
        jMenu.add(this.jChartBasedRadio);
        this.jChartBasedRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteControlFrame.this.commandePanel.setGnuplotBased(false);
                RemoteControlFrame.this.commandePanel.setChartBased(true);
                RemoteControlFrame.this.commandePanel.activateGnuplotTracing(RemoteControlFrame.this.activateTracing.getText().equals(RemoteControlFrame.DEACTIVATE));
                RemoteControlFrame.this.log("Use java tracing");
            }
        });
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteControlFrame.this.commandePanel.stopVisu();
                System.exit(0);
            }
        });
        JMenu jMenu2 = new JMenu("Preferences");
        JMenuItem jMenuItem2 = new JMenuItem("Visualisation preferences");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteControlFrame.this.visuFrame.setVisible(true);
            }
        });
        jMenu2.add(jMenuItem2);
        jMenuBar.add(jMenu2);
        jMenuBar.add(Box.createHorizontalGlue());
        JLabel jLabel = new JLabel(this.getVersion());
        jMenuBar.add(jLabel);
        this.setJMenuBar(jMenuBar);
    }

    public void log(String string) {
        this.commandePanel.log(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion() {
        URL uRL = RemoteControlFrame.class.getResource("/sat4j.version");
        String string = "";
        if (uRL == null) {
            string = "no version file found!!!";
        } else {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                string = "version " + bufferedReader.readLine();
            }
            catch (IOException iOException) {
                string = "c ERROR: " + iOException.getMessage();
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        string = "c ERROR: " + iOException.getMessage();
                    }
                }
            }
        }
        return string;
    }

    public void activateTracing(boolean bl) {
        if (bl) {
            this.log("Activated tracing");
            this.activateTracing.setText(DEACTIVATE);
            this.commandePanel.setPlotActivated(true);
        } else {
            this.log("Deactivated tracing.");
            this.activateTracing.setText(ACTIVATE);
            this.commandePanel.stopVisu();
            this.commandePanel.setPlotActivated(false);
        }
        if (this.commandePanel.getStartStopText().equals("Stop") && this.activateTracing.getText().equals(ACTIVATE)) {
            this.activateTracing.setEnabled(false);
        } else {
            this.activateTracing.setEnabled(true);
        }
    }

    public void setOptimisationMode(boolean bl) {
        this.commandePanel.setOptimisationMode(bl);
    }
}

