/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.restarts.LubyRestarts;
import org.sat4j.minisat.restarts.NoRestarts;
import org.sat4j.sat.CommandComponent;
import org.sat4j.sat.DetailedCommandPanel;
import org.sat4j.sat.RTSI;
import org.sat4j.sat.SolverController;
import org.sat4j.specs.ILogAble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestartCommandComponent
extends CommandComponent {
    private static final long serialVersionUID = 1L;
    private JPanel restartPropertiesPanel;
    private JLabel chooseRestartStrategyLabel;
    private JLabel noParameterLabel;
    private JComboBox listeRestarts;
    private JButton restartButton;
    private JButton changeRestartMode;
    private JLabel factorLabel;
    private static final String FACTOR = "Factor: ";
    private JTextField factorField;
    private String currentRestart;
    private static final String RESTART = "Restart";
    private static final String CHOOSE_RESTART_STRATEGY = "Choose restart strategy: ";
    private static final String CHANGE_RESTART_STRATEGY = "Apply";
    private static final String MANUAL_RESTART = "Manual Restart";
    private static final String NO_PARAMETER_FOR_THIS_STRATEGY = "No paramaters for this strategy";
    private static final String RESTART_STRATEGY_CLASS = "org.sat4j.minisat.core.RestartStrategy";
    private static final String RESTART_PATH = "org.sat4j.minisat.restarts";
    private SolverController controller;
    private ILogAble logger;

    public RestartCommandComponent(String string, SolverController solverController, String string2, ILogAble iLogAble) {
        this.setName(string);
        this.currentRestart = string2;
        this.controller = solverController;
        this.logger = iLogAble;
        this.createPanel();
        this.initFactorParam();
    }

    @Override
    public void createPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 19;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridx = 0;
        jPanel.setBorder(new CompoundBorder(new TitledBorder(null, this.getName(), 1, 2), DetailedCommandPanel.BORDER5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        this.chooseRestartStrategyLabel = new JLabel(CHOOSE_RESTART_STRATEGY);
        this.listeRestarts = new JComboBox<Object>(this.getListOfRestartStrategies().toArray());
        this.listeRestarts.setSelectedItem(this.currentRestart);
        this.listeRestarts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RestartCommandComponent.this.modifyRestartParamPanel();
            }
        });
        jPanel2.add(this.chooseRestartStrategyLabel);
        jPanel2.add(this.listeRestarts);
        this.changeRestartMode = new JButton(CHANGE_RESTART_STRATEGY);
        this.changeRestartMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RestartCommandComponent.this.hasClickedOnChange();
            }
        });
        jPanel2.add(this.changeRestartMode);
        this.noParameterLabel = new JLabel(NO_PARAMETER_FOR_THIS_STRATEGY);
        Font font = new Font(this.noParameterLabel.getFont().getName(), 2, this.noParameterLabel.getFont().getSize());
        this.noParameterLabel.setFont(font);
        this.restartPropertiesPanel = new JPanel();
        this.restartPropertiesPanel.add(this.noParameterLabel);
        this.restartButton = new JButton(RESTART);
        this.restartButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RestartCommandComponent.this.hasClickedOnRestart();
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setName(MANUAL_RESTART);
        jPanel3.setBorder(new CompoundBorder(new TitledBorder(null, jPanel3.getName(), 1, 2), DetailedCommandPanel.BORDER5));
        jPanel3.add(this.restartButton);
        gridBagConstraints2.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        gridBagConstraints2.gridy = 1;
        jPanel.add((Component)this.restartPropertiesPanel, gridBagConstraints2);
        gridBagConstraints.gridy = 0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)jPanel3, gridBagConstraints);
    }

    public void initFactorParam() {
        this.factorLabel = new JLabel(FACTOR);
        this.factorField = new JTextField("32", 5);
    }

    public void modifyRestartParamPanel() {
        this.restartPropertiesPanel.removeAll();
        if (this.listeRestarts.getSelectedItem().equals("LubyRestarts")) {
            this.restartPropertiesPanel.add(this.factorLabel);
            this.restartPropertiesPanel.add(this.factorField);
        } else {
            this.restartPropertiesPanel.add(this.noParameterLabel);
        }
        this.setRestartPropertiesPanelEnabled(true);
        this.restartPropertiesPanel.repaint();
        this.repaint();
        this.paintAll(this.getGraphics());
        this.repaint();
    }

    public void setRestartPanelEnabled(boolean bl) {
        this.listeRestarts.setEnabled(bl);
        this.restartButton.setEnabled(bl);
        this.chooseRestartStrategyLabel.setEnabled(bl);
        this.setRestartPropertiesPanelEnabled(bl);
        this.repaint();
    }

    public void setRestartPropertiesPanelEnabled(boolean bl) {
        for (Component component : this.restartPropertiesPanel.getComponents()) {
            component.setEnabled(bl);
        }
        this.restartPropertiesPanel.repaint();
    }

    public void updateRestartStrategyPanel() {
        this.listeRestarts.setSelectedItem(this.currentRestart);
    }

    public void hasClickedOnChange() {
        boolean bl;
        this.controller.shouldRestartNow();
        String string = (String)this.listeRestarts.getSelectedItem();
        boolean bl2 = bl = !string.equals(this.currentRestart);
        RestartStrategy restartStrategy = new NoRestarts();
        SearchParams searchParams = this.controller.getSearchParams();
        SolverStats solverStats = this.controller.getSolverStats();
        if (string.equals("LubyRestarts")) {
            boolean bl3 = false;
            int n = 32;
            if (this.factorField.getText() != null) {
                n = Integer.parseInt(this.factorField.getText());
            }
            if (bl) {
                restartStrategy = new LubyRestarts(n);
                this.controller.setRestartStrategy(restartStrategy);
            } else {
                boolean bl4 = bl3 = n != ((LubyRestarts)this.controller.getRestartStrategy()).getFactor();
            }
            if (bl3) {
                restartStrategy = this.controller.getRestartStrategy();
                ((LubyRestarts)restartStrategy).setFactor(n);
            }
            boolean bl5 = bl2 = bl || bl3;
            if (bl2) {
                this.controller.init(searchParams, solverStats);
            }
        } else {
            try {
                restartStrategy = (RestartStrategy)Class.forName("org.sat4j.minisat.restarts." + string).newInstance();
                assert (restartStrategy != null);
                this.controller.setRestartStrategy(restartStrategy);
                this.controller.init(searchParams, solverStats);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logger.log(classNotFoundException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                this.logger.log(illegalAccessException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                this.logger.log(instantiationException.getMessage());
            }
        }
        this.currentRestart = string;
    }

    public void hasClickedOnRestart() {
        this.controller.shouldRestartNow();
    }

    public List<String> getListOfRestartStrategies() {
        List<String> list = RTSI.find(RESTART_STRATEGY_CLASS);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string.contains("Remote")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public String getCurrentRestart() {
        return this.currentRestart;
    }

    public void setCurrentRestart(String string) {
        this.currentRestart = string;
        this.updateRestartStrategyPanel();
        this.modifyRestartParamPanel();
    }
}

