/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.sat4j.minisat.core.SimplificationType;
import org.sat4j.sat.CommandComponent;
import org.sat4j.sat.DetailedCommandPanel;
import org.sat4j.sat.SolverController;

public class SimplifierCommandComponent
extends CommandComponent {
    private static final long serialVersionUID = 1L;
    private SolverController controller;
    private static final String SIMPLIFICATION_APPLY = "Apply";
    public static final String SIMPLIFICATION_NO = "No reason simplification";
    public static final String SIMPLIFICATION_SIMPLE = "Simple reason simplification";
    public static final String SIMPLIFICATION_EXPENSIVE = "Expensive reason simplification";
    private JButton simplificationApplyButton;
    private ButtonGroup simplificationGroup;
    private JRadioButton simplificationNoRadio;
    private JRadioButton simplificationSimpleRadio;
    private JRadioButton simplificationExpensiveRadio;

    public SimplifierCommandComponent(String string, SolverController solverController) {
        this.setName(string);
        this.controller = solverController;
        this.createPanel();
    }

    public void createPanel() {
        this.createSimplifierPanel();
    }

    public void createSimplifierPanel() {
        this.setBorder(new CompoundBorder(new TitledBorder(null, this.getName(), 1, 2), DetailedCommandPanel.BORDER5));
        this.setLayout(new BorderLayout());
        this.simplificationGroup = new ButtonGroup();
        this.simplificationExpensiveRadio = new JRadioButton(SIMPLIFICATION_EXPENSIVE);
        this.simplificationNoRadio = new JRadioButton(SIMPLIFICATION_NO);
        this.simplificationSimpleRadio = new JRadioButton(SIMPLIFICATION_SIMPLE);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.simplificationGroup.add(this.simplificationNoRadio);
        this.simplificationGroup.add(this.simplificationSimpleRadio);
        this.simplificationGroup.add(this.simplificationExpensiveRadio);
        jPanel.add(this.simplificationNoRadio);
        jPanel.add(this.simplificationSimpleRadio);
        jPanel.add(this.simplificationExpensiveRadio);
        this.simplificationApplyButton = new JButton(SIMPLIFICATION_APPLY);
        this.simplificationApplyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimplifierCommandComponent.this.hasClickedOnApplySimplification();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.simplificationApplyButton);
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "South");
    }

    public void setSelectedSimplification(String string) {
        if (string.equals(SIMPLIFICATION_EXPENSIVE)) {
            this.simplificationExpensiveRadio.setSelected(true);
        } else if (string.equals(SIMPLIFICATION_SIMPLE)) {
            this.simplificationSimpleRadio.setSelected(true);
        } else {
            this.simplificationNoRadio.setSelected(true);
        }
    }

    public void hasClickedOnApplySimplification() {
        if (this.simplificationSimpleRadio.isSelected()) {
            this.controller.setSimplifier(SimplificationType.SIMPLE_SIMPLIFICATION);
        } else if (this.simplificationExpensiveRadio.isSelected()) {
            this.controller.setSimplifier(SimplificationType.EXPENSIVE_SIMPLIFICATION);
        } else {
            this.controller.setSimplifier(SimplificationType.NO_SIMPLIFICATION);
        }
    }

    public void setSimplifierPanelEnabled(boolean bl) {
        this.simplificationNoRadio.setEnabled(bl);
        this.simplificationExpensiveRadio.setEnabled(bl);
        this.simplificationSimpleRadio.setEnabled(bl);
        this.simplificationApplyButton.setEnabled(bl);
        this.repaint();
    }
}

