/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ICDCL;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.LearnedConstraintsEvaluationType;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SimplificationType;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.pb.orders.RandomWalkDecoratorObjective;
import org.sat4j.pb.orders.VarOrderHeapObjective;
import org.sat4j.sat.RTSI;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.DotSearchTracing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Solvers {
    private static final String SEPARATOR = "-------------------";
    private static final String CLASS = "class";
    private static final String OPB = "opb";
    private static final String CNF = "cnf";
    private static final String MAXSAT = "maxsat";
    private static final String OPT = "opt";
    private static final String FILENAME = "filename";
    private static final String NUMBER = "number";
    private static final String PROBLEM_WITH_COMPONENT = "Problem with component ";
    private static final String PB = "pb";
    private static final String MINISAT = "minisat";
    public static final String ORDERS = "ORDERS";
    public static final String LEARNING = "LEARNING";
    public static final String RESTARTS = "RESTARTS";
    public static final String PHASE = "PHASE";
    public static final String PARAMS = "PARAMS";
    public static final String SIMP = "SIMP";
    private static final String PACKAGE_ORDERS = "org.sat4j.minisat.orders";
    private static final String PACKAGE_LEARNING = "org.sat4j.minisat.learning";
    private static final String PACKAGE_RESTARTS = "org.sat4j.minisat.restarts";
    private static final String PACKAGE_PHASE = "org.sat4j.minisat.orders";
    private static final String PACKAGE_PARAMS = "org.sat4j.minisat.core";
    private static final String RESTART_STRATEGY_NAME = "org.sat4j.minisat.core.RestartStrategy";
    private static final String ORDER_NAME = "org.sat4j.minisat.core.IOrder";
    private static final String LEARNING_NAME = "org.sat4j.minisat.core.LearningStrategy";
    private static final String PHASE_NAME = "org.sat4j.minisat.core.IPhaseSelectionStrategy";
    private static final String PARAMS_NAME = "org.sat4j.minisat.core.SearchParams";
    private static final Map<String, String> QUALIF = new HashMap<String, String>();

    private Solvers() {
    }

    protected static ICDCL configureFromString(String string, ICDCL iCDCL, ILogAble iLogAble) {
        String string2;
        SearchParams searchParams;
        String string3;
        RestartStrategy restartStrategy;
        IPhaseSelectionStrategy iPhaseSelectionStrategy;
        IOrder iOrder;
        LearningStrategy learningStrategy;
        assert (iCDCL != null);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Properties properties = new Properties();
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            String[] stringArray = string4.split("=");
            properties.setProperty(stringArray[0], stringArray[1]);
        }
        Solver solver = (Solver)iCDCL;
        DataStructureFactory dataStructureFactory = (DataStructureFactory)Solvers.setupObject("DSF", properties, iLogAble);
        if (dataStructureFactory != null) {
            iCDCL.setDataStructureFactory(dataStructureFactory);
        }
        if ((learningStrategy = (LearningStrategy)Solvers.setupObject(LEARNING, properties, iLogAble)) != null) {
            iCDCL.setLearningStrategy(learningStrategy);
            learningStrategy.setSolver(solver);
        }
        if ((iOrder = (IOrder)Solvers.setupObject(ORDERS, properties, iLogAble)) != null) {
            iCDCL.setOrder(iOrder);
        }
        if ((iPhaseSelectionStrategy = (IPhaseSelectionStrategy)Solvers.setupObject(PHASE, properties, iLogAble)) != null) {
            iCDCL.getOrder().setPhaseSelectionStrategy(iPhaseSelectionStrategy);
        }
        if ((restartStrategy = (RestartStrategy)Solvers.setupObject(RESTARTS, properties, iLogAble)) != null) {
            iCDCL.setRestartStrategy(restartStrategy);
        }
        if ((string3 = properties.getProperty(SIMP)) != null) {
            iLogAble.log("read " + string3);
            iLogAble.log("configuring SIMP");
            iCDCL.setSimplifier(SimplificationType.valueOf(string3));
        }
        if ((searchParams = (SearchParams)Solvers.setupObject(PARAMS, properties, iLogAble)) != null) {
            iCDCL.setSearchParams(searchParams);
        }
        if ((string2 = properties.getProperty("CLEANING")) != null) {
            try {
                iLogAble.log("configuring CLEANING");
                LearnedConstraintsEvaluationType learnedConstraintsEvaluationType = LearnedConstraintsEvaluationType.valueOf(string2);
                iCDCL.setLearnedConstraintsDeletionStrategy(learnedConstraintsEvaluationType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                iLogAble.log("wrong memory management setting: " + string2);
                Solvers.showAvailableConstraintsCleaningStrategies(iLogAble);
            }
        }
        return iCDCL;
    }

    private static <T> T setupObject(String string, Properties properties, ILogAble iLogAble) {
        try {
            String string2 = properties.getProperty(string);
            String string3 = QUALIF.get(string);
            if (string2 == null) {
                return null;
            }
            if (string3 != null) {
                iLogAble.log("read " + string3 + "." + string2);
                if (string2.contains("Objective") && string3.contains(MINISAT)) {
                    string3 = string3.replaceFirst(MINISAT, PB);
                }
                string2 = string3 + "." + string2;
            }
            iLogAble.log("configuring " + string);
            String[] stringArray = string2.split("/");
            Object obj = Class.forName(stringArray[0]).newInstance();
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(":");
                assert (stringArray2.length == 2);
                try {
                    BeanUtils.getProperty(obj, stringArray2[0]);
                    BeanUtils.setProperty(obj, stringArray2[0], stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    iLogAble.log(PROBLEM_WITH_COMPONENT + stringArray[0] + " " + exception);
                }
            }
            return (T)obj;
        }
        catch (InstantiationException instantiationException) {
            iLogAble.log(PROBLEM_WITH_COMPONENT + string + " " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            iLogAble.log(PROBLEM_WITH_COMPONENT + string + " " + illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogAble.log(PROBLEM_WITH_COMPONENT + string + " " + classNotFoundException);
        }
        return null;
    }

    public static Options createCLIOptions() {
        Options options = new Options();
        options.addOption("l", "library", true, "specifies the name of the library used (if not present, the library depends on the file extension)");
        options.addOption("s", "solver", true, "specifies the name of a prebuilt solver from the library");
        options.addOption("S", "Solver", true, "setup a solver using a solver config string");
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("C", "conflictbased", false, "conflict based timeout (for deterministic behavior)");
        options.addOption("d", "dot", true, "creates a sat4j.dot file in current directory representing the search");
        options.addOption("f", FILENAME, true, "specifies the file to use (in conjunction with -d for instance)");
        options.addOption("m", "mute", false, "Set launcher in silent mode");
        options.addOption("k", "kleast", true, "limit the search to models having at least k variables set to false");
        options.addOption("tr", "trace", false, "traces the behavior of the solver");
        options.addOption(OPT, "optimize", false, "uses solver in optimize mode instead of sat mode (default)");
        options.addOption("rw", "randomWalk", true, "specifies the random walk probability ");
        options.addOption("remote", "remoteControl", false, "launches remote control");
        options.addOption("r", "trace", false, "traces the behavior of the solver");
        options.addOption("H", "hot", false, "keep the solver hot (do not reset heuristics) when a model is found");
        options.addOption("y", "simplify", false, "simplify the set of clauses if possible");
        options.addOption("lo", "lower", false, "search solution by lower bounding instead of by upper bounding");
        options.addOption("e", "equivalence", false, "Use an equivalence instead of an implication for the selector variables");
        options.addOption("i", "incomplete", false, "incomplete mode for maxsat");
        options.addOption("n", "no solution line", false, "Do not display a solution line (useful if the solution is large)");
        Option option = options.getOption("l");
        option.setArgName("libname");
        option = options.getOption("s");
        option.setArgName("solvername");
        option = options.getOption("S");
        option.setArgName("solverStringDefinition");
        option = options.getOption("t");
        option.setArgName(NUMBER);
        option = options.getOption("T");
        option.setArgName(NUMBER);
        option = options.getOption("C");
        option.setArgName(NUMBER);
        option = options.getOption("k");
        option.setArgName(NUMBER);
        option = options.getOption("d");
        option.setArgName(FILENAME);
        option = options.getOption("f");
        option.setArgName(FILENAME);
        option = options.getOption("rw");
        option.setArgName(NUMBER);
        return options;
    }

    public static void stringUsage(ILogAble iLogAble) {
        iLogAble.log("Available building blocks: DSF, LEARNING, ORDERS, PHASE, RESTARTS, SIMP, PARAMS, CLEANING");
        iLogAble.log("Example: -S RESTARTS=LubyRestarts/factor:512,LEARNING=MiniSATLearning");
    }

    public static boolean containsOptValue(String[] stringArray) {
        Options options = Solvers.createCLIOptions();
        try {
            CommandLine commandLine = new PosixParser().parse(options, stringArray);
            return commandLine.hasOption(OPT);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static ICDCL configureSolver(String[] stringArray, ILogAble iLogAble) {
        Options options = Solvers.createCLIOptions();
        if (stringArray.length == 0) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j.jar", options, true);
            return null;
        }
        try {
            String string;
            ASolverFactory aSolverFactory;
            Object object;
            Object object2;
            Serializable serializable;
            CommandLine commandLine = new PosixParser().parse(options, stringArray);
            boolean bl = false;
            if (commandLine.hasOption(OPT)) {
                bl = true;
            }
            String string2 = commandLine.getOptionValue("f");
            String[] stringArray2 = commandLine.getArgs();
            if (string2 == null && stringArray2.length > 0) {
                string2 = stringArray2[0];
            }
            String string3 = Solvers.uncompressed(string2);
            String string4 = commandLine.getOptionValue("l");
            if (string4 == null) {
                string4 = bl ? (string3 != null && string3.endsWith(CNF) ? MAXSAT : PB) : (string3 != null && string3.endsWith(OPB) ? PB : MINISAT);
            }
            try {
                serializable = Class.forName("org.sat4j." + string4 + ".SolverFactory");
                object2 = new Class[]{};
                object = ((Class)serializable).getMethod("instance", (Class<?>)object2);
                aSolverFactory = (ASolverFactory)((Method)object).invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                iLogAble.log("Wrong framework: " + string4 + ". Using minisat instead.");
                aSolverFactory = SolverFactory.instance();
            }
            if (commandLine.hasOption("s")) {
                object2 = commandLine.getOptionValue("s");
                if (object2 == null) {
                    iLogAble.log("No solver for option s. Launching default solver.");
                    iLogAble.log("Available solvers: " + Arrays.asList(aSolverFactory.solverNames()));
                    serializable = (Solver)aSolverFactory.defaultSolver();
                } else {
                    serializable = (Solver)aSolverFactory.createSolverByName((String)object2);
                }
            } else {
                serializable = (Solver)aSolverFactory.defaultSolver();
            }
            if (commandLine.hasOption("S")) {
                object2 = commandLine.getOptionValue("S");
                if (object2 == null) {
                    Solvers.stringUsage(iLogAble);
                    return null;
                }
                serializable = Solvers.configureFromString((String)object2, serializable, iLogAble);
            }
            if (commandLine.hasOption("rw")) {
                double d = Double.parseDouble(commandLine.getOptionValue("rw"));
                IOrder iOrder = serializable.getOrder();
                iOrder = bl && iOrder instanceof VarOrderHeapObjective ? new RandomWalkDecoratorObjective((VarOrderHeapObjective)iOrder, d) : new RandomWalkDecorator((VarOrderHeap)iOrder, d);
                serializable.setOrder(iOrder);
            }
            if ((string = commandLine.getOptionValue("t")) == null) {
                string = commandLine.getOptionValue("T");
                if (string != null) {
                    serializable.setTimeoutMs(Long.parseLong(string));
                }
            } else if (commandLine.hasOption("C")) {
                serializable.setTimeoutOnConflicts(Integer.parseInt(string));
            } else {
                serializable.setTimeout(Integer.parseInt(string));
            }
            if (commandLine.hasOption("H")) {
                serializable.setKeepSolverHot(true);
            }
            if (commandLine.hasOption("y")) {
                serializable.setDBSimplificationAllowed(true);
            }
            if (commandLine.hasOption("d")) {
                object = null;
                if (string2 != null) {
                    object = commandLine.getOptionValue("d");
                }
                if (object == null) {
                    object = "sat4j.dot";
                }
                serializable.setSearchListener(new DotSearchTracing((String)object, null));
            }
            return serializable;
        }
        catch (ParseException parseException) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j.jar", options, true);
            Solvers.usage(iLogAble);
            return null;
        }
    }

    public static String uncompressed(String string) {
        if (string != null && (string.endsWith(".bz2") || string.endsWith(".gz"))) {
            return string.substring(0, string.lastIndexOf(46));
        }
        return string;
    }

    public static void showAvailableRestarts(ILogAble iLogAble) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = RTSI.find(RESTART_STRATEGY_NAME);
        for (String string : list) {
            if (string.contains("Remote")) continue;
            try {
                Set set = BeanUtils.describe(Class.forName("org.sat4j.minisat.restarts." + string).newInstance()).keySet();
                set.remove(CLASS);
                if (set.size() > 0) {
                    arrayList.add(string + set);
                    continue;
                }
                arrayList.add(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                iLogAble.log(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                iLogAble.log(invocationTargetException.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                iLogAble.log(noSuchMethodException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                iLogAble.log(instantiationException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                iLogAble.log(classNotFoundException.getMessage());
            }
        }
        arrayList.add("Glucose21Restarts");
        iLogAble.log("Available restart strategies (RESTARTS): " + arrayList);
    }

    public static void showAvailablePhase(ILogAble iLogAble) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = RTSI.find(PHASE_NAME);
        for (String string : list) {
            if (string.contains("Remote")) continue;
            try {
                Set set = BeanUtils.describe(Class.forName("org.sat4j.minisat.orders." + string).newInstance()).keySet();
                set.remove(CLASS);
                if (set.size() > 0) {
                    arrayList.add(string + set);
                    continue;
                }
                arrayList.add(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                iLogAble.log(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                iLogAble.log(invocationTargetException.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                iLogAble.log(noSuchMethodException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                iLogAble.log(instantiationException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                iLogAble.log(classNotFoundException.getMessage());
            }
        }
        iLogAble.log("Available phase strategies (PHASE): " + arrayList);
    }

    public static void showAvailableLearning(ILogAble iLogAble) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = RTSI.find(LEARNING_NAME);
        for (String string : list) {
            try {
                Set set = BeanUtils.describe(Class.forName("org.sat4j.minisat.learning." + string).newInstance()).keySet();
                set.remove(CLASS);
                if (set.size() > 0) {
                    arrayList.add(string + set);
                    continue;
                }
                arrayList.add(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                iLogAble.log(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                iLogAble.log(invocationTargetException.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                iLogAble.log(noSuchMethodException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                arrayList.add(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                iLogAble.log(classNotFoundException.getMessage());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                iLogAble.log(noClassDefFoundError.getMessage());
            }
        }
        iLogAble.log("Available learning (LEARNING): " + arrayList);
    }

    public static void showAvailableOrders(ILogAble iLogAble) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = RTSI.find(ORDER_NAME);
        Set set = null;
        for (String string : list) {
            if (string.contains("Remote")) continue;
            try {
                if (string.contains("Objective")) {
                    String string2 = "org.sat4j.minisat.orders".replaceFirst(MINISAT, PB);
                    set = BeanUtils.describe(Class.forName(string2 + "." + string).newInstance()).keySet();
                } else {
                    set = BeanUtils.describe(Class.forName("org.sat4j.minisat.orders." + string).newInstance()).keySet();
                }
                set.remove(CLASS);
                if (set.size() > 0) {
                    arrayList.add(string + set);
                    continue;
                }
                arrayList.add(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                iLogAble.log(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                iLogAble.log(invocationTargetException.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                iLogAble.log(noSuchMethodException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                iLogAble.log(instantiationException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                iLogAble.log(classNotFoundException.getMessage());
            }
        }
        iLogAble.log("Available orders (ORDERS): " + arrayList);
    }

    public static void showParams(ILogAble iLogAble) {
        Set set = null;
        try {
            set = BeanUtils.describe(Class.forName(PARAMS_NAME).newInstance()).keySet();
            set.remove(CLASS);
        }
        catch (IllegalAccessException illegalAccessException) {
            iLogAble.log(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            iLogAble.log(invocationTargetException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            iLogAble.log(noSuchMethodException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            iLogAble.log(instantiationException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogAble.log(classNotFoundException.getMessage());
        }
        iLogAble.log("Available search params (PARAMS): [SearchParams" + set + "]");
    }

    public static void showSimplifiers(ILogAble iLogAble) {
        iLogAble.log("Available simplifiers : [NO_SIMPLIFICATION, SIMPLE_SIMPLIFICATION, EXPENSIVE_SIMPLIFICATION]");
    }

    public static void showAvailableConstraintsCleaningStrategies(ILogAble iLogAble) {
        iLogAble.log("Available learned constraints cleaning strategies" + Arrays.asList(LearnedConstraintsEvaluationType.values()));
    }

    public static <T extends ISolver> void showAvailableSolvers(ASolverFactory<T> aSolverFactory, ILogAble iLogAble) {
        Solvers.showAvailableSolvers(aSolverFactory, "", iLogAble);
    }

    public static <T extends ISolver> void showAvailableSolvers(ASolverFactory<T> aSolverFactory, String string, ILogAble iLogAble) {
        if (aSolverFactory != null) {
            String[] stringArray;
            if (string.length() > 0) {
                iLogAble.log("Available solvers for " + string + ": ");
            } else {
                iLogAble.log("Available solvers: ");
            }
            for (String string2 : stringArray = aSolverFactory.solverNames()) {
                iLogAble.log(string2);
            }
        }
    }

    public static void usage(ILogAble iLogAble) {
        ASolverFactory aSolverFactory = SolverFactory.instance();
        Solvers.showAvailableSolvers(aSolverFactory, "sat", iLogAble);
        iLogAble.log(SEPARATOR);
        aSolverFactory = org.sat4j.pb.SolverFactory.instance();
        Solvers.showAvailableSolvers(aSolverFactory, PB, iLogAble);
        iLogAble.log(SEPARATOR);
        aSolverFactory = org.sat4j.maxsat.SolverFactory.instance();
        Solvers.showAvailableSolvers(aSolverFactory, MAXSAT, iLogAble);
        iLogAble.log(SEPARATOR);
        Solvers.showAvailableRestarts(iLogAble);
        iLogAble.log(SEPARATOR);
        Solvers.showAvailableOrders(iLogAble);
        iLogAble.log(SEPARATOR);
        Solvers.showAvailableLearning(iLogAble);
        iLogAble.log(SEPARATOR);
        Solvers.showAvailablePhase(iLogAble);
        iLogAble.log(SEPARATOR);
        Solvers.showParams(iLogAble);
        iLogAble.log(SEPARATOR);
        Solvers.showSimplifiers(iLogAble);
        iLogAble.log(SEPARATOR);
        Solvers.stringUsage(iLogAble);
    }

    static {
        QUALIF.put(ORDERS, "org.sat4j.minisat.orders");
        QUALIF.put(LEARNING, PACKAGE_LEARNING);
        QUALIF.put(RESTARTS, PACKAGE_RESTARTS);
        QUALIF.put(PHASE, "org.sat4j.minisat.orders");
        QUALIF.put(PARAMS, PACKAGE_PARAMS);
    }
}

