/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat.visu;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.sat4j.sat.visu.GnuplotDataFile;
import org.sat4j.sat.visu.GnuplotFunction;
import org.sat4j.sat.visu.SolverVisualisation;
import org.sat4j.sat.visu.VisuPreferences;
import org.sat4j.specs.ILogAble;

public class GnuplotBasedSolverVisualisation
implements SolverVisualisation {
    private static final double TWO_THIRDS = 0.66;
    private static final double ONE_THIRD = 0.33;
    private static final double ZERO = 0.0;
    private static final String SPEED = "Speed";
    private static final String SET_XRANGE_0_5 = "set xrange [0.5:*]";
    private static final String IMPULSES = "impulses";
    private static final String EVALUATION = "Evaluation";
    private static final String SIZE = "Size";
    private static final String CLEAN = "Clean";
    private static final String RESTART = "Restart";
    private static final String CONFLICT_LEVEL = "Conflict Level";
    private static final String GNUPLOT_GNUPLOT = "-gnuplot.gnuplot";
    private static final String SET_MULTIPLOT = "set multiplot";
    private static final String SET_TERMINAL_X11 = "set terminal x11";
    private static final String SPEED_RESTART_DAT = "-speed-restart.dat";
    private static final String SPEED_DAT = "-speed.dat";
    private static final String GNUPLOT_SHOULD_BE_DEACTIVATED = "Gnuplot should be deactivated...";
    private static final String GNUPLOT_SHOULD_HAVE_STARTED_NOW = "Gnuplot should have started now.";
    private static final String GNUPLOT_WILL_START_IN_A_FEW_SECONDS = "Gnuplot will start in a few seconds.";
    private static final String REREAD = "reread";
    private static final String SET_YTICS_AUTO = "set ytics auto";
    private static final String UNSET_MULTIPLOT = "unset multiplot";
    private static final String UNSET_AUTOSCALE = "unset autoscale";
    private static final String SET_Y2RANGE_0 = "set y2range [0:]";
    private static final String SET_AUTOSCALE_YMAX = "set autoscale ymax";
    private static final String SET_NOLOGSCALE_Y = "set nologscale y";
    private static final String SET_NOLOGSCALE_X = "set nologscale x";
    private static final String SET_AUTOSCALE_Y = "set autoscale y";
    private static final String SET_AUTOSCALE_X = "set autoscale x";
    private static final long serialVersionUID = 1L;
    private VisuPreferences visuPreferences;
    private int nVar;
    private Process gnuplotProcess;
    private String dataPath;
    private ILogAble logger;

    public GnuplotBasedSolverVisualisation(VisuPreferences visuPreferences, int n, String string, ILogAble iLogAble) {
        this.visuPreferences = visuPreferences;
        this.nVar = n;
        this.dataPath = string;
        this.logger = iLogAble;
    }

    public void start() {
        this.traceGnuplot();
    }

    public void end() {
        this.stopGnuplot();
    }

    public void traceGnuplot() {
        if (this.gnuplotProcess == null) {
            try {
                GnuplotDataFile gnuplotDataFile;
                GnuplotDataFile gnuplotDataFile2;
                Object object;
                GnuplotDataFile gnuplotDataFile3;
                double d = 0.0;
                double d2 = 0.33;
                double d3 = 0.66;
                double d4 = 0.0;
                double d5 = 0.33;
                double d6 = 0.66;
                double d7 = 0.33;
                double d8 = 0.33;
                PrintStream printStream = new PrintStream(new FileOutputStream(this.dataPath + GNUPLOT_GNUPLOT));
                printStream.println(SET_TERMINAL_X11);
                printStream.println(SET_MULTIPLOT);
                printStream.println(SET_AUTOSCALE_X);
                printStream.println(SET_AUTOSCALE_Y);
                printStream.println(SET_NOLOGSCALE_X);
                printStream.println(SET_NOLOGSCALE_Y);
                printStream.println(SET_YTICS_AUTO);
                GnuplotFunction gnuplotFunction = new GnuplotFunction("2", Color.black, "");
                if (this.visuPreferences.isDisplayConflictsDecision()) {
                    printStream.println(this.setSize(d7, d8));
                    printStream.println(this.setOrigin(d2, d6));
                    printStream.println(this.setTitle("Decision level at which the conflict occurs"));
                    printStream.println(SET_AUTOSCALE_YMAX);
                    printStream.println(SET_Y2RANGE_0);
                    gnuplotDataFile3 = new GnuplotDataFile(this.dataPath + "-conflict-level.dat", Color.magenta, CONFLICT_LEVEL);
                    object = new GnuplotDataFile(this.dataPath + "-conflict-level-restart.dat", Color.gray, RESTART, IMPULSES);
                    gnuplotDataFile2 = new GnuplotDataFile(this.dataPath + "-conflict-level-clean.dat", Color.orange, CLEAN, IMPULSES);
                    printStream.println(this.visuPreferences.generatePlotLineOnDifferenteAxes(new GnuplotDataFile[]{gnuplotDataFile3}, new GnuplotDataFile[]{object, gnuplotDataFile2}, true));
                }
                if (this.visuPreferences.isDisplayClausesSize()) {
                    printStream.println(UNSET_AUTOSCALE);
                    printStream.println(SET_AUTOSCALE_X);
                    printStream.println(SET_AUTOSCALE_YMAX);
                    printStream.println(SET_Y2RANGE_0);
                    printStream.println(this.setSize(d7, d8));
                    printStream.println(this.setOrigin(d3, d4));
                    printStream.println(this.setTitle("Size of the clause learned (after minimization if any)"));
                    gnuplotDataFile3 = new GnuplotDataFile(this.dataPath + "-learned-clauses-size.dat", Color.blue, SIZE);
                    object = new GnuplotDataFile(this.dataPath + "-learned-clauses-size-restart.dat", Color.gray, RESTART, IMPULSES);
                    gnuplotDataFile2 = new GnuplotDataFile(this.dataPath + "-learned-clauses-size-clean.dat", Color.orange, CLEAN, IMPULSES);
                    printStream.println(this.visuPreferences.generatePlotLineOnDifferenteAxes(new GnuplotDataFile[]{gnuplotDataFile3}, new GnuplotDataFile[]{gnuplotDataFile2, object}, true));
                }
                if (this.visuPreferences.isDisplayConflictsDecision()) {
                    printStream.println(SET_AUTOSCALE_X);
                    printStream.println(SET_AUTOSCALE_Y);
                    printStream.println(this.setSize(d7, d8));
                    printStream.println(this.setOrigin(d3, d5));
                    printStream.println(this.setTitle("Value of learned clauses evaluation"));
                    gnuplotDataFile3 = new GnuplotDataFile(this.dataPath + "-learned.dat", Color.blue, EVALUATION);
                    printStream.println(this.visuPreferences.generatePlotLine(gnuplotDataFile3, gnuplotFunction, "", false));
                }
                printStream.println(SET_AUTOSCALE_X);
                printStream.println(SET_NOLOGSCALE_X);
                printStream.println(SET_NOLOGSCALE_Y);
                printStream.println(SET_AUTOSCALE_Y);
                printStream.println(this.setYRangeFrom1ToNvar());
                printStream.println(this.setYTicsFrom1ToNVar());
                if (this.visuPreferences.isDisplayDecisionIndexes()) {
                    printStream.println(UNSET_AUTOSCALE);
                    printStream.println("if(system(\"head " + this.dataPath + "-decision-indexes-pos.dat | wc -l\")!=0){set autoscale x;}");
                    printStream.println("if(system(\"head " + this.dataPath + "-decision-indexes-pos.dat | wc -l\")!=0){set yrange [1:" + this.nVar + "]};");
                    printStream.println(this.setSize(d7, d8));
                    printStream.println(this.setOrigin(d2, d4));
                    printStream.println(this.setTitle("Index of the decision variables"));
                    gnuplotDataFile3 = new GnuplotDataFile(this.dataPath + "-decision-indexes-neg.dat", Color.red, "Negative Decision");
                    object = new GnuplotDataFile(this.dataPath + "-decision-indexes-restart.dat", Color.gray, RESTART, IMPULSES);
                    gnuplotDataFile2 = new GnuplotDataFile(this.dataPath + "-decision-indexes-clean.dat", Color.orange, CLEAN, IMPULSES);
                    printStream.println(this.visuPreferences.generatePlotLineOnDifferenteAxes(new GnuplotDataFile[]{gnuplotDataFile3}, new GnuplotDataFile[]{object, gnuplotDataFile2}, true, this.visuPreferences.getNbLinesRead() * 4));
                    printStream.println(UNSET_AUTOSCALE);
                    printStream.println("if(system(\"head " + this.dataPath + "-decision-indexes-pos.dat | wc -l\")!=0){set autoscale x;set yrange [1:" + this.nVar + "]; set y2range [0:]; }");
                    printStream.println(this.setSize(d7, d8));
                    printStream.println(this.setOrigin(d, d4));
                    printStream.println(this.setTitle("Index of the decision variables"));
                    gnuplotDataFile = new GnuplotDataFile(this.dataPath + "-decision-indexes-pos.dat", Color.green, "Positive Decision");
                    printStream.println(this.visuPreferences.generatePlotLineOnDifferenteAxes(new GnuplotDataFile[]{gnuplotDataFile}, new GnuplotDataFile[]{object, gnuplotDataFile2}, true, this.visuPreferences.getNbLinesRead() * 4));
                }
                if (this.visuPreferences.isDisplayConflictsTrail()) {
                    printStream.println(SET_AUTOSCALE_X);
                    printStream.println(SET_AUTOSCALE_Y);
                    printStream.println(SET_NOLOGSCALE_X);
                    printStream.println(SET_NOLOGSCALE_Y);
                    printStream.println(this.setSize(d7, d8));
                    printStream.println(this.setOrigin(d3, d6));
                    printStream.println(this.setTitle("Trail level when the conflict occurs"));
                    printStream.println(SET_Y2RANGE_0);
                    gnuplotDataFile3 = new GnuplotDataFile(this.dataPath + "-conflict-depth.dat", Color.magenta, "Trail level");
                    object = new GnuplotFunction("" + this.nVar / 2, Color.green, "#Var/2");
                    gnuplotDataFile2 = new GnuplotDataFile(this.dataPath + "-conflict-depth-restart.dat", Color.gray, RESTART, IMPULSES);
                    gnuplotDataFile = new GnuplotDataFile(this.dataPath + "-conflict-depth-clean.dat", Color.orange, CLEAN, IMPULSES);
                    printStream.println(this.visuPreferences.generatePlotLineOnDifferenteAxes(new GnuplotDataFile[]{gnuplotDataFile3}, new GnuplotDataFile[]{gnuplotDataFile2, gnuplotDataFile}, new GnuplotFunction[]{object}, true));
                    printStream.println(this.visuPreferences.generatePlotLine(gnuplotDataFile3, (GnuplotFunction)object, this.dataPath + "-conflict-level-restart.dat", true));
                }
                if (this.visuPreferences.isDisplayVariablesEvaluation()) {
                    printStream.println(UNSET_AUTOSCALE);
                    printStream.println(SET_AUTOSCALE_Y);
                    printStream.println(SET_NOLOGSCALE_X);
                    printStream.println(SET_NOLOGSCALE_Y);
                    printStream.println(this.setYRangeFrom1ToNvar());
                    printStream.println(SET_XRANGE_0_5);
                    printStream.println(this.setSize(d7, d8));
                    printStream.println(this.setOrigin(d2, d5));
                    printStream.println(this.setTitle("Value of variables activity"));
                    gnuplotDataFile3 = new GnuplotDataFile(this.dataPath + "-heuristics.dat", Color.red, "Activity", "lines");
                    printStream.println(this.visuPreferences.generatePlotLine(gnuplotDataFile3, gnuplotFunction, "", false));
                }
                if (this.visuPreferences.isDisplaySpeed()) {
                    printStream.println(SET_AUTOSCALE_X);
                    printStream.println(SET_NOLOGSCALE_X);
                    printStream.println(SET_NOLOGSCALE_Y);
                    printStream.println(this.setSize(d7, d8));
                    printStream.println(this.setOrigin(d, d5));
                    printStream.println(this.setTitle("Number of propagations per second"));
                    printStream.println(SET_Y2RANGE_0);
                    gnuplotDataFile3 = new GnuplotDataFile(this.dataPath + SPEED_DAT, Color.cyan, SPEED, "lines");
                    object = new GnuplotDataFile(this.dataPath + "-speed-clean.dat", Color.orange, CLEAN, IMPULSES);
                    gnuplotDataFile2 = new GnuplotDataFile(this.dataPath + SPEED_RESTART_DAT, Color.gray, RESTART, IMPULSES);
                    printStream.println(this.visuPreferences.generatePlotLineOnDifferenteAxes(new GnuplotDataFile[]{gnuplotDataFile3}, new GnuplotDataFile[]{object, gnuplotDataFile2}, true, 50));
                }
                printStream.println(UNSET_MULTIPLOT);
                int n = this.visuPreferences.getRefreshTime() / 1000;
                printStream.println("pause " + n);
                printStream.println(REREAD);
                printStream.close();
                this.logger.log(GNUPLOT_WILL_START_IN_A_FEW_SECONDS);
                object = new Thread(){

                    public void run() {
                        try {
                            String string;
                            try {
                                Thread.sleep(GnuplotBasedSolverVisualisation.this.visuPreferences.getTimeBeforeLaunching());
                            }
                            catch (InterruptedException interruptedException) {
                                GnuplotBasedSolverVisualisation.this.logger.log(interruptedException.getMessage());
                            }
                            GnuplotBasedSolverVisualisation.this.logger.log("reads " + GnuplotBasedSolverVisualisation.this.dataPath + GnuplotBasedSolverVisualisation.GNUPLOT_GNUPLOT);
                            GnuplotBasedSolverVisualisation.this.gnuplotProcess = Runtime.getRuntime().exec(GnuplotBasedSolverVisualisation.this.visuPreferences.createCommandLine(GnuplotBasedSolverVisualisation.this.dataPath + GnuplotBasedSolverVisualisation.GNUPLOT_GNUPLOT));
                            GnuplotBasedSolverVisualisation.this.logger.log(GnuplotBasedSolverVisualisation.GNUPLOT_SHOULD_HAVE_STARTED_NOW);
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(GnuplotBasedSolverVisualisation.this.gnuplotProcess.getErrorStream()));
                            while ((string = bufferedReader.readLine()) != null) {
                                if (string.trim().length() <= 0 || string.toLowerCase().contains("warning") || string.toLowerCase().contains("plot")) continue;
                                GnuplotBasedSolverVisualisation.this.logger.log(string);
                            }
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            GnuplotBasedSolverVisualisation.this.logger.log(iOException.getMessage());
                        }
                    }
                };
                ((Thread)object).start();
            }
            catch (IOException iOException) {
                this.logger.log(iOException.getMessage());
            }
        }
    }

    private String setYTicsFrom1ToNVar() {
        return "set ytics add (1," + this.nVar + ")";
    }

    private String setYRangeFrom1ToNvar() {
        return "set yrange [1:" + this.nVar + "]";
    }

    private String setOrigin(double d, double d2) {
        return "set origin " + d2 + "," + d;
    }

    private String setSize(double d, double d2) {
        return "set size " + d + "," + d2;
    }

    private String setTitle(String string) {
        return "set title \"" + string + "\"";
    }

    public void stopGnuplot() {
        if (this.gnuplotProcess != null) {
            this.gnuplotProcess.destroy();
            this.logger.log(GNUPLOT_SHOULD_BE_DEACTIVATED);
        }
        this.gnuplotProcess = null;
    }

    public void setnVar(int n) {
        this.nVar = n;
    }
}

