/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat.visu;

import java.awt.Color;
import org.sat4j.sat.visu.GnuplotDataFile;
import org.sat4j.sat.visu.GnuplotFunction;

public class VisuPreferences {
    private static final int DEFAULT_TIME_BEFORE_LAUNCHING = 8000;
    private static final int DEFAULT_REFRESH_TIME = 500;
    private static final int DEFAULT_LINES_READ = 11000;
    private static final String AXIS_X1Y1 = "\" axis x1y1";
    private static final String TITLE = "\" title \"";
    private static final String LC_RGB = " lc rgb \"#";
    private Color backgroundColor = Color.white;
    private Color borderColor = Color.black;
    private int timeBeforeLaunching = 8000;
    private int refreshTime = 500;
    private int nbLinesRead = 11000;
    private boolean displayRestarts = true;
    private Color restartColor = Color.LIGHT_GRAY;
    private boolean slidingWindows = true;
    private boolean displayDecisionIndexes = true;
    private boolean displaySpeed = false;
    private boolean displayConflictsTrail = true;
    private boolean displayConflictsDecision = true;
    private boolean displayVariablesEvaluation = false;
    private boolean displayClausesEvaluation = true;
    private boolean displayClausesSize = true;

    public boolean isDisplayClausesSize() {
        return this.displayClausesSize;
    }

    public void setDisplayClausesSize(boolean bl) {
        this.displayClausesSize = bl;
    }

    public int getNumberOfDisplayedGraphs() {
        int n = 0;
        if (this.displayClausesEvaluation) {
            ++n;
        }
        if (this.displayConflictsTrail) {
            ++n;
        }
        if (this.displayConflictsDecision) {
            ++n;
        }
        if (this.displayDecisionIndexes) {
            n += 2;
        }
        if (this.displaySpeed) {
            ++n;
        }
        if (this.displayVariablesEvaluation) {
            ++n;
        }
        if (this.displayClausesSize) {
            ++n;
        }
        return n;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public int getTimeBeforeLaunching() {
        return this.timeBeforeLaunching;
    }

    public void setTimeBeforeLaunching(int n) {
        this.timeBeforeLaunching = n;
    }

    public int getRefreshTime() {
        return this.refreshTime;
    }

    public void setRefreshTime(int n) {
        this.refreshTime = n;
    }

    public int getNbLinesRead() {
        return this.nbLinesRead;
    }

    public void setNbLinesRead(int n) {
        this.nbLinesRead = n;
    }

    public boolean isDisplayRestarts() {
        return this.displayRestarts;
    }

    public void setDisplayRestarts(boolean bl) {
        this.displayRestarts = bl;
    }

    public Color getRestartColor() {
        return this.restartColor;
    }

    public void setRestartColor(Color color) {
        this.restartColor = color;
    }

    public boolean isSlidingWindows() {
        return this.slidingWindows;
    }

    public void setSlidingWindows(boolean bl) {
        this.slidingWindows = bl;
    }

    public boolean isDisplayDecisionIndexes() {
        return this.displayDecisionIndexes;
    }

    public void setDisplayDecisionIndexes(boolean bl) {
        this.displayDecisionIndexes = bl;
    }

    public boolean isDisplaySpeed() {
        return this.displaySpeed;
    }

    public void setDisplaySpeed(boolean bl) {
        this.displaySpeed = bl;
    }

    public boolean isDisplayConflictsTrail() {
        return this.displayConflictsTrail;
    }

    public void setDisplayConflictsTrail(boolean bl) {
        this.displayConflictsTrail = bl;
    }

    public boolean isDisplayConflictsDecision() {
        return this.displayConflictsDecision;
    }

    public void setDisplayConflictsDecision(boolean bl) {
        this.displayConflictsDecision = bl;
    }

    public boolean isDisplayVariablesEvaluation() {
        return this.displayVariablesEvaluation;
    }

    public void setDisplayVariablesEvaluation(boolean bl) {
        this.displayVariablesEvaluation = bl;
    }

    public boolean isDisplayClausesEvaluation() {
        return this.displayClausesEvaluation;
    }

    public void setDisplayClausesEvaluation(boolean bl) {
        this.displayClausesEvaluation = bl;
    }

    public String toString() {
        return "GnuplotPreferences [backgroundColor=" + this.backgroundColor + ", borderColor=" + this.borderColor + ", timeBeforeLaunching=" + this.timeBeforeLaunching + ", refreshTime=" + this.refreshTime + ", slidingWindows=" + this.slidingWindows + ", nbLinesRead=" + this.nbLinesRead + ", displayRestarts=" + this.displayRestarts + "]";
    }

    public String[] createCommandLine(String string) {
        String string2 = Integer.toHexString(this.backgroundColor.getRGB());
        string2 = string2.substring(2, string2.length());
        String string3 = Integer.toHexString(this.borderColor.getRGB());
        string3 = string3.substring(2, string3.length());
        String[] stringArray = new String[]{"gnuplot", "-bg", "#" + string2, "-xrm", "gnuplot*borderColor:#" + string3, string};
        return stringArray;
    }

    public String generatePlotLine(GnuplotDataFile gnuplotDataFile, boolean bl) {
        return this.generatePlotLine(new GnuplotDataFile[]{gnuplotDataFile}, "", bl);
    }

    public String generatePlotLine(GnuplotDataFile gnuplotDataFile) {
        return this.generatePlotLine(new GnuplotDataFile[]{gnuplotDataFile}, "", this.slidingWindows);
    }

    public String generatePlotLine(GnuplotDataFile gnuplotDataFile, String string) {
        return this.generatePlotLine(new GnuplotDataFile[]{gnuplotDataFile}, string, this.slidingWindows);
    }

    public String generatePlotLine(GnuplotDataFile gnuplotDataFile, String string, boolean bl) {
        return this.generatePlotLine(new GnuplotDataFile[]{gnuplotDataFile}, string, bl);
    }

    public String generatePlotLine(GnuplotDataFile gnuplotDataFile, String string, boolean bl, int n) {
        return this.generatePlotLine(new GnuplotDataFile[]{gnuplotDataFile}, new GnuplotFunction[0], string, bl, n);
    }

    public String generatePlotLine(GnuplotDataFile[] gnuplotDataFileArray, String string, boolean bl) {
        return this.generatePlotLine(gnuplotDataFileArray, new GnuplotFunction[0], string, bl);
    }

    public String generatePlotLine(GnuplotDataFile gnuplotDataFile, GnuplotFunction gnuplotFunction, String string, boolean bl, int n) {
        return this.generatePlotLine(new GnuplotDataFile[]{gnuplotDataFile}, new GnuplotFunction[]{gnuplotFunction}, string, bl, n);
    }

    public String generatePlotLine(GnuplotDataFile gnuplotDataFile, GnuplotFunction gnuplotFunction, String string, boolean bl) {
        return this.generatePlotLine(new GnuplotDataFile[]{gnuplotDataFile}, new GnuplotFunction[]{gnuplotFunction}, string, bl);
    }

    public String generatePlotLine(GnuplotDataFile[] gnuplotDataFileArray, GnuplotFunction[] gnuplotFunctionArray, String string, boolean bl) {
        return this.generatePlotLine(gnuplotDataFileArray, gnuplotFunctionArray, string, bl, this.nbLinesRead);
    }

    public String generatePlotLine(GnuplotDataFile[] gnuplotDataFileArray, GnuplotFunction[] gnuplotFunctionArray, String string, boolean bl, int n) {
        String string2;
        String string3;
        int n2;
        boolean bl2;
        String string4 = string.length() == 0 ? "if(system(\"head " + gnuplotDataFileArray[0].getFilename() + " | wc -l\")!=0){" : "if(system(\"head " + gnuplotDataFileArray[0].getFilename() + " | wc -l\")!=0 && system(\"head " + string + " | wc -l\")!=0){";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("plot");
        String string5 = "";
        if (this.slidingWindows && bl) {
            string5 = "< tail -" + n + " ";
        }
        boolean bl3 = bl2 = this.displayRestarts && string.length() > 0;
        if (bl2) {
            String string6 = Integer.toHexString(this.restartColor.getRGB());
            string6 = string6.substring(2, string6.length());
            String string7 = "\"" + string5 + string + "\"" + " with impulses lc rgb \"#" + string6 + "\" title \"Restart\" axis x1y2";
            stringBuffer.append(string7);
        }
        for (n2 = 0; n2 < gnuplotDataFileArray.length; ++n2) {
            string3 = Integer.toHexString(gnuplotDataFileArray[n2].getColor().getRGB());
            string3 = string3.substring(2, string3.length());
            string2 = "";
            if (bl2 || n2 != 0) {
                string2 = ",";
            }
            String string8 = "";
            if (gnuplotDataFileArray[n2].getStyle().length() > 0) {
                string8 = " with " + gnuplotDataFileArray[n2].getStyle();
            }
            stringBuffer.append(string2 + "\"" + string5 + gnuplotDataFileArray[n2].getFilename() + "\"" + string8 + LC_RGB + string3 + TITLE + gnuplotDataFileArray[n2].getTitle() + AXIS_X1Y1);
        }
        for (n2 = 0; n2 < gnuplotFunctionArray.length; ++n2) {
            string3 = Integer.toHexString(gnuplotFunctionArray[n2].getColor().getRGB());
            string3 = string3.substring(2, string3.length());
            string2 = "";
            if (gnuplotDataFileArray.length > 0 || bl2 || n2 != 0) {
                string2 = ",";
            }
            stringBuffer.append(string2 + gnuplotFunctionArray[n2].getFunctionExpression() + LC_RGB + string3 + TITLE + gnuplotFunctionArray[n2].getFunctionLegend() + AXIS_X1Y1);
        }
        string4 = string4 + stringBuffer.toString() + "}";
        return string4;
    }

    public String generatePlotLineOnDifferenteAxes(GnuplotDataFile[] gnuplotDataFileArray, GnuplotDataFile[] gnuplotDataFileArray2, boolean bl) {
        return this.generatePlotLineOnDifferenteAxes(gnuplotDataFileArray, gnuplotDataFileArray2, bl, this.nbLinesRead);
    }

    public String generatePlotLineOnDifferenteAxes(GnuplotDataFile[] gnuplotDataFileArray, GnuplotDataFile[] gnuplotDataFileArray2, boolean bl, int n) {
        return this.generatePlotLineOnDifferenteAxes(gnuplotDataFileArray, gnuplotDataFileArray2, new GnuplotFunction[0], bl, n);
    }

    public String generatePlotLineOnDifferenteAxes(GnuplotDataFile[] gnuplotDataFileArray, GnuplotDataFile[] gnuplotDataFileArray2, GnuplotFunction[] gnuplotFunctionArray, boolean bl) {
        return this.generatePlotLineOnDifferenteAxes(gnuplotDataFileArray, gnuplotDataFileArray2, new GnuplotFunction[0], bl, this.nbLinesRead);
    }

    public String generatePlotLineOnDifferenteAxes(GnuplotDataFile[] gnuplotDataFileArray, GnuplotDataFile[] gnuplotDataFileArray2, GnuplotFunction[] gnuplotFunctionArray, boolean bl, int n) {
        String string;
        String string2;
        String string3;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("plot ");
        String string4 = "";
        if (this.slidingWindows && bl) {
            string4 = "< tail -" + n + " ";
        }
        for (n2 = 0; n2 < gnuplotDataFileArray2.length; ++n2) {
            string3 = Integer.toHexString(gnuplotDataFileArray2[n2].getColor().getRGB());
            string3 = string3.substring(2, string3.length());
            string2 = "";
            if (n2 != 0) {
                string2 = ",";
            }
            string = "";
            if (gnuplotDataFileArray2[n2].getStyle().length() > 0) {
                string = " with " + gnuplotDataFileArray2[n2].getStyle();
            }
            stringBuffer.append(string2 + "\"" + string4 + gnuplotDataFileArray2[n2].getFilename() + "\"" + string + LC_RGB + string3 + TITLE + gnuplotDataFileArray2[n2].getTitle() + "\" axis x1y2");
        }
        for (n2 = 0; n2 < gnuplotDataFileArray.length; ++n2) {
            string3 = Integer.toHexString(gnuplotDataFileArray[n2].getColor().getRGB());
            string3 = string3.substring(2, string3.length());
            string2 = "";
            if (gnuplotDataFileArray2.length > 0 || n2 != 0) {
                string2 = ",";
            }
            string = "";
            if (gnuplotDataFileArray[n2].getStyle().length() > 0) {
                string = " with " + gnuplotDataFileArray[n2].getStyle();
            }
            stringBuffer.append(string2 + "\"" + string4 + gnuplotDataFileArray[n2].getFilename() + "\"" + string + LC_RGB + string3 + TITLE + gnuplotDataFileArray[n2].getTitle() + AXIS_X1Y1);
        }
        for (n2 = 0; n2 < gnuplotFunctionArray.length; ++n2) {
            string3 = Integer.toHexString(gnuplotFunctionArray[n2].getColor().getRGB());
            string3 = string3.substring(2, string3.length());
            string2 = "";
            if (gnuplotDataFileArray.length > 0 || gnuplotDataFileArray2.length > 0 || n2 != 0) {
                string2 = ",";
            }
            stringBuffer.append(string2 + gnuplotFunctionArray[n2].getFunctionExpression() + LC_RGB + string3 + TITLE + gnuplotFunctionArray[n2].getFunctionLegend() + AXIS_X1Y1);
        }
        return stringBuffer.toString();
    }
}

