/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.Lbool;
import org.sat4j.tools.IVisualizationTool;
import org.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictLevelTracing
extends SearchListenerAdapter<ISolverService> {
    private int counter;
    private static final long serialVersionUID = 1L;
    private int nVar;
    private int maxDLevel;
    private final IVisualizationTool visuTool;
    private final IVisualizationTool restartVisuTool;
    private final IVisualizationTool cleanTool;

    public ConflictLevelTracing(IVisualizationTool iVisualizationTool, IVisualizationTool iVisualizationTool2, IVisualizationTool iVisualizationTool3) {
        this.visuTool = iVisualizationTool;
        this.restartVisuTool = iVisualizationTool2;
        this.cleanTool = iVisualizationTool3;
        this.counter = 1;
        this.maxDLevel = 0;
    }

    @Override
    public void conflictFound(IConstr iConstr, int n, int n2) {
        if (n > this.maxDLevel) {
            this.maxDLevel = n;
        }
        this.visuTool.addPoint(this.counter, n);
        this.restartVisuTool.addInvisiblePoint(this.counter, this.maxDLevel);
        this.cleanTool.addInvisiblePoint(this.counter, this.maxDLevel);
        ++this.counter;
    }

    @Override
    public void restarting() {
        this.restartVisuTool.addPoint(this.counter, this.maxDLevel);
        this.cleanTool.addPoint(this.counter, 0.0);
        this.visuTool.addInvisiblePoint(this.counter, this.nVar);
    }

    @Override
    public void end(Lbool lbool) {
        this.visuTool.end();
        this.cleanTool.end();
        this.restartVisuTool.end();
    }

    @Override
    public void start() {
        this.visuTool.init();
        this.restartVisuTool.init();
        this.cleanTool.init();
        this.counter = 1;
        this.maxDLevel = 0;
    }

    @Override
    public void init(ISolverService iSolverService) {
        this.nVar = iSolverService.nVars();
    }

    @Override
    public void cleaning() {
        this.restartVisuTool.addPoint(this.counter, 0.0);
        this.cleanTool.addPoint(this.counter, this.maxDLevel);
        this.visuTool.addInvisiblePoint(this.counter, this.nVar);
    }
}

