/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractLauncher;
import org.sat4j.ILauncherMode;
import org.sat4j.maxsat.MinCostDecorator;
import org.sat4j.maxsat.SolverFactory;
import org.sat4j.maxsat.WeightedMaxSatDecorator;
import org.sat4j.maxsat.reader.WDimacsReader;
import org.sat4j.opt.MinOneDecorator;
import org.sat4j.pb.ConstraintRelaxingPseudoOptDecorator;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.tools.ManyCorePB;
import org.sat4j.pb.tools.SearchOptimizerListener;
import org.sat4j.reader.LecteurDimacs;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.SolverDecorator;

public class GenericOptLauncher
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    private WeightedMaxSatDecorator wmsd;

    public GenericOptLauncher() {
        this.setLauncherMode(ILauncherMode.OPTIMIZATION);
    }

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("s", "solver", true, "specifies the name of a PB solver");
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("p", "parallel", false, "uses CP and RES pseudo-boolean solvers in parallel");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("K", "kind", true, "kind of problem: minone, maxsat, etc.");
        options.addOption("i", "incomplete", false, "incomplete mode for maxsat");
        options.addOption("I", "inner mode", false, "optimize using inner mode");
        options.addOption("c", "clean databases", false, "clean up the database at root level");
        options.addOption("k", "keep Hot", false, "Keep heuristics accross calls to the SAT solver");
        options.addOption("e", "equivalence", false, "Use an equivalence instead of an implication for the selector variables");
        options.addOption("pi", "prime-implicant", false, "Use prime implicants instead of models for evaluating the objective function");
        options.addOption("n", "no solution line", false, "Do not display a solution line (useful if the solution is large)");
        options.addOption("l", "lower bounding", false, "search solution by lower bounding instead of by upper bounding");
        options.addOption("m", "mystery", false, "mystery option");
        options.addOption("B", "External&Internal", false, "External&Internal optimization");
        return options;
    }

    public void displayLicense() {
        super.displayLicense();
        this.log("This software uses some libraries from the Jakarta Commons project. See jakarta.apache.org for details.");
    }

    public void usage() {
        this.out.println("java -jar sat4j-maxsat.jar instance-name");
    }

    protected Reader createReader(ISolver iSolver, String string) {
        Reader reader = string.contains(".wcnf") ? new WDimacsReader(this.wmsd) : new LecteurDimacs(iSolver);
        reader.setVerbosity(true);
        return reader;
    }

    protected String getInstanceName(String[] stringArray) {
        return stringArray[stringArray.length - 1];
    }

    protected ISolver configureSolver(String[] stringArray) {
        SolverDecorator solverDecorator = null;
        Options options = this.createCLIOptions();
        if (stringArray.length == 0) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j-maxsat.jar", options, true);
            System.exit(0);
        } else {
            try {
                Object object;
                String string;
                CommandLine commandLine = new PosixParser().parse(options, stringArray);
                int n = stringArray.length - 1;
                this.setDisplaySolutionLine(!commandLine.hasOption("n"));
                boolean bl = commandLine.hasOption("e");
                String string2 = commandLine.getOptionValue("K");
                if (string2 == null) {
                    string2 = "maxsat";
                }
                if ((string = commandLine.getOptionValue("s")) == null) {
                    string = "Default";
                }
                if ("minone".equalsIgnoreCase(string2)) {
                    solverDecorator = new MinOneDecorator(org.sat4j.minisat.SolverFactory.newDefault());
                } else if ("mincost".equalsIgnoreCase(string2) || stringArray[n].endsWith(".p2cnf")) {
                    solverDecorator = new MinCostDecorator(SolverFactory.newDefault());
                } else {
                    assert ("maxsat".equalsIgnoreCase(string2));
                    this.wmsd = commandLine.hasOption("m") ? new WeightedMaxSatDecorator(org.sat4j.pb.SolverFactory.newSATUNSAT(), bl) : (commandLine.hasOption("p") ? new WeightedMaxSatDecorator(org.sat4j.pb.SolverFactory.newBoth(), bl) : new WeightedMaxSatDecorator((IPBSolver)org.sat4j.pb.SolverFactory.instance().createSolverByName(string), bl));
                    if (commandLine.hasOption("l")) {
                        solverDecorator = new ConstraintRelaxingPseudoOptDecorator(this.wmsd);
                    } else if (commandLine.hasOption("I")) {
                        this.wmsd.setSearchListener(new SearchOptimizerListener(ILauncherMode.DECISION));
                        this.setLauncherMode(ILauncherMode.DECISION);
                        solverDecorator = this.wmsd;
                    } else if (commandLine.hasOption("B")) {
                        object = org.sat4j.pb.SolverFactory.newDefault();
                        object.setSearchListener(new SearchOptimizerListener(ILauncherMode.DECISION));
                        IPBSolver iPBSolver = org.sat4j.pb.SolverFactory.newDefault();
                        iPBSolver = new OptToPBSATAdapter(new PseudoOptDecorator(iPBSolver), ILauncherMode.DECISION);
                        ManyCorePB manyCorePB = new ManyCorePB(new IPBSolver[]{iPBSolver, object});
                        this.wmsd = new WeightedMaxSatDecorator(manyCorePB, bl);
                        this.setLauncherMode(ILauncherMode.DECISION);
                        solverDecorator = this.wmsd;
                    } else {
                        solverDecorator = new PseudoOptDecorator(this.wmsd, false, commandLine.hasOption("pi"));
                    }
                }
                if (commandLine.hasOption("i")) {
                    this.setIncomplete(true);
                }
                if (commandLine.hasOption("c")) {
                    solverDecorator.setDBSimplificationAllowed(true);
                }
                if (commandLine.hasOption("k")) {
                    solverDecorator.setKeepSolverHot(true);
                }
                if ((object = commandLine.getOptionValue("t")) == null) {
                    object = commandLine.getOptionValue("T");
                    if (object != null) {
                        solverDecorator.setTimeoutMs(Long.parseLong((String)object));
                    }
                } else {
                    solverDecorator.setTimeout(Integer.parseInt((String)object));
                }
                this.getLogWriter().println(solverDecorator.toString("c "));
            }
            catch (ParseException parseException) {
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("java -jar sat4jopt.jar", options, true);
            }
        }
        return solverDecorator;
    }

    public static void main(String[] stringArray) {
        GenericOptLauncher genericOptLauncher = new GenericOptLauncher();
        genericOptLauncher.run(stringArray);
    }

    protected IProblem readProblem(String string) throws ParseFormatException, IOException, ContradictionException {
        super.readProblem(string);
        return this.solver;
    }
}

