/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.maxsat.UnitWeightedClause;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedMaxSatDecorator
extends PBSolverDecorator {
    public static final BigInteger SAT4J_MAX_BIG_INTEGER = new BigInteger("100000000000000000000000000000000000000000");
    protected int nbnewvar;
    private static final long serialVersionUID = 1L;
    private BigInteger falsifiedWeight = BigInteger.ZERO;
    private boolean maxVarIdFixed = false;
    private final boolean equivalence;
    private final IVecInt lits = new VecInt();
    private final IVec<BigInteger> coefs = new Vec<BigInteger>();
    private final ObjectiveFunction obj = new ObjectiveFunction(this.lits, this.coefs);
    private final Set<Integer> unitClauses = new HashSet<Integer>();
    private boolean noNewVarForUnitSoftClauses = true;
    protected BigInteger top = SAT4J_MAX_BIG_INTEGER;

    public WeightedMaxSatDecorator(IPBSolver iPBSolver) {
        this(iPBSolver, false);
    }

    public WeightedMaxSatDecorator(IPBSolver iPBSolver, boolean bl) {
        super(iPBSolver);
        iPBSolver.setObjectiveFunction(this.obj);
        this.equivalence = bl;
    }

    @Override
    public int newVar(int n) {
        int n2 = super.newVar(n);
        this.maxVarIdFixed = true;
        return n2;
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.lits.ensure(n);
        this.falsifiedWeight = BigInteger.ZERO;
        super.setExpectedNumberOfClauses(n);
    }

    public void setTopWeight(BigInteger bigInteger) {
        this.top = bigInteger;
    }

    protected void checkMaxVarId() {
        if (!this.maxVarIdFixed) {
            throw new IllegalStateException("Please call newVar(int) before adding constraints!!!");
        }
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        return this.addSoftClause(1, iVecInt);
    }

    public IConstr addHardClause(IVecInt iVecInt) throws ContradictionException {
        return super.addClause(iVecInt);
    }

    public IConstr addSoftClause(IVecInt iVecInt) throws ContradictionException {
        return this.addSoftClause(1, iVecInt);
    }

    public IConstr addSoftClause(int n, IVecInt iVecInt) throws ContradictionException {
        return this.addSoftClause(BigInteger.valueOf(n), iVecInt);
    }

    public IConstr addSoftClause(BigInteger bigInteger, IVecInt iVecInt) throws ContradictionException {
        IConstr iConstr;
        this.checkMaxVarId();
        if (bigInteger.compareTo(this.top) < 0) {
            if (iVecInt.size() == 1 && this.noNewVarForUnitSoftClauses) {
                int n = -iVecInt.get(0);
                int n2 = this.lits.containsAt(n);
                this.unitClauses.add(-n);
                if (n2 == -1) {
                    n2 = this.lits.containsAt(-n);
                    if (n2 != -1) {
                        this.falsifiedWeight = this.falsifiedWeight.add(bigInteger);
                        BigInteger bigInteger2 = this.coefs.get(n2);
                        BigInteger bigInteger3 = bigInteger2.subtract(bigInteger);
                        if (bigInteger3.signum() > 0) {
                            this.coefs.set(n2, bigInteger3);
                        } else if (bigInteger3.signum() < 0) {
                            this.lits.set(n2, n);
                            this.coefs.set(n2, bigInteger3.abs());
                            this.falsifiedWeight = this.falsifiedWeight.add(bigInteger3);
                        } else {
                            assert (bigInteger3.signum() == 0);
                            this.lits.delete(n2);
                            this.coefs.delete(n2);
                        }
                        this.obj.setCorrection(this.falsifiedWeight);
                    } else {
                        this.registerLiteral(n);
                        this.lits.push(n);
                        this.coefs.push(bigInteger);
                    }
                } else {
                    this.coefs.set(n2, this.coefs.get(n2).add(bigInteger));
                }
                return UnitWeightedClause.instance();
            }
            this.coefs.push(bigInteger);
            int n = this.nextFreeVarId(true);
            iVecInt.push(n);
            this.lits.push(n);
            if (this.equivalence) {
                ConstrGroup constrGroup = new ConstrGroup();
                IConstr iConstr2 = super.addClause(iVecInt);
                if (iConstr2 == null && this.isVerbose()) {
                    System.out.println(String.valueOf(this.getLogPrefix()) + " solft constraint " + iVecInt + "(" + bigInteger + ") is ignored");
                }
                if (iConstr2 != null) {
                    constrGroup.add(iConstr2);
                    VecInt vecInt = new VecInt(2);
                    vecInt.push(-n);
                    int n3 = 0;
                    while (n3 < iVecInt.size() - 1) {
                        vecInt.push(-iVecInt.get(n3));
                        constrGroup.add(super.addClause(vecInt));
                        vecInt.pop();
                        ++n3;
                    }
                }
                return constrGroup;
            }
        }
        if ((iConstr = super.addClause(iVecInt)) == null && this.isVerbose()) {
            System.out.println(String.valueOf(this.getLogPrefix()) + " hard constraint " + iVecInt + "(" + bigInteger + ") is ignored");
        }
        return iConstr;
    }

    public IConstr addSoftAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        return this.addSoftAtLeast(BigInteger.ONE, iVecInt, n);
    }

    public IConstr addSoftAtLeast(int n, IVecInt iVecInt, int n2) throws ContradictionException {
        return this.addSoftAtLeast(BigInteger.valueOf(n), iVecInt, n2);
    }

    public IConstr addSoftAtLeast(BigInteger bigInteger, IVecInt iVecInt, int n) throws ContradictionException {
        this.checkMaxVarId();
        if (bigInteger.compareTo(this.top) < 0) {
            this.coefs.push(bigInteger);
            int n2 = this.nextFreeVarId(true);
            this.lits.push(n2);
            Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt.size() + 1);
            vec.growTo(iVecInt.size(), BigInteger.ONE);
            iVecInt.push(n2);
            BigInteger bigInteger2 = BigInteger.valueOf(n);
            vec.push(bigInteger2);
            return this.addPseudoBoolean(iVecInt, vec, true, bigInteger2);
        }
        return this.addAtLeast(iVecInt, n);
    }

    public IConstr addSoftAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        return this.addSoftAtMost(BigInteger.ONE, iVecInt, n);
    }

    public IConstr addSoftAtMost(int n, IVecInt iVecInt, int n2) throws ContradictionException {
        return this.addSoftAtMost(BigInteger.valueOf(n), iVecInt, n2);
    }

    public IConstr addSoftAtMost(BigInteger bigInteger, IVecInt iVecInt, int n) throws ContradictionException {
        this.checkMaxVarId();
        if (bigInteger.compareTo(this.top) < 0) {
            this.coefs.push(bigInteger);
            int n2 = this.nextFreeVarId(true);
            this.lits.push(n2);
            Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt.size() + 1);
            vec.growTo(iVecInt.size(), BigInteger.ONE);
            iVecInt.push(n2);
            BigInteger bigInteger2 = BigInteger.valueOf(n);
            vec.push(bigInteger2.negate());
            return this.addPseudoBoolean(iVecInt, vec, true, bigInteger2);
        }
        return this.addAtMost(iVecInt, n);
    }

    public void addLiteralsToMinimize(IVecInt iVecInt) {
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            this.lits.push(iteratorInt.next());
            this.coefs.push(BigInteger.ONE);
        }
    }

    public void addWeightedLiteralsToMinimize(IVecInt iVecInt, IVec<BigInteger> iVec) {
        if (iVecInt.size() != this.coefs.size()) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < iVecInt.size()) {
            this.lits.push(iVecInt.get(n));
            this.coefs.push(iVec.get(n));
            ++n;
        }
    }

    public void addWeightedLiteralsToMinimize(IVecInt iVecInt, IVecInt iVecInt2) {
        if (iVecInt.size() != iVecInt2.size()) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < iVecInt.size()) {
            this.lits.push(iVecInt.get(n));
            this.coefs.push(BigInteger.valueOf(iVecInt2.get(n)));
            ++n;
        }
    }

    @Override
    public void reset() {
        this.coefs.clear();
        this.lits.clear();
        this.nbnewvar = 0;
        super.reset();
    }

    public void forceObjectiveValueTo(Number number) throws ContradictionException {
        if (this.lits.size() > 0) {
            super.addPseudoBoolean(this.lits, this.coefs, false, (BigInteger)number);
        }
    }

    public Set<Integer> getUnitClauses() {
        return this.unitClauses;
    }

    public boolean isNoNewVarForUnitSoftClauses() {
        return this.noNewVarForUnitSoftClauses;
    }

    public void setNoNewVarForUnitSoftClauses(boolean bl) {
        this.noNewVarForUnitSoftClauses = bl;
    }
}

