/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class ConstraintRelaxingPseudoOptDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private IConstr previousPBConstr;
    private IConstr addedConstr = null;
    private Number objectiveValue;
    private boolean optimumFound = false;

    public ConstraintRelaxingPseudoOptDecorator(IPBSolver iPBSolver) {
        super(iPBSolver);
    }

    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, bl);
    }

    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        boolean bl2 = super.isSatisfiable(iVecInt, true);
        if (bl2) {
            this.calculateObjective();
        } else if (this.previousPBConstr != null) {
            ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
            this.previousPBConstr = null;
        }
        return bl2;
    }

    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        return this.isSatisfiable(iVecInt, true);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        if (this.optimumFound) {
            return false;
        }
        int n = this.getObjectiveFunction().minValue().intValue();
        while (true) {
            if (this.addedConstr != null) {
                ((IPBSolver)this.decorated()).removeConstr(this.addedConstr);
            }
            try {
                this.forceObjectiveValueTo(n++);
            }
            catch (ContradictionException contradictionException) {
                if (!this.isVerbose()) continue;
                System.out.println(String.valueOf(((IPBSolver)this.decorated()).getLogPrefix()) + "no solution for objective value " + (n - 1));
                continue;
            }
            boolean bl = super.isSatisfiable(iVecInt, true);
            if (bl) {
                this.optimumFound = true;
                if (this.getObjectiveFunction() != null) {
                    this.calculateObjective();
                }
                ((IPBSolver)this.decorated()).removeConstr(this.addedConstr);
                return true;
            }
            if (!this.isVerbose()) continue;
            System.out.println(String.valueOf(((IPBSolver)this.decorated()).getLogPrefix()) + "no solution for objective value " + (n - 1));
        }
    }

    public boolean hasNoObjectiveFunction() {
        return this.getObjectiveFunction() == null;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    @Deprecated
    public Number calculateObjective() {
        if (this.getObjectiveFunction() == null) {
            throw new UnsupportedOperationException("The problem does not contain an objective function");
        }
        this.objectiveValue = this.getObjectiveFunction().calculateDegree(this);
        return this.objectiveValue;
    }

    public Number getObjectiveValue() {
        return this.objectiveValue;
    }

    public void forceObjectiveValueTo(Number number) throws ContradictionException {
        this.addedConstr = super.addPseudoBoolean(this.getObjectiveFunction().getVars(), this.getObjectiveFunction().getCoeffs(), false, BigInteger.valueOf(number.longValue()));
    }

    @Deprecated
    public void discard() {
        this.discardCurrentSolution();
    }

    public void discardCurrentSolution() {
    }

    public boolean isOptimal() {
        return this.optimumFound;
    }

    public String toString(String string) {
        return String.valueOf(string) + "Pseudo Boolean Optimization by lower bound\n" + super.toString(string);
    }

    public void setTimeoutForFindingBetterSolution(int n) {
        throw new UnsupportedOperationException("Does not make sense here");
    }
}

