/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.minisat.core.Constr;
import org.sat4j.pb.constraints.AbstractPBDataStructureFactory;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MapPb;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.constraints.pb.Pseudos;
import org.sat4j.pb.constraints.pb.PuebloMinWatchPb;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PuebloPBMinDataStructure
extends AbstractPBDataStructureFactory {
    private static final long serialVersionUID = 1L;

    @Override
    protected PBConstr constraintFactory(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        return PuebloMinWatchPb.normalizedMinWatchPbNew(this.solver, this.getVocabulary(), nArray, bigIntegerArray, bigInteger);
    }

    @Override
    protected PBConstr learntConstraintFactory(IDataStructurePB iDataStructurePB) {
        return PuebloMinWatchPb.normalizedWatchPbNew(this.getVocabulary(), iDataStructurePB);
    }

    private Constr learntConstraintFactory(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger, boolean bl) {
        int[] nArray = new int[iVecInt.size()];
        iVecInt.copyTo(nArray);
        BigInteger[] bigIntegerArray = new BigInteger[iVec.size()];
        iVec.copyTo(bigIntegerArray);
        bigInteger = Pseudos.niceCheckedParametersForCompetition(nArray, bigIntegerArray, bl, bigInteger);
        return PuebloMinWatchPb.normalizedWatchPbNew(this.getVocabulary(), new MapPb(iVecInt, iVec, bigInteger));
    }

    @Override
    protected Constr learntAtLeastConstraintFactory(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) {
        return this.learntConstraintFactory(iVecInt, iVec, bigInteger, true);
    }

    @Override
    protected Constr learntAtMostConstraintFactory(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) {
        return this.learntConstraintFactory(iVecInt, iVec, bigInteger, false);
    }
}

