/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.sat4j.core.Vec;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.LexicoDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicoDecoratorPB
extends LexicoDecorator<IPBSolver>
implements IPBSolver {
    private static final long serialVersionUID = 1L;
    protected final List<ObjectiveFunction> objs = new ArrayList<ObjectiveFunction>();
    private BigInteger bigCurrentValue;

    public LexicoDecoratorPB(IPBSolver iPBSolver) {
        super(iPBSolver);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addPseudoBoolean(iVecInt, iVec, bl, bigInteger);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.objs.get(this.currentCriterion);
    }

    @Override
    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        ((IPBSolver)this.decorated()).setObjectiveFunction(this.objs.get(this.currentCriterion));
        return super.admitABetterSolution(iVecInt);
    }

    @Override
    public void addCriterion(IVecInt iVecInt) {
        this.objs.add(new ObjectiveFunction(iVecInt, new Vec<BigInteger>(iVecInt.size(), BigInteger.ONE)));
    }

    public void addCriterion(IVecInt iVecInt, IVec<BigInteger> iVec) {
        this.objs.add(new ObjectiveFunction(iVecInt, iVec));
    }

    @Override
    protected Number evaluate() {
        this.bigCurrentValue = this.objs.get(this.currentCriterion).calculateDegree(this);
        return this.bigCurrentValue;
    }

    @Override
    protected Number evaluate(int n) {
        return this.objs.get(n).calculateDegree(this);
    }

    @Override
    protected void fixCriterionValue() throws ContradictionException {
        if (this.bigCurrentValue == null) {
            throw new ContradictionException("no current value computed!");
        }
        this.addExactly(this.objs.get(this.currentCriterion).getVars(), this.objs.get(this.currentCriterion).getCoeffs(), this.bigCurrentValue);
    }

    @Override
    protected IConstr discardSolutionsForOptimizing() throws ContradictionException {
        return this.addAtMost(this.objs.get(this.currentCriterion).getVars(), this.objs.get(this.currentCriterion).getCoeffs(), this.bigCurrentValue.subtract(BigInteger.ONE));
    }

    @Override
    public int numberOfCriteria() {
        return this.objs.size();
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addAtMost(iVecInt, iVecInt2, n);
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addAtMost(iVecInt, iVec, bigInteger);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addAtLeast(iVecInt, iVecInt2, n);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addAtLeast(iVecInt, iVec, bigInteger);
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addExactly(iVecInt, iVecInt2, n);
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addExactly(iVecInt, iVec, bigInteger);
    }
}

