/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolverService;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.Lbool;
import org.sat4j.specs.RandomAccessModel;
import org.sat4j.tools.SearchListenerAdapter;
import org.sat4j.tools.SolutionFoundListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchOptimizerListener
extends SearchListenerAdapter<IPBSolverService> {
    private static final long serialVersionUID = 1L;
    private IPBSolverService solverService;
    private ObjectiveFunction obj;
    private final SolutionFoundListener sfl;
    private BigInteger currentValue;
    private IConstr prevConstr = null;

    public SearchOptimizerListener(SolutionFoundListener solutionFoundListener) {
        this.sfl = solutionFoundListener;
    }

    @Override
    public void init(IPBSolverService iPBSolverService) {
        this.obj = iPBSolverService.getObjectiveFunction();
        this.solverService = iPBSolverService;
        this.currentValue = null;
        this.prevConstr = null;
    }

    @Override
    public void solutionFound(int[] nArray, RandomAccessModel randomAccessModel) {
        if (this.obj != null) {
            this.currentValue = this.obj.calculateDegree(randomAccessModel);
            System.out.println("o " + this.currentValue);
            if (this.prevConstr != null) {
                this.solverService.removeSubsumedConstr(this.prevConstr);
            }
            this.prevConstr = this.solverService.addAtMostOnTheFly(this.obj.getVars(), this.obj.getCoeffs(), this.currentValue.subtract(BigInteger.ONE));
        }
        this.sfl.onSolutionFound(nArray);
    }

    @Override
    public void end(Lbool lbool) {
        if (lbool == Lbool.FALSE) {
            this.sfl.onUnsatTermination();
            System.out.println(String.valueOf(this.solverService.getLogPrefix()) + "objective function=" + this.currentValue);
        }
    }

    public String toString() {
        return "Internal optimizer search listener";
    }
}

