/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Iterator;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.tools.LexicoDecoratorPB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class SteppedTimeoutLexicoDecoratorPB
extends LexicoDecoratorPB {
    private static final long serialVersionUID = 1L;

    public SteppedTimeoutLexicoDecoratorPB(IPBSolver iPBSolver) {
        super(iPBSolver);
    }

    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        block9: {
            ((IPBSolver)this.decorated()).setObjectiveFunction((ObjectiveFunction)this.objs.get(this.currentCriterion));
            this.isSolutionOptimal = false;
            try {
                if (!((IPBSolver)this.decorated()).isSatisfiable(iVecInt, true)) break block9;
                this.prevboolmodel = new boolean[this.nVars()];
                int n = 0;
                while (n < this.nVars()) {
                    this.prevboolmodel[n] = ((IPBSolver)this.decorated()).model(n + 1);
                    ++n;
                }
                this.prevfullmodel = ((IPBSolver)this.decorated()).model();
                this.prevmodelwithinternalvars = ((IPBSolver)this.decorated()).modelWithInternalVariables();
                this.calculateObjective();
                return true;
            }
            catch (TimeoutException timeoutException) {
                if (this.currentCriterion == this.numberOfCriteria() - 1) {
                    throw timeoutException;
                }
                this.mergeCurrentandNextCriteria();
                if (this.prevConstr != null) {
                    super.removeConstr(this.prevConstr);
                    this.prevConstr = null;
                }
                try {
                    this.fixCriterionValue();
                }
                catch (ContradictionException contradictionException) {
                    throw new IllegalStateException(contradictionException);
                }
                if (this.isVerbose()) {
                    System.out.println(String.valueOf(this.getLogPrefix()) + "Partial timeout criterion number " + (this.currentCriterion + 1));
                }
                ++this.currentCriterion;
                this.calculateObjective();
                ((IPBSolver)this.decorated()).expireTimeout();
                return true;
            }
        }
        ((IPBSolver)this.decorated()).expireTimeout();
        return this.manageUnsatCase();
    }

    private void mergeCurrentandNextCriteria() {
        ObjectiveFunction objectiveFunction = (ObjectiveFunction)this.objs.get(this.currentCriterion);
        int n = objectiveFunction.getVars().size();
        ObjectiveFunction objectiveFunction2 = (ObjectiveFunction)this.objs.get(this.currentCriterion + 1);
        int n2 = objectiveFunction2.getVars().size();
        VecInt vecInt = new VecInt(n + n2);
        objectiveFunction.getVars().copyTo(vecInt);
        objectiveFunction2.getVars().copyTo(vecInt);
        Vec<BigInteger> vec = new Vec<BigInteger>(n + n2);
        BigInteger bigInteger = BigInteger.valueOf(n2).add(BigInteger.ONE);
        Iterator<BigInteger> iterator = objectiveFunction.getCoeffs().iterator();
        while (iterator.hasNext()) {
            vec.push(iterator.next().multiply(bigInteger));
        }
        objectiveFunction2.getCoeffs().copyTo(vec);
        this.objs.set(this.currentCriterion + 1, new ObjectiveFunction(vecInt, vec));
    }
}

