/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Locale;
import org.sat4j.reader.AAGReader;
import org.sat4j.reader.AIGReader;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.LecteurDimacs;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;

public class InstanceReader
extends Reader {
    private AAGReader aag;
    private AIGReader aig;
    private DimacsReader ezdimacs;
    private LecteurDimacs dimacs;
    private Reader reader = null;
    private final ISolver solver;

    public InstanceReader(ISolver iSolver) {
        this.solver = iSolver;
    }

    private Reader getDefaultSATReader() {
        if (this.dimacs == null) {
            this.dimacs = new LecteurDimacs(this.solver);
        }
        return this.dimacs;
    }

    private Reader getEZSATReader() {
        if (this.ezdimacs == null) {
            this.ezdimacs = new DimacsReader(this.solver);
        }
        return this.ezdimacs;
    }

    private Reader getAIGReader() {
        if (this.aig == null) {
            this.aig = new AIGReader(this.solver);
        }
        return this.aig;
    }

    private Reader getAAGReader() {
        if (this.aag == null) {
            this.aag = new AAGReader(this.solver);
        }
        return this.aag;
    }

    public IProblem parseInstance(String string) throws ParseFormatException, IOException, ContradictionException {
        String string2 = "";
        if (string.startsWith("http://")) {
            string = string.substring(string.lastIndexOf(47), string.length() - 1);
        }
        if (string.indexOf(58) != -1) {
            String[] stringArray = string.split(":");
            string = stringArray[1];
            string2 = stringArray[0].toUpperCase(Locale.getDefault());
        }
        String string3 = string.endsWith(".gz") || string.endsWith(".bz2") ? string.substring(0, string.lastIndexOf(46)) : string;
        this.reader = this.handleFileName(string3, string2);
        return this.reader.parseInstance(string);
    }

    protected Reader handleFileName(String string, String string2) {
        if ("EZCNF".equals(string2)) {
            return this.getEZSATReader();
        }
        if (string.endsWith(".aag")) {
            return this.getAAGReader();
        }
        if (string.endsWith(".aig")) {
            return this.getAIGReader();
        }
        return this.getDefaultSATReader();
    }

    @Deprecated
    public String decode(int[] nArray) {
        return this.reader.decode(nArray);
    }

    public void decode(int[] nArray, PrintWriter printWriter) {
        this.reader.decode(nArray, printWriter);
    }

    public IProblem parseInstance(InputStream inputStream) throws ParseFormatException, ContradictionException, IOException {
        throw new UnsupportedOperationException("Use a domain specific Reader (LecteurDimacs, AIGReader, etc.) for stream input ");
    }
}

