/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONReader<S extends ISolver>
extends Reader {
    protected final S solver;
    public static final String CLAUSE = "(\\[(-?(\\d+)(,-?(\\d+))*)?\\])";
    public static final String CARD = "(\\[(\\[(-?(\\d+)(,-?(\\d+))*)?\\]),'[=<>]=?',-?\\d+\\])";
    public final String constraint;
    public final String formula;
    private static final Pattern CLAUSE_PATTERN = Pattern.compile("(\\[(-?(\\d+)(,-?(\\d+))*)?\\])");
    private static final Pattern CARD_PATTERN = Pattern.compile("(\\[(\\[(-?(\\d+)(,-?(\\d+))*)?\\]),'[=<>]=?',-?\\d+\\])");
    private final Pattern constraintPattern;

    public JSONReader(S s) {
        this.solver = s;
        this.constraint = this.constraintRegexp();
        this.formula = "^\\[(" + this.constraint + "(," + this.constraint + ")*)?\\]$";
        this.constraintPattern = Pattern.compile(this.constraint);
    }

    protected String constraintRegexp() {
        return "((\\[(-?(\\d+)(,-?(\\d+))*)?\\])|(\\[(\\[(-?(\\d+)(,-?(\\d+))*)?\\]),'[=<>]=?',-?\\d+\\]))";
    }

    private void handleConstraint(String string) throws ParseFormatException, ContradictionException {
        if (CARD_PATTERN.matcher(string).matches()) {
            this.handleCard(string);
        } else if (CLAUSE_PATTERN.matcher(string).matches()) {
            this.handleClause(string);
        } else {
            this.handleNotHandled(string);
        }
    }

    protected void handleNotHandled(String string) throws ParseFormatException, ContradictionException {
        throw new ParseFormatException("Unknown constraint: " + string);
    }

    private void handleClause(String string) throws ParseFormatException, ContradictionException {
        this.solver.addClause(this.getLiterals(string));
    }

    protected IVecInt getLiterals(String string) throws ParseFormatException {
        String string2 = string.trim();
        string2 = string2.substring(1, string2.length() - 1);
        String[] stringArray = string2.split(",");
        VecInt vecInt = new VecInt();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            if (string3.length() > 0) {
                vecInt.push(Integer.valueOf(string3.trim()));
            }
            ++n2;
        }
        return vecInt;
    }

    protected void handleCard(String string) throws ParseFormatException, ContradictionException {
        String string2 = string.trim();
        Matcher matcher = CLAUSE_PATTERN.matcher(string2 = string2.substring(1, string2.length() - 1));
        if (matcher.find()) {
            IVecInt iVecInt = this.getLiterals(matcher.group());
            string2 = matcher.replaceFirst("");
            String[] stringArray = string2.split(",");
            int n = Integer.valueOf(stringArray[2]);
            String string3 = stringArray[1].substring(1, stringArray[1].length() - 1);
            if ("=".equals(string3) || "==".equals(string3)) {
                this.solver.addExactly(iVecInt, n);
            } else if ("<=".equals(string3)) {
                this.solver.addAtMost(iVecInt, n);
            } else if ("<".equals(string3)) {
                this.solver.addAtMost(iVecInt, n - 1);
            } else if (">=".equals(string3)) {
                this.solver.addAtLeast(iVecInt, n);
            } else if (">".equals(string3)) {
                this.solver.addAtLeast(iVecInt, n + 1);
            }
        }
    }

    @Override
    public IProblem parseInstance(InputStream inputStream) throws ParseFormatException, ContradictionException, IOException {
        String string;
        StringWriter stringWriter = new StringWriter();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            stringWriter.append(string);
        }
        return this.parseString(stringWriter.toString());
    }

    public ISolver parseString(String string) throws ParseFormatException, ContradictionException {
        String string2 = string.trim();
        if (!string2.matches(this.formula)) {
            throw new ParseFormatException("Wrong input " + string);
        }
        Matcher matcher = this.constraintPattern.matcher(string2);
        while (matcher.find()) {
            this.handleConstraint(matcher.group());
        }
        return this.solver;
    }

    @Override
    @Deprecated
    public String decode(int[] nArray) {
        return "[" + new VecInt(nArray) + "]";
    }

    @Override
    public void decode(int[] nArray, PrintWriter printWriter) {
        printWriter.print("[");
        printWriter.print(new VecInt(nArray));
        printWriter.print("]");
    }
}

