/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;

public abstract class Reader {
    private boolean verbose = false;

    public IProblem parseInstance(String string) throws ParseFormatException, IOException, ContradictionException {
        InputStream inputStream = null;
        try {
            IProblem iProblem;
            inputStream = string.startsWith("http://") ? new URL(string).openStream() : new FileInputStream(string);
            if (string.endsWith(".gz")) {
                inputStream = new GZIPInputStream(inputStream);
            } else if (string.endsWith(".bz2")) {
                inputStream = Runtime.getRuntime().exec("bunzip2 -c " + string).getInputStream();
            }
            IProblem iProblem2 = iProblem = this.parseInstance(inputStream);
            return iProblem2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (ParseFormatException parseFormatException) {
            throw parseFormatException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ContradictionException contradictionException) {
            throw contradictionException;
        }
        catch (IllegalStateException illegalStateException) {
            if (illegalStateException.getCause() instanceof ContradictionException) {
                throw (ContradictionException)illegalStateException.getCause();
            }
            throw illegalStateException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public abstract IProblem parseInstance(InputStream var1) throws ParseFormatException, ContradictionException, IOException;

    @Deprecated
    public IProblem parseInstance(java.io.Reader reader) throws ParseFormatException, ContradictionException, IOException {
        throw new UnsupportedOperationException("Use #parseInstance(InputStream) instead");
    }

    @Deprecated
    public abstract String decode(int[] var1);

    public abstract void decode(int[] var1, PrintWriter var2);

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbosity(boolean bl) {
        this.verbose = bl;
    }
}

