/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.sat4j.minisat.core.LearnedConstraintsEvaluationType;
import org.sat4j.sat.CommandComponent;
import org.sat4j.sat.DetailedCommandPanel;
import org.sat4j.sat.SolverController;

public class CleanCommandComponent
extends CommandComponent {
    private static final long serialVersionUID = 1L;
    private JSlider cleanSlider;
    private static final String EVALUATION_TYPE = "Clauses evaluation type";
    private static final String ACTIVITY_BASED = "Activity";
    private static final String LBD_BASED = "LBD";
    private static final String LBD2_BASED = "LBD 2";
    private JLabel evaluationLabel;
    private JRadioButton activityRadio;
    private JRadioButton lbdRadio;
    private JRadioButton lbd2Radio;
    private JButton cleanAndEvaluationApplyButton;
    private JButton cleanButton;
    private static final String CLEAN = "Clean now";
    private static final String MANUAL_CLEAN = "Manual clean: ";
    private JLabel manualCleanLabel;
    private JLabel speedLabel;
    private JLabel speedNameLabel;
    private static final String SPEED = "Speed :";
    private JLabel speedUnitLabel;
    private static final String SPEED_UNIT = " propagations per second";
    private final JLabel deleteClauseLabel = new JLabel("Automated clean: ");
    private static final String DELETE_CLAUSES = "Automated clean: ";
    private final JLabel clean5000Label = new JLabel("5000");
    private final JLabel clean10000Label = new JLabel("10000");
    private final JLabel clean20000Label = new JLabel("20000");
    private final JLabel clean50000Label = new JLabel("50000");
    private final JLabel clean100000Label = new JLabel("100000");
    private final JLabel clean500000Label = new JLabel("500000");
    private static final int[] CLEAN_VALUES = new int[]{5000, 10000, 20000, 50000, 100000, 500000};
    private static final int CLEAN_MIN = 0;
    private static final int CLEAN_MAX = 5;
    private static final int CLEAN_INIT = 1;
    private static final int CLEAN_SPACE = 1;
    private static final String CLEAN_5000 = "5000";
    private static final String CLEAN_10000 = "10000";
    private static final String CLEAN_20000 = "20000";
    private static final String CLEAN_50000 = "50000";
    private static final String CLEAN_100000 = "100000";
    private static final String CLEAN_500000 = "500000";
    private SolverController controller;
    private JCheckBox cleanUseOriginalStrategyCB;
    private static final String USE_ORIGINAL_STRATEGY = "Use solver's original deletion strategy";

    public CleanCommandComponent(String string, SolverController solverController) {
        this.setName(string);
        this.controller = solverController;
        this.createPanel();
    }

    public void createPanel() {
        this.setBorder(new CompoundBorder(new TitledBorder(null, this.getName(), 1, 2), DetailedCommandPanel.BORDER5));
        this.setLayout(new BorderLayout());
        this.cleanSlider = new JSlider(0, 0, 5, 1);
        this.cleanSlider.setMajorTickSpacing(1);
        this.cleanSlider.setPaintTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(0, this.clean5000Label);
        ((Dictionary)hashtable).put(1, this.clean10000Label);
        ((Dictionary)hashtable).put(2, this.clean20000Label);
        ((Dictionary)hashtable).put(3, this.clean50000Label);
        ((Dictionary)hashtable).put(4, this.clean100000Label);
        ((Dictionary)hashtable).put(5, this.clean500000Label);
        this.cleanSlider.setLabelTable(hashtable);
        this.cleanSlider.setPaintLabels(true);
        this.cleanSlider.setSnapToTicks(true);
        this.cleanSlider.setPreferredSize(new Dimension(400, 50));
        JPanel jPanel = new JPanel();
        jPanel.add(this.deleteClauseLabel);
        jPanel.add(this.cleanSlider);
        JPanel jPanel2 = new JPanel();
        this.evaluationLabel = new JLabel(EVALUATION_TYPE);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.activityRadio = new JRadioButton(ACTIVITY_BASED);
        this.lbdRadio = new JRadioButton(LBD_BASED);
        this.lbd2Radio = new JRadioButton(LBD2_BASED);
        buttonGroup.add(this.activityRadio);
        buttonGroup.add(this.lbdRadio);
        buttonGroup.add(this.lbd2Radio);
        jPanel2.add(this.evaluationLabel);
        jPanel2.add(this.activityRadio);
        jPanel2.add(this.lbdRadio);
        jPanel2.add(this.lbd2Radio);
        this.cleanAndEvaluationApplyButton = new JButton("Apply changes");
        this.cleanAndEvaluationApplyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CleanCommandComponent.this.hasChangedCleaningValue();
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.cleanAndEvaluationApplyButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new CompoundBorder(new TitledBorder(null, "", 1, 2), DetailedCommandPanel.BORDER5));
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel, "North");
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "South");
        JPanel jPanel5 = new JPanel();
        this.manualCleanLabel = new JLabel(MANUAL_CLEAN);
        this.cleanButton = new JButton(CLEAN);
        this.cleanButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CleanCommandComponent.this.hasClickedOnClean();
            }
        });
        jPanel5.add(this.manualCleanLabel);
        jPanel5.add(this.cleanButton);
        JPanel jPanel6 = new JPanel();
        this.cleanUseOriginalStrategyCB = new JCheckBox(USE_ORIGINAL_STRATEGY);
        this.cleanUseOriginalStrategyCB.setSelected(true);
        this.cleanUseOriginalStrategyCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CleanCommandComponent.this.hasClickedOnUseOriginalStrategy();
            }
        });
        jPanel6.add(this.cleanUseOriginalStrategyCB);
        JPanel jPanel7 = new JPanel();
        this.speedLabel = new JLabel("");
        this.speedNameLabel = new JLabel(SPEED);
        this.speedUnitLabel = new JLabel(SPEED_UNIT);
        jPanel7.add(this.speedNameLabel);
        jPanel7.add(this.speedLabel);
        jPanel7.add(this.speedUnitLabel);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add((Component)jPanel5, "South");
        jPanel8.add((Component)jPanel7, "Center");
        this.add((Component)jPanel6, "North");
        this.add((Component)jPanel8, "Center");
        this.add((Component)jPanel4, "South");
    }

    public void hasChangedCleaningValue() {
        int n = CLEAN_VALUES[this.cleanSlider.getValue()];
        this.controller.setNbClausesAtWhichWeShouldClean(n);
        if (this.activityRadio.isSelected()) {
            this.controller.setLearnedDeletionStrategyTypeToSolver(LearnedConstraintsEvaluationType.ACTIVITY);
        } else if (this.lbdRadio.isSelected()) {
            this.controller.setLearnedDeletionStrategyTypeToSolver(LearnedConstraintsEvaluationType.LBD);
        } else if (this.lbd2Radio.isSelected()) {
            this.controller.setLearnedDeletionStrategyTypeToSolver(LearnedConstraintsEvaluationType.LBD2);
        }
    }

    public void hasClickedOnUseOriginalStrategy() {
        int n = CLEAN_VALUES[this.cleanSlider.getValue()];
        this.controller.setNbClausesAtWhichWeShouldClean(n);
        this.controller.setUseTelecomStrategyAsLearnedConstraintsDeletionStrategy();
        this.controller.setLearnedDeletionStrategyTypeToSolver(LearnedConstraintsEvaluationType.ACTIVITY);
        this.activityRadio.setSelected(true);
        this.setCleanPanelOriginalStrategyEnabled(false);
    }

    public int getCleanSliderValue() {
        return CLEAN_VALUES[this.cleanSlider.getValue()];
    }

    public void hasClickedOnClean() {
        this.controller.shouldCleanNow();
    }

    public void setCleanPanelEnabled(boolean bl) {
        this.manualCleanLabel.setEnabled(bl);
        this.deleteClauseLabel.setEnabled(bl);
        this.cleanSlider.setEnabled(bl);
        this.cleanButton.setEnabled(bl);
        this.evaluationLabel.setEnabled(bl);
        this.activityRadio.setEnabled(bl);
        this.lbdRadio.setEnabled(bl);
        this.lbd2Radio.setEnabled(bl);
        this.cleanAndEvaluationApplyButton.setEnabled(bl);
        this.cleanUseOriginalStrategyCB.setEnabled(bl);
        this.speedLabel.setEnabled(bl);
        this.speedUnitLabel.setEnabled(bl);
        this.speedNameLabel.setEnabled(bl);
        this.repaint();
    }

    public void setCleanPanelOriginalStrategyEnabled(boolean bl) {
        this.cleanUseOriginalStrategyCB.setEnabled(bl);
        this.manualCleanLabel.setEnabled(!bl);
        this.deleteClauseLabel.setEnabled(!bl);
        this.activityRadio.setEnabled(!bl);
        this.evaluationLabel.setEnabled(!bl);
        this.lbdRadio.setEnabled(!bl);
        this.lbd2Radio.setEnabled(!bl);
        this.cleanAndEvaluationApplyButton.setEnabled(!bl);
        this.cleanSlider.setEnabled(!bl);
        this.cleanButton.setEnabled(!bl);
        this.repaint();
    }

    public void setSpeedLabeltext(String string) {
        this.speedLabel.setText(string);
        this.speedLabel.invalidate();
    }
}

