/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.ILauncherMode;
import org.sat4j.maxsat.WeightedMaxSatDecorator;
import org.sat4j.maxsat.reader.MSInstanceReader;
import org.sat4j.pb.ConstraintRelaxingPseudoOptDecorator;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.core.IPBCDCLSolver;
import org.sat4j.pb.reader.PBInstanceReader;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.sat.ProblemType;
import org.sat4j.sat.RemoteControlFrame;
import org.sat4j.sat.Solvers;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ConflictDepthTracing;
import org.sat4j.tools.ConflictLevelTracing;
import org.sat4j.tools.DecisionTracing;
import org.sat4j.tools.FileBasedVisualizationTool;
import org.sat4j.tools.LearnedClausesSizeTracing;
import org.sat4j.tools.MultiTracing;

public class Launcher
extends AbstractLauncher
implements ILogAble {
    private static final long serialVersionUID = 1L;
    private boolean isModeOptimization = false;
    private boolean modeTracing = false;
    private boolean launchRemoteControl;
    private static AbstractLauncher launcher;
    private String filename;
    private ProblemType typeProbleme = ProblemType.CNF_SAT;

    public static void main(String[] stringArray) {
        launcher = new Launcher();
        launcher.run(stringArray);
    }

    public void usage() {
        Solvers.usage(this);
    }

    protected Reader createReader(ISolver iSolver, String string) {
        InstanceReader instanceReader = new InstanceReader(iSolver);
        switch (this.typeProbleme) {
            case CNF_MAXSAT: 
            case WCNF_MAXSAT: {
                instanceReader = new MSInstanceReader((WeightedMaxSatDecorator)iSolver);
                break;
            }
            case PB_SAT: 
            case PB_OPT: {
                instanceReader = new PBInstanceReader((IPBSolver)iSolver);
                break;
            }
            case CNF_SAT: {
                instanceReader = new InstanceReader(iSolver);
            }
        }
        return instanceReader;
    }

    protected String getInstanceName(String[] stringArray) {
        return this.filename;
    }

    protected ISolver configureSolver(String[] stringArray) {
        Options options = Solvers.createCLIOptions();
        try {
            Object object;
            CommandLine commandLine = new PosixParser().parse(options, stringArray);
            this.isModeOptimization = commandLine.hasOption("opt");
            this.filename = commandLine.getOptionValue("f");
            boolean bl = commandLine.hasOption("e");
            int n = 0;
            String[] stringArray2 = commandLine.getArgs();
            if (this.filename == null && stringArray2.length > 0) {
                this.filename = stringArray2[n++];
            }
            if (this.filename != null) {
                object = Solvers.uncompressed(this.filename);
                if (((String)object).endsWith(".cnf") && this.isModeOptimization) {
                    this.typeProbleme = ProblemType.CNF_MAXSAT;
                } else if (((String)object).endsWith(".wcnf")) {
                    this.typeProbleme = ProblemType.WCNF_MAXSAT;
                    this.isModeOptimization = true;
                } else {
                    this.typeProbleme = ((String)object).endsWith(".opb") ? (this.isModeOptimization ? ProblemType.PB_OPT : ProblemType.PB_SAT) : ProblemType.CNF_SAT;
                }
            } else {
                this.typeProbleme = ProblemType.CNF_SAT;
            }
            object = Solvers.configureSolver(stringArray, this);
            this.launchRemoteControl = commandLine.hasOption("remote");
            if (commandLine.hasOption("m")) {
                this.setSilent(true);
            }
            if (commandLine.hasOption("k")) {
                Integer.valueOf(commandLine.getOptionValue("k"));
            }
            if (commandLine.hasOption("r")) {
                this.modeTracing = true;
                if (!commandLine.hasOption("remote")) {
                    object.setSearchListener(new MultiTracing(new ConflictLevelTracing(new FileBasedVisualizationTool(String.valueOf(this.filename) + "-conflict-level"), new FileBasedVisualizationTool(String.valueOf(this.filename) + "-conflict-level-restart"), new FileBasedVisualizationTool(String.valueOf(this.filename) + "-conflict-level-clean")), new DecisionTracing(new FileBasedVisualizationTool(String.valueOf(this.filename) + "-decision-indexes-pos"), new FileBasedVisualizationTool(String.valueOf(this.filename) + "-decision-indexes-neg"), new FileBasedVisualizationTool(String.valueOf(this.filename) + "-decision-indexes-restart"), new FileBasedVisualizationTool(String.valueOf(this.filename) + "-decision-indexes-clean")), new LearnedClausesSizeTracing(new FileBasedVisualizationTool(String.valueOf(this.filename) + "-learned-clauses-size"), new FileBasedVisualizationTool(String.valueOf(this.filename) + "-learned-clauses-size-restart"), new FileBasedVisualizationTool(String.valueOf(this.filename) + "-learned-clauses-size-clean")), new ConflictDepthTracing(new FileBasedVisualizationTool(String.valueOf(this.filename) + "-conflict-depth"), new FileBasedVisualizationTool(String.valueOf(this.filename) + "-conflict-depth-restart"), new FileBasedVisualizationTool(String.valueOf(this.filename) + "-conflict-depth-clean"))));
                }
            }
            switch (this.typeProbleme) {
                case PB_OPT: {
                    this.setLauncherMode(ILauncherMode.OPTIMIZATION);
                    if (commandLine.hasOption("lo")) {
                        this.problem = new ConstraintRelaxingPseudoOptDecorator((IPBSolver)object);
                        break;
                    }
                    this.problem = new PseudoOptDecorator((IPBSolver)object);
                    break;
                }
                case CNF_MAXSAT: 
                case WCNF_MAXSAT: {
                    this.setLauncherMode(ILauncherMode.OPTIMIZATION);
                    object = new WeightedMaxSatDecorator((IPBCDCLSolver)object, bl);
                    if (commandLine.hasOption("lo")) {
                        this.problem = new ConstraintRelaxingPseudoOptDecorator((WeightedMaxSatDecorator)object);
                        break;
                    }
                    this.problem = new PseudoOptDecorator((WeightedMaxSatDecorator)object, false, false);
                    break;
                }
                default: {
                    this.setLauncherMode(ILauncherMode.DECISION);
                }
            }
            this.setIncomplete(commandLine.hasOption("i"));
            this.setDisplaySolutionLine(!commandLine.hasOption("n"));
            while (n < stringArray2.length) {
                String[] stringArray3 = stringArray2[n].split("=");
                assert (stringArray3.length == 2);
                this.log("setting " + stringArray3[0] + " to " + stringArray3[1]);
                try {
                    BeanUtils.setProperty(object, stringArray3[0], stringArray3[1]);
                }
                catch (Exception exception) {
                    this.log("Cannot set parameter : " + stringArray[n]);
                }
                ++n;
            }
            if (object != null) {
                this.getLogWriter().println(object.toString("c "));
            }
            return object;
        }
        catch (ParseException parseException) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j.jar", options, true);
            this.usage();
            System.exit(0);
            return null;
        }
    }

    public void run(String[] stringArray) {
        block13: {
            try {
                String string;
                this.displayHeader();
                this.solver = this.configureSolver(stringArray);
                if (this.solver == null) {
                    this.usage();
                    System.exit(0);
                }
                if (!this.silent) {
                    this.solver.setVerbose(true);
                }
                if ((string = this.getInstanceName(stringArray)) == null) {
                    this.usage();
                    System.exit(0);
                }
                this.beginTime = System.currentTimeMillis();
                if (!this.launchRemoteControl) {
                    this.readProblem(string);
                    try {
                        if (this.problem != null) {
                            this.solve(this.problem);
                        } else {
                            this.solve(this.solver);
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        this.log("timeout");
                    }
                    System.exit(launcher.getExitCode().value());
                    break block13;
                }
                RemoteControlFrame remoteControlFrame = new RemoteControlFrame(this.filename, "", stringArray);
                remoteControlFrame.activateTracing(this.modeTracing);
                remoteControlFrame.setOptimisationMode(this.isModeOptimization);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("FATAL " + fileNotFoundException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                System.err.println("FATAL " + iOException.getLocalizedMessage());
            }
            catch (ContradictionException contradictionException) {
                this.exitCode = ExitCode.UNSATISFIABLE;
                this.log("(trivial inconsistency)");
            }
            catch (ParseFormatException parseFormatException) {
                System.err.println("FATAL " + parseFormatException.getLocalizedMessage());
            }
        }
    }
}

