/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.sat.CommandComponent;
import org.sat4j.sat.DetailedCommandPanel;
import org.sat4j.sat.RTSI;
import org.sat4j.sat.SolverController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseCommandComponent
extends CommandComponent {
    private static final long serialVersionUID = 1L;
    private String currentPhaseSelectionStrategy;
    private JComboBox phaseList;
    private JLabel phaseListLabel;
    private static final String PHASE_STRATEGY = "Choose phase strategy :";
    private JButton phaseApplyButton;
    private static final String PHASE_APPLY = "Apply";
    private static final String PHASE_STRATEGY_CLASS = "org.sat4j.minisat.core.IPhaseSelectionStrategy";
    private static final String PHASE_PATH_SAT = "org.sat4j.minisat.orders";
    private SolverController solverController;

    public PhaseCommandComponent(String string, SolverController solverController, String string2) {
        this.currentPhaseSelectionStrategy = string2;
        this.solverController = solverController;
        this.setName(string);
        this.createPanel();
    }

    @Override
    public void createPanel() {
        this.createPhasePanel();
    }

    public void createPhasePanel() {
        this.setBorder(new CompoundBorder(new TitledBorder(null, this.getName(), 1, 2), DetailedCommandPanel.BORDER5));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.phaseListLabel = new JLabel(PHASE_STRATEGY);
        this.phaseList = new JComboBox<Object>(this.getListOfPhaseStrategies().toArray());
        this.phaseList.setSelectedItem(this.currentPhaseSelectionStrategy);
        jPanel.add(this.phaseListLabel);
        jPanel.add(this.phaseList);
        this.phaseApplyButton = new JButton(PHASE_APPLY);
        this.phaseApplyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhaseCommandComponent.this.hasClickedOnApplyPhase();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.phaseApplyButton);
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
    }

    public void hasClickedOnApplyPhase() {
        String string;
        this.currentPhaseSelectionStrategy = string = (String)this.phaseList.getSelectedItem();
        IPhaseSelectionStrategy iPhaseSelectionStrategy = null;
        try {
            iPhaseSelectionStrategy = (IPhaseSelectionStrategy)Class.forName("org.sat4j.minisat.orders." + string).newInstance();
            iPhaseSelectionStrategy.init(this.solverController.getNVar() + 1);
            this.solverController.setPhaseSelectionStrategy(iPhaseSelectionStrategy);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
    }

    public void setPhasePanelEnabled(boolean bl) {
        this.phaseList.setEnabled(bl);
        this.phaseListLabel.setEnabled(bl);
        this.phaseApplyButton.setEnabled(bl);
        this.repaint();
    }

    public List<String> getListOfPhaseStrategies() {
        List<String> list = RTSI.find(PHASE_STRATEGY_CLASS);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string.contains("Remote")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void setPhaseListSelectedItem(String string) {
        this.currentPhaseSelectionStrategy = string;
        this.phaseList.setSelectedItem(this.currentPhaseSelectionStrategy);
        this.repaint();
    }
}

