/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat.visu;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyHighestValues;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.traces.painters.TracePainterVerticalBar;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.sat4j.sat.visu.MyChartPanel;
import org.sat4j.sat.visu.SolverVisualisation;
import org.sat4j.sat.visu.TracePainterPlus;
import org.sat4j.sat.visu.VisuPreferences;

public class JChartBasedSolverVisualisation
implements SolverVisualisation {
    private static final String CLEAN = "Clean";
    private static final String RESTART = "Restart";
    private static final long serialVersionUID = 1L;
    private JFrame visuFrame;
    private int nVar;
    private Chart2D variablesEvaluationChart;
    private Chart2D clausesEvaluationChart;
    private Chart2D learnedClausesSizeChart;
    private Chart2D decisionLevelWhenConflictChart;
    private Chart2D trailLevelWhenConflictChart;
    private Chart2D positiveDecisionVariableChart;
    private Chart2D negativeDecisionVariableChart;
    private Chart2D propagationPerSecondChart;
    private ITrace2D positiveDecisionTrace;
    private ITrace2D negativeDecisionTrace;
    private ITrace2D restartPosDecisionTrace;
    private ITrace2D restartNegDecisionTrace;
    private ITrace2D cleanPosDecisionTrace;
    private ITrace2D cleanNegDecisionTrace;
    private ITrace2D learnedClausesSizeTrace;
    private ITrace2D learnedClausesSizeRestartTrace;
    private ITrace2D learnedClausesSizeCleanTrace;
    private ITrace2D conflictDepthTrace;
    private ITrace2D conflictDepthRestartTrace;
    private ITrace2D conflictDepthCleanTrace;
    private ITrace2D clausesEvaluationTrace;
    private ITrace2D conflictLevelTrace;
    private ITrace2D conflictLevelRestartTrace;
    private ITrace2D conflictLevelCleanTrace;
    private ITrace2D heuristicsTrace;
    private ITrace2D speedTrace;
    private ITrace2D speedCleanTrace;
    private ITrace2D speedRestartTrace;
    private VisuPreferences pref;

    public JChartBasedSolverVisualisation(VisuPreferences visuPreferences) {
        this.pref = visuPreferences;
        this.init();
    }

    public void init() {
        this.visuFrame = new JFrame("Visualisation");
        Container container = this.visuFrame.getContentPane();
        int n = this.pref.getNumberOfDisplayedGraphs();
        int[] nArray = new int[]{1, 2, 3, 2};
        int n2 = 3;
        if (n < 5) {
            n2 = nArray[n - 1];
        }
        int n3 = (n - 1) / 3 + 1;
        container.setLayout(new GridLayout(n2, n3, 5, 5));
        this.initCharts();
        this.addChartsToFrame();
        this.initTraces();
        this.visuFrame.setBackground(this.pref.getBackgroundColor());
        this.visuFrame.setForeground(this.pref.getBorderColor());
        this.visuFrame.setSize(800, 400);
        this.visuFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JChartBasedSolverVisualisation.this.visuFrame.setVisible(false);
            }
        });
    }

    public void initCharts() {
        this.variablesEvaluationChart = new Chart2D();
        this.clausesEvaluationChart = new Chart2D();
        this.learnedClausesSizeChart = new Chart2D();
        this.decisionLevelWhenConflictChart = new Chart2D();
        this.trailLevelWhenConflictChart = new Chart2D();
        this.positiveDecisionVariableChart = new Chart2D();
        this.negativeDecisionVariableChart = new Chart2D();
        this.propagationPerSecondChart = new Chart2D();
        IAxis.AxisTitle axisTitle = new IAxis.AxisTitle("");
        this.variablesEvaluationChart.getAxisX().setAxisTitle(axisTitle);
        this.variablesEvaluationChart.getAxisY().setAxisTitle(axisTitle);
        this.clausesEvaluationChart.getAxisX().setAxisTitle(axisTitle);
        this.clausesEvaluationChart.getAxisY().setAxisTitle(axisTitle);
        this.learnedClausesSizeChart.getAxisX().setAxisTitle(axisTitle);
        this.learnedClausesSizeChart.getAxisY().setAxisTitle(axisTitle);
        this.decisionLevelWhenConflictChart.getAxisX().setAxisTitle(axisTitle);
        this.decisionLevelWhenConflictChart.getAxisY().setAxisTitle(axisTitle);
        this.trailLevelWhenConflictChart.getAxisX().setAxisTitle(axisTitle);
        this.trailLevelWhenConflictChart.getAxisY().setAxisTitle(axisTitle);
        this.positiveDecisionVariableChart.getAxisX().setAxisTitle(axisTitle);
        this.positiveDecisionVariableChart.getAxisY().setAxisTitle(axisTitle);
        this.negativeDecisionVariableChart.getAxisX().setAxisTitle(axisTitle);
        this.negativeDecisionVariableChart.getAxisY().setAxisTitle(axisTitle);
        this.propagationPerSecondChart.getAxisX().setAxisTitle(axisTitle);
        this.propagationPerSecondChart.getAxisY().setAxisTitle(axisTitle);
    }

    public void addChartsToFrame() {
        MyChartPanel myChartPanel = new MyChartPanel(this.variablesEvaluationChart, "Variables evaluation", this.pref.getBackgroundColor(), this.pref.getBorderColor());
        MyChartPanel myChartPanel2 = new MyChartPanel(this.clausesEvaluationChart, "Clauses evaluation", this.pref.getBackgroundColor(), this.pref.getBorderColor());
        MyChartPanel myChartPanel3 = new MyChartPanel(this.learnedClausesSizeChart, "Size of learned clauses", this.pref.getBackgroundColor(), this.pref.getBorderColor());
        MyChartPanel myChartPanel4 = new MyChartPanel(this.decisionLevelWhenConflictChart, "Decision level when conflict", this.pref.getBackgroundColor(), this.pref.getBorderColor());
        MyChartPanel myChartPanel5 = new MyChartPanel(this.trailLevelWhenConflictChart, "Trail level when conflict", this.pref.getBackgroundColor(), this.pref.getBorderColor());
        MyChartPanel myChartPanel6 = new MyChartPanel(this.positiveDecisionVariableChart, "Positive decision phases", this.pref.getBackgroundColor(), this.pref.getBorderColor());
        MyChartPanel myChartPanel7 = new MyChartPanel(this.negativeDecisionVariableChart, "Negative decision phases", this.pref.getBackgroundColor(), this.pref.getBorderColor());
        MyChartPanel myChartPanel8 = new MyChartPanel(this.propagationPerSecondChart, "Number of propagations per second", this.pref.getBackgroundColor(), this.pref.getBorderColor());
        if (this.pref.isDisplayClausesSize()) {
            this.visuFrame.add(myChartPanel3);
        }
        if (this.pref.isDisplayClausesEvaluation()) {
            this.visuFrame.add(myChartPanel2);
        }
        if (this.pref.isDisplayConflictsTrail()) {
            this.visuFrame.add(myChartPanel5);
        }
        if (this.pref.isDisplayDecisionIndexes()) {
            this.visuFrame.add(myChartPanel7);
        }
        if (this.pref.isDisplayVariablesEvaluation()) {
            this.visuFrame.add(myChartPanel);
        }
        if (this.pref.isDisplayConflictsDecision()) {
            this.visuFrame.add(myChartPanel4);
        }
        if (this.pref.isDisplayDecisionIndexes()) {
            this.visuFrame.add(myChartPanel6);
        }
        if (this.pref.isDisplaySpeed()) {
            this.visuFrame.add(myChartPanel8);
        }
    }

    public void initTraces() {
        this.positiveDecisionTrace = new Trace2DSimple("Positive decision");
        this.positiveDecisionTrace.setTracePainter((ITracePainter)new TracePainterPlus());
        this.positiveDecisionTrace.setColor(new Color(0.0f, 0.78f, 0.09f));
        this.negativeDecisionTrace = new Trace2DSimple("Negative decision");
        this.negativeDecisionTrace.setTracePainter((ITracePainter)new TracePainterPlus());
        this.negativeDecisionTrace.setColor(Color.RED);
        this.restartPosDecisionTrace = new Trace2DSimple(RESTART);
        this.restartPosDecisionTrace.setTracePainter((ITracePainter)new TracePainterVerticalBar(2, this.positiveDecisionVariableChart));
        this.restartPosDecisionTrace.setColor(Color.LIGHT_GRAY);
        this.restartNegDecisionTrace = new Trace2DSimple(RESTART);
        this.restartNegDecisionTrace.setTracePainter((ITracePainter)new TracePainterVerticalBar(2, this.negativeDecisionVariableChart));
        this.restartNegDecisionTrace.setColor(Color.LIGHT_GRAY);
        this.cleanPosDecisionTrace = new Trace2DSimple(CLEAN);
        this.cleanPosDecisionTrace.setTracePainter((ITracePainter)new TracePainterVerticalBar(2, this.positiveDecisionVariableChart));
        this.cleanPosDecisionTrace.setColor(Color.ORANGE);
        this.cleanNegDecisionTrace = new Trace2DSimple(CLEAN);
        this.cleanNegDecisionTrace.setTracePainter((ITracePainter)new TracePainterVerticalBar(2, this.negativeDecisionVariableChart));
        this.cleanNegDecisionTrace.setColor(Color.ORANGE);
        this.positiveDecisionVariableChart.addTrace(this.positiveDecisionTrace);
        this.positiveDecisionVariableChart.addTrace(this.restartPosDecisionTrace);
        this.positiveDecisionVariableChart.addTrace(this.cleanPosDecisionTrace);
        this.positiveDecisionTrace.setZIndex(Integer.valueOf(100));
        this.positiveDecisionVariableChart.getAxisX().setRangePolicy((IRangePolicy)new RangePolicyHighestValues(8000));
        this.negativeDecisionVariableChart.addTrace(this.restartNegDecisionTrace);
        this.negativeDecisionVariableChart.addTrace(this.cleanNegDecisionTrace);
        this.negativeDecisionVariableChart.addTrace(this.negativeDecisionTrace);
        this.negativeDecisionTrace.setZIndex(Integer.valueOf(100));
        this.negativeDecisionVariableChart.getAxisX().setRangePolicy(this.positiveDecisionVariableChart.getAxisX().getRangePolicy());
        this.conflictDepthTrace = new Trace2DLtd(15000, "Trail level");
        this.conflictDepthTrace.setTracePainter((ITracePainter)new TracePainterPlus());
        this.conflictDepthTrace.setColor(Color.MAGENTA);
        this.trailLevelWhenConflictChart.setName("Trail level when the conflict occurs");
        this.trailLevelWhenConflictChart.addTrace(this.conflictDepthTrace);
        this.conflictDepthTrace.setZIndex(Integer.valueOf(100));
        this.conflictDepthRestartTrace = new Trace2DSimple(RESTART);
        this.conflictDepthRestartTrace.setTracePainter((ITracePainter)new TracePainterVerticalBar(2, this.trailLevelWhenConflictChart));
        this.conflictDepthRestartTrace.setColor(Color.LIGHT_GRAY);
        this.trailLevelWhenConflictChart.addTrace(this.conflictDepthRestartTrace);
        this.conflictDepthCleanTrace = new Trace2DSimple(CLEAN);
        this.conflictDepthCleanTrace.setTracePainter((ITracePainter)new TracePainterVerticalBar(2, this.trailLevelWhenConflictChart));
        this.conflictDepthCleanTrace.setColor(Color.ORANGE);
        this.trailLevelWhenConflictChart.addTrace(this.conflictDepthCleanTrace);
        this.trailLevelWhenConflictChart.getAxisX().setRangePolicy((IRangePolicy)new RangePolicyHighestValues(2000));
        this.conflictLevelTrace = new Trace2DSimple("Decision level");
        this.conflictLevelTrace.setTracePainter((ITracePainter)new TracePainterPlus());
        this.conflictLevelTrace.setColor(Color.MAGENTA);
        this.decisionLevelWhenConflictChart.setName("Decision level chen the conflict occurs");
        this.decisionLevelWhenConflictChart.addTrace(this.conflictLevelTrace);
        this.conflictLevelTrace.setZIndex(Integer.valueOf(100));
        this.conflictLevelRestartTrace = new Trace2DSimple(RESTART);
        this.conflictLevelRestartTrace.setTracePainter((ITracePainter)new TracePainterVerticalBar(2, this.decisionLevelWhenConflictChart));
        this.conflictLevelRestartTrace.setColor(Color.LIGHT_GRAY);
        this.decisionLevelWhenConflictChart.addTrace(this.conflictLevelRestartTrace);
        this.conflictLevelCleanTrace = new Trace2DSimple(CLEAN);
        this.conflictLevelCleanTrace.setTracePainter((ITracePainter)new TracePainterVerticalBar(2, this.decisionLevelWhenConflictChart));
        this.conflictLevelCleanTrace.setColor(Color.ORANGE);
        this.decisionLevelWhenConflictChart.addTrace(this.conflictLevelCleanTrace);
        this.decisionLevelWhenConflictChart.getAxisX().setRangePolicy((IRangePolicy)new RangePolicyHighestValues(2000));
        this.learnedClausesSizeTrace = new Trace2DSimple("Size");
        this.learnedClausesSizeTrace.setTracePainter((ITracePainter)new TracePainterPlus());
        this.learnedClausesSizeTrace.setColor(Color.BLUE);
        this.learnedClausesSizeChart.setName("Learned clauses size");
        this.learnedClausesSizeChart.addTrace(this.learnedClausesSizeTrace);
        this.learnedClausesSizeTrace.setZIndex(Integer.valueOf(100));
        this.learnedClausesSizeChart.getAxisX().setRangePolicy((IRangePolicy)new RangePolicyHighestValues(2000));
        this.learnedClausesSizeRestartTrace = new Trace2DSimple(RESTART);
        this.learnedClausesSizeRestartTrace.setTracePainter((ITracePainter)new TracePainterVerticalBar(2, this.learnedClausesSizeChart));
        this.learnedClausesSizeRestartTrace.setColor(Color.LIGHT_GRAY);
        this.learnedClausesSizeChart.addTrace(this.learnedClausesSizeRestartTrace);
        this.learnedClausesSizeCleanTrace = new Trace2DSimple(CLEAN);
        this.learnedClausesSizeCleanTrace.setTracePainter((ITracePainter)new TracePainterVerticalBar(2, this.learnedClausesSizeChart));
        this.learnedClausesSizeCleanTrace.setColor(Color.ORANGE);
        this.learnedClausesSizeChart.addTrace(this.learnedClausesSizeCleanTrace);
        this.clausesEvaluationTrace = new Trace2DSimple("Evaluation");
        this.clausesEvaluationTrace.setTracePainter((ITracePainter)new TracePainterPlus());
        this.clausesEvaluationTrace.setColor(Color.BLUE);
        this.clausesEvaluationTrace.setName("Clauses evaluation");
        this.clausesEvaluationChart.addTrace(this.clausesEvaluationTrace);
        this.heuristicsTrace = new Trace2DSimple("Evaluation");
        this.heuristicsTrace.setTracePainter((ITracePainter)new TracePainterPlus());
        this.heuristicsTrace.setColor(Color.ORANGE);
        this.variablesEvaluationChart.setName("Variables evaluation");
        this.variablesEvaluationChart.addTrace(this.heuristicsTrace);
        this.speedTrace = new Trace2DSimple("Speed");
        this.speedTrace.setColor(new Color(0.02f, 0.78f, 0.76f));
        this.speedCleanTrace = new Trace2DSimple(CLEAN);
        this.speedCleanTrace.setColor(Color.ORANGE);
        this.speedCleanTrace.setTracePainter((ITracePainter)new TracePainterVerticalBar(2, this.propagationPerSecondChart));
        this.speedRestartTrace = new Trace2DSimple(RESTART);
        this.speedRestartTrace.setColor(Color.LIGHT_GRAY);
        this.speedRestartTrace.setTracePainter((ITracePainter)new TracePainterVerticalBar(2, this.propagationPerSecondChart));
        this.propagationPerSecondChart.addTrace(this.speedCleanTrace);
        this.propagationPerSecondChart.addTrace(this.speedRestartTrace);
        this.propagationPerSecondChart.addTrace(this.speedTrace);
        this.propagationPerSecondChart.getAxisX().setRangePolicy((IRangePolicy)new RangePolicyHighestValues(30));
        this.speedTrace.setZIndex(Integer.valueOf(100));
    }

    public void setVisible(boolean bl) {
        this.visuFrame.setVisible(bl);
    }

    public ITrace2D getPositiveDecisionTrace() {
        return this.positiveDecisionTrace;
    }

    public void setPositiveDecisionTrace(ITrace2D iTrace2D) {
        this.positiveDecisionTrace = iTrace2D;
    }

    public ITrace2D getNegativeDecisionTrace() {
        return this.negativeDecisionTrace;
    }

    public void setNegativeDecisionTrace(ITrace2D iTrace2D) {
        this.negativeDecisionTrace = iTrace2D;
    }

    public ITrace2D getRestartNegDecisionTrace() {
        return this.restartNegDecisionTrace;
    }

    public void setRestartNegDecisionTrace(ITrace2D iTrace2D) {
        this.restartNegDecisionTrace = iTrace2D;
    }

    public ITrace2D getRestartPosDecisionTrace() {
        return this.restartPosDecisionTrace;
    }

    public void setRestartPosDecisionTrace(ITrace2D iTrace2D) {
        this.restartPosDecisionTrace = iTrace2D;
    }

    public ITrace2D getConflictDepthTrace() {
        return this.conflictDepthTrace;
    }

    public void setConflictDepthTrace(ITrace2D iTrace2D) {
        this.conflictDepthTrace = iTrace2D;
    }

    public ITrace2D getLearnedClausesSizeTrace() {
        return this.learnedClausesSizeTrace;
    }

    public void setLearnedClausesSizeTrace(ITrace2D iTrace2D) {
        this.learnedClausesSizeTrace = iTrace2D;
    }

    public ITrace2D getClausesEvaluationTrace() {
        return this.clausesEvaluationTrace;
    }

    public void setClausesEvaluationTrace(ITrace2D iTrace2D) {
        this.clausesEvaluationTrace = iTrace2D;
    }

    public ITrace2D getConflictLevelTrace() {
        return this.conflictLevelTrace;
    }

    public void setConflictLevelTrace(ITrace2D iTrace2D) {
        this.conflictLevelTrace = iTrace2D;
    }

    public ITrace2D getConflictLevelRestartTrace() {
        return this.conflictLevelRestartTrace;
    }

    public void setConflictLevelRestartTrace(ITrace2D iTrace2D) {
        this.conflictLevelRestartTrace = iTrace2D;
    }

    public ITrace2D getHeuristicsTrace() {
        return this.heuristicsTrace;
    }

    public void setHeuristicsTrace(ITrace2D iTrace2D) {
        this.heuristicsTrace = iTrace2D;
    }

    public ITrace2D getSpeedTrace() {
        return this.speedTrace;
    }

    public void setSpeedTrace(ITrace2D iTrace2D) {
        this.speedTrace = iTrace2D;
    }

    public ITrace2D getSpeedCleanTrace() {
        return this.speedCleanTrace;
    }

    public void setSpeedCleanTrace(ITrace2D iTrace2D) {
        this.speedCleanTrace = iTrace2D;
    }

    public ITrace2D getSpeedRestartTrace() {
        return this.speedRestartTrace;
    }

    public void setSpeedRestartTrace(ITrace2D iTrace2D) {
        this.speedRestartTrace = iTrace2D;
    }

    public ITrace2D getConflictDepthRestartTrace() {
        return this.conflictDepthRestartTrace;
    }

    public void setConflictDepthRestartTrace(ITrace2D iTrace2D) {
        this.conflictDepthRestartTrace = iTrace2D;
    }

    public ITrace2D getLearnedClausesSizeRestartTrace() {
        return this.learnedClausesSizeRestartTrace;
    }

    public void setLearnedClausesSizeRestartTrace(ITrace2D iTrace2D) {
        this.learnedClausesSizeRestartTrace = iTrace2D;
    }

    public ITrace2D getLearnedClausesSizeCleanTrace() {
        return this.learnedClausesSizeCleanTrace;
    }

    public void setLearnedClausesSizeCleanTrace(ITrace2D iTrace2D) {
        this.learnedClausesSizeCleanTrace = iTrace2D;
    }

    public ITrace2D getConflictLevelCleanTrace() {
        return this.conflictLevelCleanTrace;
    }

    public void setConflictLevelCleanTrace(ITrace2D iTrace2D) {
        this.conflictLevelCleanTrace = iTrace2D;
    }

    public ITrace2D getConflictDepthCleanTrace() {
        return this.conflictDepthCleanTrace;
    }

    public void setConflictDepthCleanTrace(ITrace2D iTrace2D) {
        this.conflictDepthCleanTrace = iTrace2D;
    }

    public ITrace2D getCleanPosDecisionTrace() {
        return this.cleanPosDecisionTrace;
    }

    public void setCleanPosDecisionTrace(ITrace2D iTrace2D) {
        this.cleanPosDecisionTrace = iTrace2D;
    }

    public ITrace2D getCleanNegDecisionTrace() {
        return this.cleanNegDecisionTrace;
    }

    public void setCleanNegDecisionTrace(ITrace2D iTrace2D) {
        this.cleanNegDecisionTrace = iTrace2D;
    }

    public int getnVar() {
        return this.nVar;
    }

    public void setnVar(int n) {
        this.nVar = n;
    }

    public void start() {
        this.visuFrame.setVisible(true);
    }

    public void end() {
        this.visuFrame.setVisible(false);
    }
}

