/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.SortedSet;
import java.util.TreeSet;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.tools.SolutionFoundListener;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMinimalModel
extends SolverDecorator<ISolver> {
    private static final long serialVersionUID = 1L;
    protected final SortedSet<Integer> pLiterals = new TreeSet<Integer>();
    protected final SolutionFoundListener modelListener;

    public static IVecInt positiveLiterals(ISolver iSolver) {
        VecInt vecInt = new VecInt(iSolver.nVars());
        int n = 1;
        while (n <= iSolver.nVars()) {
            vecInt.push(n);
            ++n;
        }
        return vecInt;
    }

    public static IVecInt negativeLiterals(ISolver iSolver) {
        VecInt vecInt = new VecInt(iSolver.nVars());
        int n = 1;
        while (n <= iSolver.nVars()) {
            vecInt.push(-n);
            ++n;
        }
        return vecInt;
    }

    public AbstractMinimalModel(ISolver iSolver) {
        this(iSolver, SolutionFoundListener.VOID);
    }

    public AbstractMinimalModel(ISolver iSolver, IVecInt iVecInt) {
        this(iSolver, iVecInt, SolutionFoundListener.VOID);
    }

    public AbstractMinimalModel(ISolver iSolver, SolutionFoundListener solutionFoundListener) {
        this(iSolver, AbstractMinimalModel.negativeLiterals(iSolver), solutionFoundListener);
    }

    public AbstractMinimalModel(ISolver iSolver, IVecInt iVecInt, SolutionFoundListener solutionFoundListener) {
        super(iSolver);
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            this.pLiterals.add(iteratorInt.next());
        }
        this.modelListener = solutionFoundListener;
    }
}

