/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.AbstractClauseSelectorSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullClauseSelectorSolver<T extends ISolver>
extends AbstractClauseSelectorSolver<T> {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, IConstr> constrs = new HashMap<Integer, IConstr>();
    private final IVecInt lastClause = new VecInt();
    private IConstr lastConstr;
    private final boolean skipDuplicatedEntries;

    public FullClauseSelectorSolver(T t, boolean bl) {
        super(t);
        this.skipDuplicatedEntries = bl;
    }

    public IConstr addControlableClause(IVecInt iVecInt) throws ContradictionException {
        if (this.skipDuplicatedEntries) {
            if (iVecInt.equals(this.lastClause)) {
                return null;
            }
            this.lastClause.clear();
            iVecInt.copyTo(this.lastClause);
        }
        int n = this.createNewVar(iVecInt);
        iVecInt.push(n);
        this.lastConstr = super.addClause(iVecInt);
        if (this.lastConstr == null) {
            this.discardLastestVar();
        } else {
            this.constrs.put(n, this.lastConstr);
        }
        return this.lastConstr;
    }

    public IConstr addNonControlableClause(IVecInt iVecInt) throws ContradictionException {
        return super.addClause(iVecInt);
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        return this.addControlableClause(iVecInt);
    }

    @Override
    public int[] model() {
        int[] nArray = super.modelWithInternalVariables();
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length - this.constrs.size()];
        int n = 0;
        int[] nArray3 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray3[n3];
            if (this.constrs.get(Math.abs(n4)) == null) {
                nArray2[n++] = n4;
            }
            ++n3;
        }
        return nArray2;
    }

    public Collection<IConstr> getConstraints() {
        return this.constrs.values();
    }

    @Override
    public Collection<Integer> getAddedVars() {
        return this.constrs.keySet();
    }

    public IConstr getLastConstr() {
        return this.lastConstr;
    }

    public void setLastConstr(IConstr iConstr) {
        this.lastConstr = iConstr;
    }

    public Map<Integer, IConstr> getConstrs() {
        return this.constrs;
    }

    public IVecInt getLastClause() {
        return this.lastClause;
    }

    public boolean isSkipDuplicatedEntries() {
        return this.skipDuplicatedEntries;
    }
}

