/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.encoding;

import org.sat4j.core.ConstrGroup;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.encoding.EncodingStrategyAdapter;

public class Binary
extends EncodingStrategyAdapter {
    private static final long serialVersionUID = 1L;

    public IConstr addAtMostOne(ISolver iSolver, IVecInt iVecInt) throws ContradictionException {
        int n;
        ConstrGroup constrGroup = new ConstrGroup(false);
        int n2 = iVecInt.size();
        int n3 = (int)Math.ceil(Math.log(n2) / Math.log(2.0));
        int n4 = (int)Math.pow(2.0, n3) - n2;
        VecInt vecInt = new VecInt();
        String string = "";
        if (n3 == 0) {
            return constrGroup;
        }
        int[] nArray = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray[n5] = iSolver.nextFreeVarId(true);
            ++n5;
        }
        n5 = 0;
        while (n5 < n4) {
            string = Integer.toBinaryString(n5);
            while (string.length() != n3 - 1) {
                string = "0" + string;
            }
            n = 0;
            while (n < n3 - 1) {
                vecInt.push(-iVecInt.get(n5));
                if (string.charAt(n) == '0') {
                    vecInt.push(-nArray[n]);
                } else {
                    vecInt.push(nArray[n]);
                }
                constrGroup.add(iSolver.addClause(vecInt));
                vecInt.clear();
                ++n;
            }
            ++n5;
        }
        n5 = n4;
        while (n5 < n2) {
            string = Integer.toBinaryString(2 * n4 + n5 - n4);
            while (string.length() != n3) {
                string = "0" + string;
            }
            n = 0;
            while (n < n3) {
                vecInt.push(-iVecInt.get(n5));
                if (string.charAt(n) == '0') {
                    vecInt.push(-nArray[n]);
                } else {
                    vecInt.push(nArray[n]);
                }
                constrGroup.add(iSolver.addClause(vecInt));
                vecInt.clear();
                ++n;
            }
            ++n5;
        }
        return constrGroup;
    }

    public IConstr addAtMost(ISolver iSolver, IVecInt iVecInt, int n) throws ContradictionException {
        int n2;
        int n3;
        int n4 = iVecInt.size();
        int n5 = (int)Math.ceil(Math.log(n4) / Math.log(2.0));
        ConstrGroup constrGroup = new ConstrGroup(false);
        int[][] nArray = new int[n][n5];
        int n6 = 0;
        while (n6 < n) {
            n3 = 0;
            while (n3 < n5) {
                nArray[n6][n3] = iSolver.nextFreeVarId(true);
                ++n3;
            }
            ++n6;
        }
        int[][] nArray2 = new int[n][n4];
        n3 = 0;
        while (n3 < n) {
            n2 = 0;
            while (n2 < n4) {
                nArray2[n3][n2] = iSolver.nextFreeVarId(true);
                ++n2;
            }
            ++n3;
        }
        VecInt vecInt = new VecInt();
        VecInt vecInt2 = new VecInt();
        String string = "";
        int n7 = 0;
        while (n7 < n4) {
            n3 = Math.max(1, n - n4 + n7 + 1);
            n2 = Math.min(n7 + 1, n);
            vecInt.push(-iVecInt.get(n7));
            string = Integer.toBinaryString(n7);
            while (string.length() != n5) {
                string = "0" + string;
            }
            int n8 = n3 - 1;
            while (n8 < n2) {
                vecInt.push(nArray2[n8][n7]);
                int n9 = 0;
                while (n9 < n5) {
                    vecInt2.push(-nArray2[n8][n7]);
                    if (string.charAt(n9) == '0') {
                        vecInt2.push(-nArray[n8][n9]);
                    } else {
                        vecInt2.push(nArray[n8][n9]);
                    }
                    constrGroup.add(iSolver.addClause(vecInt2));
                    vecInt2.clear();
                    ++n9;
                }
                ++n8;
            }
            constrGroup.add(iSolver.addClause(vecInt));
            vecInt.clear();
            ++n7;
        }
        return constrGroup;
    }

    public IConstr addExactlyOne(ISolver iSolver, IVecInt iVecInt) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup();
        constrGroup.add(this.addAtLeastOne(iSolver, iVecInt));
        constrGroup.add(this.addAtMostOne(iSolver, iVecInt));
        return constrGroup;
    }

    public IConstr addExactly(ISolver iSolver, IVecInt iVecInt, int n) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup();
        constrGroup.add(this.addAtLeast(iSolver, iVecInt, n));
        constrGroup.add(this.addAtMost(iSolver, iVecInt, n));
        return constrGroup;
    }
}

