/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public final class Lanceur {
    private static InstanceReader reader;

    private Lanceur() {
    }

    static void showAvailableSolvers() {
        System.out.println("Available solvers: ");
        String[] stringArray = SolverFactory.solverNames();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
    }

    static void printStats(SolverStats solverStats, double d) {
        System.out.println("c starts\t: " + solverStats.starts);
        System.out.println("c conflicts\t: " + solverStats.conflicts);
        System.out.println("c decisions\t: " + solverStats.decisions);
        System.out.println("c propagations\t: " + solverStats.propagations);
        System.out.println("c inspects\t: " + solverStats.inspects);
        System.out.println("c learned literals\t: " + solverStats.learnedliterals);
        System.out.println("c learned binary clauses\t: " + solverStats.learnedbinaryclauses);
        System.out.println("c learned ternary clauses\t: " + solverStats.learnedternaryclauses);
        System.out.println("c learned clauses\t: " + solverStats.learnedclauses);
        System.out.println("c root simplifications\t: " + solverStats.rootSimplifications);
        System.out.println("c CPU time\t: " + d + " s");
    }

    public static void main(String[] stringArray) {
        try {
            Lanceur.displayHeader();
            ISolver iSolver = Lanceur.configureSolver(stringArray);
            long l = System.currentTimeMillis();
            Lanceur.readProblem(stringArray, iSolver, l);
            boolean bl = iSolver.isSatisfiable();
            Lanceur.displayResult(iSolver, l, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ContradictionException contradictionException) {
            System.out.println("s UNSATISFIABLE");
            System.out.println("c (trivial)");
        }
        catch (TimeoutException timeoutException) {
            System.out.println("c timeout");
        }
        catch (ParseFormatException parseFormatException) {
            parseFormatException.printStackTrace();
        }
    }

    private static void displayResult(ISolver iSolver, long l, boolean bl) {
        if (bl) {
            System.out.println("s SATISFIABLE");
            int[] nArray = iSolver.model();
            System.out.println("v " + reader.decode(nArray));
        } else {
            System.out.println("s UNSATISFIABLE");
        }
        System.out.println("c Total CPU time (ms) : " + (double)(System.currentTimeMillis() - l) / 1000.0);
    }

    private static void readProblem(String[] stringArray, ISolver iSolver, long l) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        System.out.println("c solving " + stringArray[1]);
        System.out.print("c reading problem ");
        reader = new InstanceReader(iSolver);
        reader.parseInstance(stringArray[1]);
        System.out.println("time " + (double)(System.currentTimeMillis() - l) / 1000.0);
        System.out.println("c #vars     " + iSolver.nVars());
        System.out.println("c #clauses  " + iSolver.nConstraints());
    }

    private static ISolver configureSolver(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: java -jar sat4j.jar <solver> <cnffile> [<timeout>]");
            Lanceur.showAvailableSolvers();
            System.exit(-1);
        }
        ISolver iSolver = SolverFactory.createSolverByName(stringArray[0]);
        System.out.println("c " + iSolver);
        if (stringArray.length == 3) {
            int n = Integer.parseInt(stringArray[2]);
            iSolver.setTimeout(n);
            System.out.println("c timeout: " + n + "s");
        }
        return iSolver;
    }

    private static void displayHeader() throws IOException {
        System.out.println("c SAT4J: a SATisfiability library for Java (c) 2004 Daniel Le Berre");
        URL uRL = Lanceur.class.getResource("/sat4j.version");
        if (uRL != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            System.out.println("c version " + bufferedReader.readLine());
            bufferedReader.close();
        } else {
            System.out.println("c no version file found!!!");
        }
    }
}

