/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.sat4j.minisat.constraints.CardinalityDataStructure;
import org.sat4j.minisat.constraints.ClausalDataStructureCB;
import org.sat4j.minisat.constraints.MixedDataStructureDaniel;
import org.sat4j.minisat.constraints.MixedDataStructureWithBinary;
import org.sat4j.minisat.constraints.MixedDataStructureWithBinaryAndTernary;
import org.sat4j.minisat.constraints.PBMaxDataStructure;
import org.sat4j.minisat.constraints.PBMinDataStructure;
import org.sat4j.minisat.constraints.pb.PBSolver;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.JWOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.MyOrder;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.ActiveLearning;
import org.sat4j.minisat.learning.FixedLengthLearning;
import org.sat4j.minisat.learning.LimitedLearning;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;
import org.sat4j.minisat.uip.DecisionUIP;
import org.sat4j.minisat.uip.FirstUIP;
import org.sat4j.specs.ISolver;

public class SolverFactory {
    public static ISolver newMiniLearning() {
        return SolverFactory.newMiniLearning(10);
    }

    public static ISolver newMiniLearning(int n) {
        return SolverFactory.newMiniLearning(new MixedDataStructureDaniel(), n);
    }

    public static ISolver newMiniLearning(DataStructureFactory dataStructureFactory) {
        return SolverFactory.newMiniLearning(dataStructureFactory, 10);
    }

    public static ISolver newMiniLearning2() {
        return SolverFactory.newMiniLearning(new MixedDataStructureWithBinary(), 10);
    }

    public static ISolver newMiniLearning2NewOrder() {
        LimitedLearning limitedLearning = new LimitedLearning(10);
        Solver solver = new Solver((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy)limitedLearning, (DataStructureFactory)new MixedDataStructureWithBinary(), new MyOrder());
        limitedLearning.setSolver(solver);
        return solver;
    }

    public static ISolver newMiniLearning23() {
        return SolverFactory.newMiniLearning(new MixedDataStructureWithBinaryAndTernary(), 10);
    }

    public static ISolver newMiniLearning(DataStructureFactory dataStructureFactory, int n) {
        LimitedLearning limitedLearning = new LimitedLearning(n);
        Solver solver = new Solver(new FirstUIP(), limitedLearning, dataStructureFactory);
        limitedLearning.setSolver(solver);
        return solver;
    }

    public static ISolver newMiniLearningNoRestarts() {
        LimitedLearning limitedLearning = new LimitedLearning(10);
        Solver solver = new Solver((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy)limitedLearning, (DataStructureFactory)new MixedDataStructureDaniel(), new SearchParams(Integer.MAX_VALUE));
        limitedLearning.setSolver(solver);
        return solver;
    }

    public static ISolver newMiniLearningCB() {
        return SolverFactory.newMiniLearning(new ClausalDataStructureCB(), 10);
    }

    public static ISolver newActiveLearning() {
        ActiveLearning activeLearning = new ActiveLearning();
        Solver solver = new Solver(new FirstUIP(), activeLearning, new MixedDataStructureDaniel());
        activeLearning.setOrder(solver.getOrder());
        activeLearning.setSolver(solver);
        return solver;
    }

    public static ISolver newMiniSAT() {
        return SolverFactory.newMiniSAT(new MixedDataStructureDaniel());
    }

    public static ISolver newMiniSATNoRestarts() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy)miniSATLearning, (DataStructureFactory)new MixedDataStructureDaniel(), new SearchParams(Integer.MAX_VALUE));
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        return solver;
    }

    public static ISolver newMiniSAT2() {
        return SolverFactory.newMiniSAT(new MixedDataStructureWithBinary());
    }

    public static ISolver newMiniSAT23() {
        return SolverFactory.newMiniSAT(new MixedDataStructureWithBinaryAndTernary());
    }

    public static ISolver newMiniSAT(DataStructureFactory dataStructureFactory) {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, dataStructureFactory);
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        return solver;
    }

    public static ISolver newMiniCard() {
        return SolverFactory.newMiniSAT(new CardinalityDataStructure());
    }

    public static ISolver newMinimalOPBMax() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, new PBMaxDataStructure());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        return solver;
    }

    public static ISolver newMiniOPBMax() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PBMaxDataStructure());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        return pBSolver;
    }

    public static ISolver newMinimalOPBMin() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, new PBMinDataStructure());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        return solver;
    }

    public static ISolver newMiniOPBMin() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PBMinDataStructure());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        return pBSolver;
    }

    public static ISolver newRelsat() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new DecisionUIP(), miniSATLearning, new MixedDataStructureDaniel());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        return solver;
    }

    public static ISolver newBackjumping() {
        NoLearningButHeuristics noLearningButHeuristics = new NoLearningButHeuristics();
        Solver solver = new Solver(new FirstUIP(), noLearningButHeuristics, new MixedDataStructureDaniel());
        noLearningButHeuristics.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMini3SAT() {
        FixedLengthLearning fixedLengthLearning = new FixedLengthLearning(3);
        Solver solver = new Solver((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy)fixedLengthLearning, (DataStructureFactory)new MixedDataStructureWithBinaryAndTernary(), new SearchParams(Integer.MAX_VALUE));
        ((LimitedLearning)fixedLengthLearning).setSolver(solver);
        solver.setOrder(new JWOrder());
        return solver;
    }

    public static ISolver newMini3SATb() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy)miniSATLearning, (DataStructureFactory)new MixedDataStructureWithBinaryAndTernary(), new SearchParams(Integer.MAX_VALUE));
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        solver.setOrder(new JWOrder());
        return solver;
    }

    public static String[] solverNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Method[] methodArray = SolverFactory.class.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i].getParameterTypes().length != 0 || !methodArray[i].getName().startsWith("new")) continue;
            arrayList.add(methodArray[i].getName().substring(3));
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static ISolver createSolverByName(String string) {
        Class[] classArray = new Class[]{};
        try {
            Method method = SolverFactory.class.getMethod("new" + string, classArray);
            return (ISolver)method.invoke(null, null);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return null;
    }
}

