/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.Handle;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.VecInt;

public class BinaryClauses
implements Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ILits voc;
    private final VecInt clauses = new VecInt();
    private final int reason;
    private int conflictindex = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BinaryClauses(ILits iLits, int n) {
        this.voc = iLits;
        this.reason = n;
    }

    public void addBinaryClause(int n) {
        this.clauses.push(n);
    }

    public void remove() {
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        if (!$assertionsDisabled && !this.voc.isFalsified(this.reason)) {
            throw new AssertionError();
        }
        this.voc.watch(n, this);
        for (int i = 0; i < this.clauses.size(); ++i) {
            if (unitPropagationListener.enqueue(this.clauses.get(i), this)) continue;
            this.conflictindex = i;
            return false;
        }
        return true;
    }

    public boolean simplify() {
        for (int i = 0; i < this.clauses.size(); ++i) {
            if (this.voc.isSatisfied(this.clauses.get(i))) {
                return true;
            }
            if (!this.voc.isFalsified(this.clauses.get(i))) continue;
            this.clauses.delete(i);
        }
        return false;
    }

    public void undo(int n) {
    }

    public void calcReason(int n, VecInt vecInt) {
        vecInt.push(this.reason ^ 1);
        if (n == -1) {
            if (!$assertionsDisabled && this.conflictindex <= -1) {
                throw new AssertionError();
            }
            vecInt.push(this.clauses.get(this.conflictindex) ^ 1);
        }
    }

    public boolean learnt() {
        return false;
    }

    public void incActivity(double d) {
    }

    public double getActivity() {
        return 0.0;
    }

    public boolean locked() {
        return false;
    }

    public void setLearnt() {
    }

    public void register() {
    }

    public void rescaleBy(double d) {
    }

    public int size() {
        return this.clauses.size();
    }

    public int get(int n) {
        throw new UnsupportedOperationException();
    }

    public int analyse(Handle handle) {
        throw new UnsupportedOperationException();
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        throw new UnsupportedOperationException();
    }

    static {
        $assertionsDisabled = !BinaryClauses.class.desiredAssertionStatus();
    }
}

