/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.Handle;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.VecInt;

public class CBClause
implements Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int falsified;
    private boolean learnt;
    private final int[] lits;
    private final ILits voc;
    private double activity;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static CBClause brandNewClause(UnitPropagationListener unitPropagationListener, ILits iLits, VecInt vecInt) throws ContradictionException {
        CBClause cBClause = new CBClause(vecInt, iLits);
        cBClause.register();
        return cBClause;
    }

    public CBClause(VecInt vecInt, ILits iLits, boolean bl) {
        this.learnt = bl;
        this.lits = new int[vecInt.size()];
        this.voc = iLits;
        vecInt.moveTo(this.lits);
    }

    public CBClause(VecInt vecInt, ILits iLits) {
        this(vecInt, iLits, false);
    }

    public void remove() {
        for (int i = 0; i < this.lits.length; ++i) {
            this.voc.watches(this.lits[i] ^ 1).remove(this);
        }
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        this.voc.watch(n, this);
        this.voc.undos(n).push(this);
        ++this.falsified;
        if (this.falsified == this.lits.length) {
            return false;
        }
        if (this.falsified == this.lits.length - 1) {
            for (int i = 0; i < this.lits.length; ++i) {
                if (this.voc.isFalsified(this.lits[i])) continue;
                return unitPropagationListener.enqueue(this.lits[i], this);
            }
            return false;
        }
        return true;
    }

    public boolean simplify() {
        for (int i = 0; i < this.lits.length; ++i) {
            if (!this.voc.isSatisfied(this.lits[i])) continue;
            return true;
        }
        return false;
    }

    public void undo(int n) {
        --this.falsified;
    }

    public void calcReason(int n, VecInt vecInt) {
        if (!$assertionsDisabled && vecInt.size() != 0) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.lits.length; ++i) {
            if (!$assertionsDisabled && !this.voc.isFalsified(this.lits[i]) && this.lits[i] != n) {
                throw new AssertionError();
            }
            if (!this.voc.isFalsified(this.lits[i])) continue;
            vecInt.push(this.lits[i] ^ 1);
        }
        if (!$assertionsDisabled && n != -1 && vecInt.size() != this.lits.length - 1) {
            throw new AssertionError();
        }
    }

    public boolean learnt() {
        return this.learnt;
    }

    public void incActivity(double d) {
        this.activity += d;
    }

    public double getActivity() {
        return this.activity;
    }

    public boolean locked() {
        return this.voc.getReason(this.lits[0]) == this;
    }

    public void setLearnt() {
        this.learnt = true;
    }

    public void register() {
        int n;
        for (n = 0; n < this.lits.length; ++n) {
            this.voc.watch(this.lits[n] ^ 1, this);
        }
        if (this.learnt) {
            for (n = 0; n < this.lits.length; ++n) {
                if (!this.voc.isFalsified(this.lits[n])) continue;
                this.voc.undos(this.lits[n] ^ 1).push(this);
                ++this.falsified;
            }
            if (!$assertionsDisabled && this.falsified != this.lits.length - 1) {
                throw new AssertionError();
            }
        }
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public int size() {
        return this.lits.length;
    }

    public int get(int n) {
        return this.lits[n];
    }

    public int analyse(Handle handle) {
        throw new UnsupportedOperationException();
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        if (!$assertionsDisabled && !this.voc.isUnassigned(this.lits[0])) {
            throw new AssertionError();
        }
        boolean bl = unitPropagationListener.enqueue(this.lits[0], this);
        if (!$assertionsDisabled && !bl) {
            throw new AssertionError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.lits.length; ++i) {
            stringBuffer.append(this.lits[i]);
            stringBuffer.append(" ");
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(this.lits[i]));
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    static {
        $assertionsDisabled = !CBClause.class.desiredAssertionStatus();
    }
}

