/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.Handle;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.VecInt;

public final class Clause
implements Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean learnt;
    private double activity;
    private final int[] lits;
    private final ILits voc;
    private static int counter;
    private final int id = ++counter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Clause(VecInt vecInt, ILits iLits) {
        this.lits = new int[vecInt.size()];
        vecInt.moveTo(this.lits);
        vecInt.clear();
        this.voc = iLits;
        this.activity = 0.0;
        this.learnt = false;
    }

    public int getId() {
        return this.id;
    }

    public static void resetIds() {
        counter = 0;
    }

    public static VecInt sanityCheck(VecInt vecInt, ILits iLits, UnitPropagationListener unitPropagationListener) throws ContradictionException {
        int n = 0;
        while (n < vecInt.size()) {
            if (!iLits.isUnassigned(vecInt.get(n))) {
                if (iLits.isSatisfied(vecInt.get(n))) {
                    return null;
                }
                vecInt.delete(n);
                continue;
            }
            ++n;
        }
        vecInt.sortUnique();
        for (n = 0; n < vecInt.size() - 1; ++n) {
            if (vecInt.get(n) != (vecInt.get(n + 1) ^ 1)) continue;
            return null;
        }
        if (Clause.propagationCheck(vecInt, unitPropagationListener)) {
            return null;
        }
        return vecInt;
    }

    static boolean propagationCheck(VecInt vecInt, UnitPropagationListener unitPropagationListener) throws ContradictionException {
        if (vecInt.size() == 0) {
            throw new ContradictionException("Creating Empty clause ?");
        }
        if (vecInt.size() == 1) {
            if (!unitPropagationListener.enqueue(vecInt.get(0))) {
                throw new ContradictionException("Contradictory Unit Clauses");
            }
            return true;
        }
        return false;
    }

    public void setLearnt() {
        this.learnt = true;
    }

    public void register() {
        if (!$assertionsDisabled && this.lits.length <= 1) {
            throw new AssertionError();
        }
        if (this.learnt) {
            int n;
            int n2 = 1;
            int n3 = this.voc.getLevel(this.lits[1]);
            for (n = 2; n < this.lits.length; ++n) {
                int n4 = this.voc.getLevel(this.lits[n]);
                if (n4 <= n3) continue;
                n2 = n;
                n3 = n4;
            }
            n = this.lits[1];
            this.lits[1] = this.lits[n2];
            this.lits[n2] = n;
        }
        this.voc.watch(this.lits[0] ^ 1, this);
        this.voc.watch(this.lits[1] ^ 1, this);
    }

    public static Clause brandNewClause(UnitPropagationListener unitPropagationListener, ILits iLits, VecInt vecInt) throws ContradictionException {
        Clause clause = new Clause(vecInt, iLits);
        clause.register();
        return clause;
    }

    public void calcReason(int n, VecInt vecInt) {
        int n2;
        if (!$assertionsDisabled && vecInt.size() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n != -1 && n != this.lits[0]) {
            throw new AssertionError();
        }
        int n3 = n2 = n == -1 ? 0 : 1;
        while (n2 < this.lits.length) {
            if (!$assertionsDisabled && !this.voc.isFalsified(this.lits[n2])) {
                throw new AssertionError();
            }
            vecInt.push(this.lits[n2] ^ 1);
            ++n2;
        }
    }

    public void remove() {
        this.voc.watches(this.lits[0] ^ 1).remove(this);
        this.voc.watches(this.lits[1] ^ 1).remove(this);
    }

    public boolean simplify() {
        for (int i = 0; i < this.lits.length; ++i) {
            if (!this.voc.isSatisfied(this.lits[i])) continue;
            return true;
        }
        return false;
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        if (this.lits[0] == (n ^ 1)) {
            this.lits[0] = this.lits[1];
            this.lits[1] = n ^ 1;
        }
        if (!$assertionsDisabled && this.lits[1] != (n ^ 1)) {
            throw new AssertionError();
        }
        if (this.voc.isSatisfied(this.lits[0])) {
            this.voc.watch(n, this);
            return true;
        }
        for (int i = 2; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            this.lits[1] = this.lits[i];
            this.lits[i] = n ^ 1;
            this.voc.watch(this.lits[1] ^ 1, this);
            return true;
        }
        if (!$assertionsDisabled && !this.voc.isFalsified(this.lits[1])) {
            throw new AssertionError();
        }
        this.voc.watch(n, this);
        return unitPropagationListener.enqueue(this.lits[0], this);
    }

    public boolean locked() {
        return this.voc.getReason(this.lits[0]) == this;
    }

    public double getActivity() {
        return this.activity;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.lits.length; ++i) {
            stringBuffer.append(this.lits[i]);
            stringBuffer.append(" ");
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(this.lits[i]));
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public int get(int n) {
        return this.lits[n];
    }

    public void incActivity(double d) {
        this.activity += d;
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public boolean learnt() {
        return this.learnt;
    }

    public int size() {
        return this.lits.length;
    }

    public static int lastid() {
        return counter;
    }

    public int analyse(Handle handle) {
        throw new UnsupportedOperationException();
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        boolean bl = unitPropagationListener.enqueue(this.lits[0], this);
        if (!$assertionsDisabled && !bl) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !Clause.class.desiredAssertionStatus();
        counter = 0;
    }
}

