/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Lbool;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.specs.Vec;

public class Lits
implements Serializable,
ILits {
    private static final long serialVersionUID = 1L;
    private boolean[] pool = new boolean[0];
    protected Vec[] watches = new Vec[0];
    private int[] level = new int[0];
    public Lbool[] truthValue = new Lbool[1];
    private Constr[] reason = new Constr[0];
    private Vec[] undos = new Vec[0];
    static final /* synthetic */ boolean $assertionsDisabled;

    public void init(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        int n2 = n + 1;
        boolean[] blArray = new boolean[n2];
        System.arraycopy(this.pool, 0, blArray, 0, this.pool.length);
        this.pool = blArray;
        this.level = new int[n2];
        int[] nArray = new int[n2];
        System.arraycopy(this.level, 0, nArray, 0, this.level.length);
        this.level = nArray;
        Vec[] vecArray = new Vec[2 * n2];
        System.arraycopy(this.watches, 0, vecArray, 0, this.watches.length);
        this.watches = vecArray;
        Lbool[] lboolArray = new Lbool[n2];
        System.arraycopy(this.truthValue, 0, lboolArray, 0, this.truthValue.length);
        this.truthValue = lboolArray;
        Vec[] vecArray2 = new Vec[n2];
        System.arraycopy(this.undos, 0, vecArray2, 0, this.undos.length);
        this.undos = vecArray2;
        Constr[] constrArray = new Constr[n2];
        System.arraycopy(this.reason, 0, constrArray, 0, this.reason.length);
        this.reason = constrArray;
    }

    public int getFromPool(int n) {
        int n2;
        int n3 = Math.abs(n);
        if (!$assertionsDisabled && n3 >= this.pool.length) {
            throw new AssertionError();
        }
        int n4 = n2 = n < 0 ? n3 << 1 ^ 1 : n3 << 1;
        if (!$assertionsDisabled && n2 <= 1) {
            throw new AssertionError();
        }
        if (!this.pool[n3]) {
            this.pool[n3] = true;
            this.watches[n3 << 1] = new Vec();
            this.watches[n3 << 1 | 1] = new Vec();
            this.truthValue[n3] = Lbool.UNDEFINED;
            this.undos[n3] = new Vec();
            this.level[n3] = -1;
        }
        return n2;
    }

    public void resetPool() {
        for (int i = 0; i < this.pool.length; ++i) {
            if (!this.pool[i]) continue;
            this.reset(i);
        }
    }

    public void ensurePool(int n) {
        this.init(n);
    }

    public void unassign(int n) {
        if (!$assertionsDisabled && this.truthValue[n >> 1] == Lbool.UNDEFINED) {
            throw new AssertionError();
        }
        this.truthValue[n >> 1] = Lbool.UNDEFINED;
    }

    public void satisfies(int n) {
        if (!$assertionsDisabled && this.truthValue[n >> 1] != Lbool.UNDEFINED) {
            throw new AssertionError();
        }
        this.truthValue[n >> 1] = Lits.satisfyingValue(n);
    }

    private static final Lbool satisfyingValue(int n) {
        return (n & 1) == 0 ? Lbool.TRUE : Lbool.FALSE;
    }

    public boolean isSatisfied(int n) {
        return this.truthValue[n >> 1] == Lits.satisfyingValue(n);
    }

    public boolean isFalsified(int n) {
        Lbool lbool = (n & 1) == 0 ? Lbool.FALSE : Lbool.TRUE;
        return this.truthValue[n >> 1] == lbool;
    }

    public boolean isUnassigned(int n) {
        return this.truthValue[n >> 1] == Lbool.UNDEFINED;
    }

    public String valueToString(int n) {
        if (this.isUnassigned(n)) {
            return "?";
        }
        if (this.isSatisfied(n)) {
            return "T";
        }
        return "F";
    }

    public int nVars() {
        return this.truthValue.length - 1;
    }

    public int not(int n) {
        return n ^ 1;
    }

    public static String toString(int n) {
        return ((n & 1) == 0 ? "" : "-") + (n >> 1);
    }

    public void reset(int n) {
        this.watches[n].clear();
        this.watches[n ^ 1].clear();
        this.level[n >> 1] = -1;
        this.truthValue[n >> 1] = Lbool.UNDEFINED;
        this.reason[n >> 1] = null;
        this.undos[n >> 1].clear();
    }

    public int getLevel(int n) {
        return this.level[n >> 1];
    }

    public void setLevel(int n, int n2) {
        this.level[n >> 1] = n2;
    }

    public Constr getReason(int n) {
        return this.reason[n >> 1];
    }

    public void setReason(int n, Constr constr) {
        this.reason[n >> 1] = constr;
    }

    public Vec undos(int n) {
        return this.undos[n >> 1];
    }

    public void watch(int n, Propagatable propagatable) {
        this.watches[n].push(propagatable);
    }

    public Vec watches(int n) {
        return this.watches[n];
    }

    static {
        $assertionsDisabled = !Lits.class.desiredAssertionStatus();
    }
}

