/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.Handle;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.VecInt;

public class TernaryClauses
implements Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    private final VecInt stubs = new VecInt();
    private final ILits voc;
    private final int phead;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TernaryClauses(ILits iLits, int n) {
        this.voc = iLits;
        this.phead = n;
    }

    public void addTernaryClause(int n, int n2) {
        this.stubs.push(n);
        this.stubs.push(n2);
    }

    public void remove() {
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        if (!$assertionsDisabled && !this.voc.isSatisfied(n)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.voc.isFalsified(this.phead)) {
            throw new AssertionError();
        }
        this.voc.watch(n, this);
        for (int i = 0; i < this.stubs.size(); i += 2) {
            int n2 = this.stubs.get(i);
            int n3 = this.stubs.get(i + 1);
            if (this.voc.isSatisfied(n2) || this.voc.isSatisfied(n3) || !(this.voc.isFalsified(n2) ? !unitPropagationListener.enqueue(n3, this) : this.voc.isFalsified(n3) && !unitPropagationListener.enqueue(n2, this))) continue;
            return false;
        }
        return true;
    }

    public boolean simplify() {
        return false;
    }

    public void undo(int n) {
    }

    public void calcReason(int n, VecInt vecInt) {
        if (!$assertionsDisabled && !this.voc.isFalsified(this.phead)) {
            throw new AssertionError();
        }
        if (n == -1) {
            int n2 = 0;
            while (!this.voc.isFalsified(this.stubs.get(n2)) || !this.voc.isFalsified(this.stubs.get(n2 + 1))) {
                n2 += 2;
            }
            vecInt.push(this.phead ^ 1);
            vecInt.push(this.stubs.get(n2) ^ 1);
            vecInt.push(this.stubs.get(n2 + 1) ^ 1);
        } else {
            vecInt.push(this.phead ^ 1);
            int n3 = 0;
            while (this.stubs.get(n3) != n || !this.voc.isFalsified(this.stubs.get(n3 ^ 1))) {
                ++n3;
            }
            if (!$assertionsDisabled && this.voc.isFalsified(this.stubs.get(n3))) {
                throw new AssertionError();
            }
            vecInt.push(this.stubs.get(n3 ^ 1) ^ 1);
            if (!$assertionsDisabled && !this.voc.isFalsified(this.stubs.get(n3 ^ 1))) {
                throw new AssertionError();
            }
        }
    }

    public boolean learnt() {
        return false;
    }

    public void incActivity(double d) {
    }

    public double getActivity() {
        return 0.0;
    }

    public boolean locked() {
        return false;
    }

    public void setLearnt() {
    }

    public void register() {
    }

    public void rescaleBy(double d) {
    }

    public int size() {
        return this.stubs.size();
    }

    public int get(int n) {
        throw new UnsupportedOperationException();
    }

    public int analyse(Handle handle) {
        throw new UnsupportedOperationException();
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        throw new UnsupportedOperationException();
    }

    static {
        $assertionsDisabled = !TernaryClauses.class.desiredAssertionStatus();
    }
}

