/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.constraints.AbstractDataStructureFactory;
import org.sat4j.minisat.constraints.cnf.Clause;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.Constr;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.VecBigInt;
import org.sat4j.specs.VecInt;

public abstract class AbstractPBDataStructureFactory
extends AbstractDataStructureFactory {
    private BigInteger[] index;

    public BigInteger[] getIndex() {
        return this.index;
    }

    private void lazyAllocation() {
        int n = this.getVocabulary().nVars() * 2 + 2;
        if (this.index == null) {
            this.index = new BigInteger[n];
            for (int i = 0; i < n; ++i) {
                this.index[i] = BigInteger.ZERO;
            }
        }
        if (this.index.length < n) {
            BigInteger[] bigIntegerArray = new BigInteger[n];
            System.arraycopy(this.index, 0, bigIntegerArray, 0, this.index.length);
            for (int i = this.index.length; i < n; ++i) {
                bigIntegerArray[i] = BigInteger.ZERO;
            }
            this.index = bigIntegerArray;
        }
    }

    public Constr createClause(VecInt vecInt) throws ContradictionException {
        this.lazyAllocation();
        VecInt vecInt2 = Clause.sanityCheck(vecInt, this.getVocabulary(), this.solver);
        if (vecInt2 == null) {
            return null;
        }
        VecInt vecInt3 = new VecInt(vecInt2.size(), 1);
        return this.constraintFactory(vecInt2, vecInt3, true, 1);
    }

    public Constr createUnregisteredClause(VecInt vecInt) {
        return new Clause(vecInt, this.getVocabulary());
    }

    public Constr createCardinalityConstraint(VecInt vecInt, int n) throws ContradictionException {
        this.lazyAllocation();
        VecInt vecInt2 = new VecInt(vecInt.size(), 1);
        return this.constraintFactory(vecInt, vecInt2, true, n);
    }

    public Constr createPseudoBooleanConstraint(VecInt vecInt, VecInt vecInt2, boolean bl, int n) throws ContradictionException {
        this.lazyAllocation();
        return this.constraintFactory(vecInt, vecInt2, bl, n);
    }

    protected abstract WatchPb constraintFactory(VecInt var1, VecInt var2, boolean var3, int var4) throws ContradictionException;

    protected abstract WatchPb constraintFactory(VecInt var1, VecBigInt var2, boolean var3, BigInteger var4) throws UnsupportedOperationException, ContradictionException;

    public void reset() {
    }

    public Constr createUnregisteredPseudoBooleanConstraint(VecInt vecInt, VecInt vecInt2, int n) {
        return this.constraintFactory(vecInt, vecInt2, n);
    }

    public Constr createUnregisteredPseudoBooleanConstraint(VecInt vecInt, VecBigInt vecBigInt, BigInteger bigInteger) {
        return this.constraintFactory(vecInt, vecBigInt, bigInteger);
    }

    public Constr createUnregisteredPseudoBooleanConstraint(VecInt vecInt, VecBigInt vecBigInt, boolean bl, BigInteger bigInteger) throws ContradictionException {
        return this.constraintFactory(vecInt, vecBigInt, bl, bigInteger);
    }

    protected abstract WatchPb constraintFactory(VecInt var1, VecInt var2, int var3);

    protected abstract WatchPb constraintFactory(VecInt var1, VecBigInt var2, BigInteger var3);
}

