/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.pb.Indexer;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.VecBigInt;
import org.sat4j.specs.VecInt;

public class MaxWatchPb
extends WatchPb
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    private MaxWatchPb(ILits iLits, VecInt vecInt, VecBigInt vecBigInt, boolean bl, BigInteger bigInteger, Indexer indexer) {
        super(indexer);
        if (!$assertionsDisabled && this.indexer == null) {
            throw new AssertionError();
        }
        this.voc = iLits;
        if (!$assertionsDisabled && vecInt.size() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && vecInt.size() != vecBigInt.size()) {
            throw new AssertionError();
        }
        bigInteger = bigInteger.add(this.normalizeParameter(vecInt, vecBigInt));
        this.lits = new int[vecInt.size()];
        vecInt.copyTo(this.lits);
        this.coefs = new BigInteger[vecBigInt.size()];
        for (int i = 0; i < vecBigInt.size(); ++i) {
            this.coefs[i] = vecBigInt.get(i);
        }
        this.degree = bigInteger;
        this.moreThan = bl;
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        this.locked = false;
        this.normalize();
    }

    protected void computeWatches() throws ContradictionException {
        if (!$assertionsDisabled && !this.watchCumul.equals(BigInteger.ZERO)) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.lits.length; ++i) {
            this.voc.watch(this.lits[i] ^ 1, this);
            this.watchCumul = this.watchCumul.add(this.coefs[i]);
        }
        if (!$assertionsDisabled && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError();
        }
        if (!this.learnt && this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        for (int i = 0; i < this.coefs.length && this.watchCumul.subtract(this.coefs[i]).compareTo(this.degree) < 0; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            throw new ContradictionException("non satisfiable constraint");
        }
        if (!$assertionsDisabled && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError();
        }
    }

    public static MaxWatchPb maxWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, VecInt vecInt, VecInt vecInt2, boolean bl, int n, Indexer indexer) throws ContradictionException {
        return MaxWatchPb.maxWatchPbNew(unitPropagationListener, iLits, vecInt, MaxWatchPb.toVecBigInt(vecInt2), bl, MaxWatchPb.toBigInt(n), indexer);
    }

    public static MaxWatchPb maxWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, VecInt vecInt, VecBigInt vecBigInt, boolean bl, BigInteger bigInteger, Indexer indexer) throws ContradictionException {
        VecInt vecInt2 = new VecInt();
        VecBigInt vecBigInt2 = new VecBigInt();
        vecInt.copyTo(vecInt2);
        vecBigInt.copyTo(vecBigInt2);
        MaxWatchPb.niceParameter(vecInt2, vecBigInt2);
        MaxWatchPb maxWatchPb = new MaxWatchPb(iLits, vecInt2, vecBigInt2, bl, bigInteger, indexer);
        if (maxWatchPb.degree.signum() <= 0) {
            return null;
        }
        maxWatchPb.computeWatches();
        maxWatchPb.computePropagation(unitPropagationListener);
        return maxWatchPb;
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        this.voc.watch(n, this);
        if (!$assertionsDisabled && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError();
        }
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        BigInteger bigInteger = this.coefs[n2];
        if (this.watchCumul.subtract(bigInteger).compareTo(this.degree) < 0) {
            if (!$assertionsDisabled && this.isSatisfiable()) {
                throw new AssertionError();
            }
            return false;
        }
        this.voc.undos(n).push(this);
        this.watchCumul = this.watchCumul.subtract(bigInteger);
        for (int i = 0; i < this.coefs.length && this.watchCumul.subtract(this.coefs[i]).compareTo(this.degree) < 0; ++i) {
            if (!this.voc.isUnassigned(this.lits[i])) continue;
            if (!unitPropagationListener.enqueue(this.lits[i], this)) {
                if (!$assertionsDisabled && this.isSatisfiable()) {
                    throw new AssertionError();
                }
                return false;
            }
            this.logger.fine("litt\ufffdral impliqu\ufffd " + Lits.toString(this.lits[i]));
            this.logger.fine(" par la contrainte " + this);
        }
        if (!$assertionsDisabled && !this.learnt && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError();
        }
        return true;
    }

    public void remove() {
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            this.voc.watches(this.lits[i] ^ 1).remove(this);
        }
    }

    public void undo(int n) {
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        if (!$assertionsDisabled && this.coefs[n2].signum() <= 0) {
            throw new AssertionError();
        }
        this.watchCumul = this.watchCumul.add(this.coefs[n2]);
    }

    public static WatchPb watchPbNew(ILits iLits, VecInt vecInt, VecInt vecInt2, boolean bl, int n, Indexer indexer) {
        return new MaxWatchPb(iLits, vecInt, MaxWatchPb.toVecBigInt(vecInt2), bl, MaxWatchPb.toBigInt(n), indexer);
    }

    public static WatchPb watchPbNew(ILits iLits, VecInt vecInt, VecBigInt vecBigInt, boolean bl, BigInteger bigInteger, Indexer indexer) {
        return new MaxWatchPb(iLits, vecInt, vecBigInt, bl, bigInteger, indexer);
    }

    static {
        $assertionsDisabled = !MaxWatchPb.class.desiredAssertionStatus();
    }
}

