/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.minisat.constraints.pb.Indexer;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.VecBigInt;
import org.sat4j.specs.VecInt;

public class MinWatchPb
extends WatchPb
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean[] watched;
    private int[] watching;
    private int watchingCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    private MinWatchPb(ILits iLits, VecInt vecInt, VecBigInt vecBigInt, boolean bl, BigInteger bigInteger, Indexer indexer) {
        super(indexer);
        this.voc = iLits;
        if (!$assertionsDisabled && vecInt.size() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && vecInt.size() != vecBigInt.size()) {
            throw new AssertionError();
        }
        bigInteger = bigInteger.add(this.normalizeParameter(vecInt, vecBigInt));
        this.lits = new int[vecInt.size()];
        vecInt.moveTo(this.lits);
        this.coefs = new BigInteger[vecBigInt.size()];
        for (int i = 0; i < vecBigInt.size(); ++i) {
            this.coefs[i] = vecBigInt.get(i);
        }
        this.degree = bigInteger;
        this.moreThan = bl;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        this.locked = false;
        this.undos = new VecInt();
        this.watchingCount = 0;
        this.normalize();
    }

    protected void computeWatches() throws ContradictionException {
        int n;
        if (!$assertionsDisabled && this.watchCumul.signum() != 0) {
            throw new AssertionError();
        }
        for (n = 0; n < this.lits.length && this.watchCumul.subtract(this.coefs[0]).compareTo(this.degree) < 0; ++n) {
            if (this.voc.isFalsified(this.lits[n])) continue;
            this.voc.watch(this.lits[n] ^ 1, this);
            this.watching[this.watchingCount++] = n;
            this.watched[n] = true;
            this.watchCumul = this.watchCumul.add(this.coefs[n]);
        }
        if (this.learnt) {
            n = 1;
            while (this.watchCumul.subtract(this.coefs[0]).compareTo(this.degree) < 0 && n > 0) {
                n = 0;
                int n2 = -1;
                int n3 = -1;
                for (int i = 0; i < this.lits.length; ++i) {
                    if (!this.voc.isFalsified(this.lits[i]) || this.watched[i]) continue;
                    ++n;
                    int n4 = this.voc.getLevel(this.lits[i]);
                    if (n4 <= n2) continue;
                    n3 = i;
                    n2 = n4;
                }
                if (n <= 0) continue;
                if (!$assertionsDisabled && n3 < 0) {
                    throw new AssertionError();
                }
                this.voc.watch(this.lits[n3] ^ 1, this);
                this.watching[this.watchingCount++] = n3;
                this.watched[n3] = true;
                this.watchCumul = this.watchCumul.add(this.coefs[n3]);
                if (!$assertionsDisabled && --n < 0) {
                    throw new AssertionError();
                }
            }
        }
        if (this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        for (int i = 0; i < this.lits.length && this.watchCumul.subtract(this.coefs[this.watching[i]]).compareTo(this.degree) < 0; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    public static MinWatchPb minWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, VecInt vecInt, VecInt vecInt2, boolean bl, int n, Indexer indexer) throws ContradictionException {
        return MinWatchPb.minWatchPbNew(unitPropagationListener, iLits, vecInt, MinWatchPb.toVecBigInt(vecInt2), bl, MinWatchPb.toBigInt(n), indexer);
    }

    public static MinWatchPb minWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, VecInt vecInt, VecBigInt vecBigInt, boolean bl, BigInteger bigInteger, Indexer indexer) throws ContradictionException {
        VecInt vecInt2 = new VecInt();
        VecBigInt vecBigInt2 = new VecBigInt();
        vecInt.copyTo(vecInt2);
        vecBigInt.copyTo(vecBigInt2);
        MinWatchPb.niceParameter(vecInt2, vecBigInt2);
        MinWatchPb minWatchPb = new MinWatchPb(iLits, vecInt2, vecBigInt2, bl, bigInteger, indexer);
        if (minWatchPb.degree.signum() <= 0) {
            return null;
        }
        minWatchPb.computeWatches();
        minWatchPb.computePropagation(unitPropagationListener);
        return minWatchPb;
    }

    protected int nbOfWatched() {
        int n = 0;
        for (int i = 0; i < this.watched.length; ++i) {
            for (int j = 0; j < this.watchingCount; ++j) {
                if (this.watching[j] == i && !$assertionsDisabled && !this.watched[i]) {
                    throw new AssertionError();
                }
            }
            n += this.watched[i] ? 1 : 0;
        }
        return n;
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        int n2;
        int n3;
        if (!$assertionsDisabled && this.watchingCount <= 1) {
            throw new AssertionError();
        }
        for (n3 = 0; n3 < this.watchingCount && (this.lits[this.watching[n3]] ^ 1) != n; ++n3) {
        }
        int n4 = this.watching[n3];
        BigInteger bigInteger = BigInteger.ZERO;
        for (n2 = 0; n2 < this.watchingCount; ++n2) {
            if (this.coefs[this.watching[n2]].compareTo(bigInteger) <= 0 || this.watching[n2] == n4) continue;
            bigInteger = this.coefs[this.watching[n2]];
        }
        if (!$assertionsDisabled && !this.learnt && bigInteger.signum() == 0) {
            throw new AssertionError();
        }
        for (n2 = 0; n2 < this.lits.length && this.watchCumul.subtract(this.coefs[n4]).subtract(bigInteger).compareTo(this.degree) < 0; ++n2) {
            if (this.voc.isFalsified(this.lits[n2]) || this.watched[n2]) continue;
            this.watchCumul = this.watchCumul.add(this.coefs[n2]);
            this.watched[n2] = true;
            if (!$assertionsDisabled && this.watchingCount >= this.size()) {
                throw new AssertionError();
            }
            this.watching[this.watchingCount++] = n2;
            this.voc.watch(this.lits[n2] ^ 1, this);
            if (this.coefs[n2].compareTo(bigInteger) <= 0) continue;
            bigInteger = this.coefs[n2];
        }
        if (this.watchCumul.subtract(this.coefs[n4]).compareTo(this.degree) < 0) {
            this.voc.watch(n, this);
            if (!$assertionsDisabled && this.isSatisfiable()) {
                throw new AssertionError();
            }
            return false;
        }
        if (n2 >= this.lits.length) {
            if (!$assertionsDisabled && this.watchingCount == 0) {
                throw new AssertionError();
            }
            for (int i = 0; i < this.watchingCount; ++i) {
                if (this.watchCumul.subtract(this.coefs[n4]).subtract(this.coefs[this.watching[i]]).compareTo(this.degree) >= 0 || i == n3 || unitPropagationListener.enqueue(this.lits[this.watching[i]], this)) continue;
                this.voc.watch(n, this);
                if (!$assertionsDisabled && this.isSatisfiable()) {
                    throw new AssertionError();
                }
                return false;
            }
            this.voc.undos(n).push(this);
            this.undos.push(n4);
        }
        this.watched[n4] = false;
        this.watchCumul = this.watchCumul.subtract(this.coefs[n4]);
        this.watching[n3] = this.watching[--this.watchingCount];
        if (!$assertionsDisabled && this.watchingCount == 0) {
            throw new AssertionError();
        }
        return true;
    }

    public void remove() {
        for (int i = 0; i < this.watchingCount; ++i) {
            this.voc.watches(this.lits[this.watching[i]] ^ 1).remove(this);
            this.watched[this.watching[i]] = false;
        }
    }

    public void undo(int n) {
        this.voc.watch(n, this);
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        this.watchCumul = this.watchCumul.add(this.coefs[n2]);
        this.watched[n2] = true;
        this.watching[this.watchingCount++] = n2;
    }

    public static WatchPb watchPbNew(ILits iLits, VecInt vecInt, VecInt vecInt2, boolean bl, int n, Indexer indexer) {
        return new MinWatchPb(iLits, vecInt, MinWatchPb.toVecBigInt(vecInt2), bl, MinWatchPb.toBigInt(n), indexer);
    }

    public static WatchPb watchPbNew(ILits iLits, VecInt vecInt, VecBigInt vecBigInt, boolean bl, BigInteger bigInteger, Indexer indexer) {
        return new MinWatchPb(iLits, vecInt, vecBigInt, bl, bigInteger, indexer);
    }

    static {
        $assertionsDisabled = !MinWatchPb.class.desiredAssertionStatus();
    }
}

