/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import java.util.logging.Logger;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.pb.AbstractPBDataStructureFactory;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.Handle;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.specs.VecBigInt;
import org.sat4j.specs.VecInt;

public class PBSolver
extends Solver {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PBSolver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy learningStrategy, DataStructureFactory dataStructureFactory) {
        super(assertingClauseGenerator, learningStrategy, dataStructureFactory);
    }

    public int analyze(Constr constr, Handle handle) {
        Object object;
        int n;
        Logger logger = Logger.getLogger("org.sat4j.minisat.constraints.pb");
        WatchPb watchPb = (WatchPb)constr;
        BigInteger bigInteger = watchPb.getDegree();
        logger.fine("Analyse");
        watchPb.initIndex();
        logger.fine("Init " + watchPb);
        int n2 = this.trail.last();
        int n3 = n = this.voc.getLevel(n2);
        if (!$assertionsDisabled && watchPb.slackIndex(bigInteger).signum() >= 0) {
            throw new AssertionError();
        }
        while (!watchPb.indexIsAssertive(n, bigInteger)) {
            logger.fine("Resolving on " + Lits.toString(n2) + "@" + n);
            object = (WatchPb)this.voc.getReason(n2);
            if (object != null) {
                logger.fine("Res with " + Lits.toString(n2) + " on " + object);
                if (!$assertionsDisabled && ((WatchPb)object).indexer != watchPb.indexer) {
                    throw new AssertionError();
                }
                bigInteger = ((WatchPb)object).resolve(n2, bigInteger);
                if (!$assertionsDisabled && watchPb.slackIndex(bigInteger).signum() > 0) {
                    throw new AssertionError();
                }
            } else {
                logger.fine("No reason for " + Lits.toString(n2));
            }
            if (this.trail.size() == 1) break;
            this.undoOne();
            n2 = this.trail.last();
            n = this.voc.getLevel(n2);
            if (!$assertionsDisabled && n2 <= 1) {
                throw new AssertionError();
            }
        }
        this.undoOne();
        object = new VecInt();
        VecBigInt vecBigInt = new VecBigInt();
        watchPb.buildConstraintFromIndex((VecInt)object, vecBigInt);
        if (!$assertionsDisabled && ((VecInt)object).size() != vecBigInt.size()) {
            throw new AssertionError();
        }
        if (((VecInt)object).size() == 0) {
            handle.obj = null;
            return 0;
        }
        if (!$assertionsDisabled && !watchPb.emptyIndex()) {
            throw new AssertionError();
        }
        WatchPb watchPb2 = (WatchPb)((AbstractPBDataStructureFactory)this.dsfactory).createUnregisteredPseudoBooleanConstraint((VecInt)object, vecBigInt, bigInteger);
        handle.obj = watchPb2;
        logger.fine("Contrainte apprise : " + watchPb2);
        int n4 = watchPb2.getBacktrackLevel(n);
        logger.fine("Backtrack level : " + n4);
        return n4;
    }

    static {
        $assertionsDisabled = !PBSolver.class.desiredAssertionStatus();
    }
}

