/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import java.util.Random;
import java.util.logging.Logger;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.pb.Indexer;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.Handle;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.VecBigInt;
import org.sat4j.specs.VecInt;

public abstract class WatchPb
implements Constr,
Undoable {
    public static final boolean ATMOST = false;
    public static final boolean ATLEAST = true;
    private static final Random rand;
    protected double activity;
    protected BigInteger[] coefs;
    protected BigInteger degree;
    final Indexer indexer;
    protected int[] lits;
    protected boolean learnt = false;
    protected boolean locked;
    protected boolean moreThan;
    protected BigInteger watchCumul = BigInteger.ZERO;
    protected VecInt undos;
    protected int backtrackLiteral;
    protected Logger logger = Logger.getLogger("org.sat4j.minisat.constraints.pb");
    protected ILits voc;
    static final /* synthetic */ boolean $assertionsDisabled;

    public int analyse(Handle handle) {
        throw new UnsupportedOperationException();
    }

    WatchPb() {
        this.indexer = null;
    }

    WatchPb(Indexer indexer) {
        this.indexer = indexer;
    }

    public void buildConstraintFromIndex(VecInt vecInt, VecBigInt vecBigInt) {
        vecInt.clear();
        vecBigInt.clear();
        BigInteger[] bigIntegerArray = this.indexer.getIndex();
        for (int i = 2; i < bigIntegerArray.length; ++i) {
            if (bigIntegerArray[i].signum() > 0) {
                vecInt.push(i);
                vecBigInt.push(bigIntegerArray[i]);
            }
            bigIntegerArray[i] = BigInteger.ZERO;
        }
    }

    public boolean indexIsAssertive(int n, BigInteger bigInteger) {
        int n2;
        this.logger.entering(this.getClass().getName(), "isAssertive");
        this.printIndex();
        this.logger.fine(" >= " + bigInteger);
        this.logger.fine("slack index " + this.slackIndex(bigInteger));
        this.logger.fine("current level " + n);
        BigInteger[] bigIntegerArray = this.indexer.getIndex();
        BigInteger bigInteger2 = BigInteger.ZERO;
        for (n2 = 2; n2 < bigIntegerArray.length; ++n2) {
            if (bigIntegerArray[n2].signum() <= 0 || this.voc.isFalsified(n2) && this.voc.getLevel(n2) < n) continue;
            bigInteger2 = bigInteger2.add(bigIntegerArray[n2]);
        }
        bigInteger2 = bigInteger2.subtract(bigInteger);
        for (n2 = 2; n2 < bigIntegerArray.length; ++n2) {
            if (bigIntegerArray[n2].signum() <= 0 || !this.voc.isUnassigned(n2) && this.voc.getLevel(n2) < n || bigInteger2.subtract(bigIntegerArray[n2]).signum() >= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isAssertive(int n) {
        int n2;
        BigInteger bigInteger = BigInteger.ZERO;
        for (n2 = 0; n2 < this.lits.length; ++n2) {
            if (this.coefs[n2].signum() <= 0 || this.voc.isFalsified(this.lits[n2]) && this.voc.getLevel(this.lits[n2]) < n) continue;
            bigInteger = bigInteger.add(this.coefs[n2]);
        }
        bigInteger = bigInteger.subtract(this.degree);
        for (n2 = 0; n2 < this.lits.length; ++n2) {
            if (this.coefs[n2].signum() <= 0 || !this.voc.isUnassigned(this.lits[n2]) && this.voc.getLevel(this.lits[n2]) < n || bigInteger.subtract(this.coefs[n2]).signum() >= 0) continue;
            return true;
        }
        return false;
    }

    public void calcReason(int n, VecInt vecInt) {
        for (int i = 0; i < this.lits.length; ++i) {
            if (!this.voc.isFalsified(this.lits[i])) continue;
            vecInt.push(this.lits[i] ^ 1);
        }
    }

    protected abstract void computeWatches() throws ContradictionException;

    protected abstract void computePropagation(UnitPropagationListener var1) throws ContradictionException;

    public int get(int n) {
        return this.lits[n];
    }

    public BigInteger getCoef(int n) {
        return this.coefs[n];
    }

    public double getActivity() {
        return this.activity;
    }

    protected static void niceParameter(VecInt vecInt, VecBigInt vecBigInt) throws ContradictionException {
        if (vecInt.size() == 0) {
            throw new ContradictionException("Creating Empty clause ?");
        }
        if (vecInt.size() != vecBigInt.size()) {
            throw new IllegalArgumentException("Contradiction dans la taille des tableaux ps=" + vecInt.size() + " coefs=" + vecBigInt.size() + ".");
        }
    }

    public void incActivity(double d) {
        this.activity += d;
    }

    public BigInteger slackIndex(BigInteger bigInteger) {
        return this.possIndex().subtract(bigInteger);
    }

    public BigInteger slackIndex(int n, BigInteger bigInteger) {
        BigInteger bigInteger2 = this.indexer.getIndex()[n ^ 1];
        this.logger.fine("literal coef " + bigInteger2);
        return this.possIndex().subtract(bigInteger).subtract(bigInteger2);
    }

    public BigInteger possIndex() {
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger[] bigIntegerArray = this.indexer.getIndex();
        for (int i = 2; i < bigIntegerArray.length; ++i) {
            if (bigIntegerArray[i].signum() == 0 || this.voc.isFalsified(i)) continue;
            bigInteger = bigInteger.add(bigIntegerArray[i]);
        }
        return bigInteger;
    }

    public BigInteger slackConstraint() {
        return this.possConstraint().subtract(this.degree);
    }

    public BigInteger slackConstraint(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        return this.possConstraint(bigIntegerArray).subtract(bigInteger);
    }

    public BigInteger possConstraint(BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < bigIntegerArray.length; ++i) {
            if (bigIntegerArray[i].signum() <= 0 || this.voc.isFalsified(this.lits[i])) continue;
            bigInteger = bigInteger.add(bigIntegerArray[i]);
        }
        return bigInteger;
    }

    public BigInteger possConstraint() {
        return this.possConstraint(this.coefs);
    }

    public void initIndex() {
        if (!$assertionsDisabled && !this.emptyIndex()) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.lits.length; ++i) {
            if (!$assertionsDisabled && this.lits[i] == 0) {
                throw new AssertionError();
            }
            this.indexer.getIndex()[this.lits[i]] = this.coefs[i];
        }
    }

    public boolean emptyIndex() {
        for (int i = 0; i < this.indexer.getIndex().length; ++i) {
            if (this.indexer.getIndex()[i].signum() == 0) continue;
            return false;
        }
        return true;
    }

    protected boolean isSatisfiable() {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            if (!$assertionsDisabled && this.coefs[i].signum() <= 0) {
                throw new AssertionError();
            }
            bigInteger = bigInteger.add(this.coefs[i]);
        }
        return bigInteger.compareTo(this.degree) >= 0;
    }

    public boolean learnt() {
        return this.learnt;
    }

    public boolean locked() {
        return true;
    }

    protected void normalize() {
        int n;
        this.logger.entering(this.getClass().getName(), "normalize");
        this.logger.finer("Before normalizing " + this.toString());
        if (!this.moreThan) {
            for (n = 0; n < this.lits.length; ++n) {
                this.coefs[n] = this.coefs[n].negate();
            }
            this.degree = this.degree.negate();
            this.moreThan = true;
        }
        if (!$assertionsDisabled && !this.moreThan) {
            throw new AssertionError();
        }
        for (n = 0; n < this.lits.length; ++n) {
            if (this.coefs[n].signum() < 0) {
                this.lits[n] = this.lits[n] ^ 1;
                this.coefs[n] = this.coefs[n].negate();
                this.degree = this.degree.add(this.coefs[n]);
            }
            if (!$assertionsDisabled && this.coefs[n].signum() < 0) {
                throw new AssertionError();
            }
        }
        this.sort();
        n = 0;
        while (this.coefs.length > n && this.coefs[n].compareTo(this.degree) > 0) {
            this.coefs[n++] = this.degree;
        }
        if (n == this.coefs.length && this.degree.signum() > 0) {
            this.degree = BigInteger.ONE;
            for (int i = 0; i < this.coefs.length; ++i) {
                this.coefs[i] = this.degree;
            }
        }
        this.logger.finer("After normalizing " + this.toString());
    }

    protected BigInteger normalizeParameter(VecInt vecInt, VecBigInt vecBigInt) {
        int n;
        BigInteger bigInteger = BigInteger.ZERO;
        if (!$assertionsDisabled && vecInt.size() != vecBigInt.size()) {
            throw new AssertionError();
        }
        BigInteger[] bigIntegerArray = this.indexer.getIndex();
        for (n = 0; n < bigIntegerArray.length; ++n) {
            bigIntegerArray[n] = BigInteger.ZERO;
        }
        for (n = 0; n < vecInt.size(); ++n) {
            if (!$assertionsDisabled && vecInt.get(n) == 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && vecBigInt.get(n).signum() == 0) {
                throw new AssertionError();
            }
            if (vecBigInt.get(n).signum() < 0) {
                bigIntegerArray[vecInt.get((int)n) ^ 1] = bigIntegerArray[vecInt.get(n) ^ 1].subtract(vecBigInt.get(n));
                bigInteger = bigInteger.add(bigIntegerArray[vecInt.get(n) ^ 1]);
                continue;
            }
            bigIntegerArray[vecInt.get((int)n)] = bigIntegerArray[vecInt.get(n)].add(vecBigInt.get(n));
        }
        n = 0;
        while (n < vecInt.size()) {
            if (bigIntegerArray[vecInt.get(n)].equals(bigIntegerArray[vecInt.get(n) ^ 1])) {
                bigInteger = bigInteger.subtract(bigIntegerArray[vecInt.get(n)]);
                if (!$assertionsDisabled && vecInt.last() == 0) {
                    throw new AssertionError();
                }
                bigIntegerArray[vecInt.get((int)n)] = BigInteger.ZERO;
                bigIntegerArray[vecInt.get((int)n) ^ 1] = BigInteger.ZERO;
                vecInt.delete(n);
                vecBigInt.delete(n);
                continue;
            }
            if (bigIntegerArray[vecInt.get(n)].compareTo(bigIntegerArray[vecInt.get(n) ^ 1]) > 0) {
                bigInteger = bigInteger.subtract(bigIntegerArray[vecInt.get(n) ^ 1]);
                vecBigInt.set(n, bigIntegerArray[vecInt.get(n)].subtract(bigIntegerArray[vecInt.get(n) ^ 1]));
                if (!$assertionsDisabled && vecBigInt.get(n).signum() < 0) {
                    throw new AssertionError();
                }
                bigIntegerArray[vecInt.get((int)n)] = BigInteger.ZERO;
                bigIntegerArray[vecInt.get((int)n) ^ 1] = BigInteger.ZERO;
                ++n;
                continue;
            }
            if (!$assertionsDisabled && bigIntegerArray[vecInt.get(n)].compareTo(bigIntegerArray[vecInt.get(n) ^ 1]) >= 0) {
                throw new AssertionError();
            }
            bigInteger = bigInteger.subtract(bigIntegerArray[vecInt.get(n)]);
            vecBigInt.set(n, bigIntegerArray[vecInt.get(n) ^ 1].subtract(bigIntegerArray[vecInt.get(n)]));
            vecInt.set(n, vecInt.get(n) ^ 1);
            if (!$assertionsDisabled && vecBigInt.get(n).signum() < 0) {
                throw new AssertionError();
            }
            bigIntegerArray[vecInt.get((int)n)] = BigInteger.ZERO;
            bigIntegerArray[vecInt.get((int)n) ^ 1] = BigInteger.ZERO;
            ++n;
        }
        return bigInteger;
    }

    public BigInteger reduceInConstraint(BigInteger[] bigIntegerArray, int n, BigInteger bigInteger) {
        int n2;
        int n3;
        this.logger.entering(this.getClass().getName(), "reduceInConstraint");
        if (!$assertionsDisabled && bigInteger.compareTo(BigInteger.ONE) <= 0) {
            throw new AssertionError();
        }
        int n4 = -1;
        for (n3 = 0; n3 < this.lits.length && n4 == -1; ++n3) {
            if (bigIntegerArray[n3].signum() == 0 || !this.voc.isUnassigned(this.lits[n3])) continue;
            if (!$assertionsDisabled && bigIntegerArray[n3].compareTo(bigInteger) >= 0) {
                throw new AssertionError();
            }
            n4 = n3;
        }
        if (n4 == -1) {
            for (n3 = 0; n3 < this.lits.length && n4 == -1; ++n3) {
                if (bigIntegerArray[n3].signum() == 0 || !this.voc.isSatisfied(this.lits[n3]) || n3 == n) continue;
                n4 = n3;
            }
        }
        if (!$assertionsDisabled && n4 == -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n4 == n) {
            throw new AssertionError();
        }
        this.logger.finer("Found literal " + Lits.toString(this.lits[n4]));
        BigInteger bigInteger2 = bigInteger.subtract(bigIntegerArray[n4]);
        bigIntegerArray[n4] = BigInteger.ZERO;
        if (!$assertionsDisabled && bigInteger2.signum() <= 0) {
            throw new AssertionError();
        }
        BigInteger bigInteger3 = bigInteger2;
        for (n2 = 0; n2 < bigIntegerArray.length; ++n2) {
            if (bigIntegerArray[n2].signum() > 0) {
                bigInteger3 = bigInteger3.min(bigIntegerArray[n2]);
            }
            bigIntegerArray[n2] = bigInteger2.min(bigIntegerArray[n2]);
        }
        if (bigInteger3.equals(bigInteger2) && !bigInteger2.equals(BigInteger.ONE)) {
            bigInteger2 = BigInteger.ONE;
            for (n2 = 0; n2 < bigIntegerArray.length; ++n2) {
                if (bigIntegerArray[n2].signum() <= 0) continue;
                bigIntegerArray[n2] = bigInteger2;
            }
        }
        if (!$assertionsDisabled && bigIntegerArray[n].signum() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bigInteger.compareTo(bigInteger2) <= 0) {
            throw new AssertionError();
        }
        return bigInteger2;
    }

    protected static BigInteger ppcm(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.divide(bigInteger.gcd(bigInteger2)).multiply(bigInteger2);
    }

    protected BigInteger recalcLeftSide() {
        return this.possConstraint();
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    void selectionSort(int n, int n2) {
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i;
            for (int j = i + 1; j < n2; ++j) {
                if (this.coefs[j].compareTo(this.coefs[n3]) <= 0) continue;
                n3 = j;
            }
            BigInteger bigInteger = this.coefs[i];
            this.coefs[i] = this.coefs[n3];
            this.coefs[n3] = bigInteger;
            int n4 = this.lits[i];
            this.lits[i] = this.lits[n3];
            this.lits[n3] = n4;
        }
    }

    public void setLearnt() {
        this.learnt = true;
    }

    public boolean simplify() {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < this.lits.length && bigInteger.compareTo(this.degree) < 0; ++i) {
            if (!this.voc.isSatisfied(this.lits[i])) continue;
            bigInteger = bigInteger.add(this.coefs[i]);
        }
        return bigInteger.compareTo(this.degree) >= 0;
    }

    public int size() {
        return this.lits.length;
    }

    protected void sort() {
        if (!$assertionsDisabled && this.lits == null) {
            throw new AssertionError();
        }
        if (this.size() > 0) {
            this.sort(0, this.size());
            BigInteger bigInteger = this.coefs[0];
            for (int i = 1; i < this.size(); ++i) {
                if (!$assertionsDisabled && bigInteger.compareTo(this.coefs[i]) < 0) {
                    throw new AssertionError();
                }
                bigInteger = this.coefs[i];
            }
        }
    }

    protected void sort(int n, int n2) {
        int n3 = n2 - n;
        if (n2 - n <= 15) {
            this.selectionSort(n, n2);
        } else {
            BigInteger bigInteger = this.coefs[rand.nextInt(n3) + n];
            int n4 = n - 1;
            int n5 = n2;
            while (true) {
                if (this.coefs[++n4].compareTo(bigInteger) > 0) {
                    continue;
                }
                while (bigInteger.compareTo(this.coefs[--n5]) > 0) {
                }
                if (n4 >= n5) break;
                BigInteger bigInteger2 = this.coefs[n4];
                this.coefs[n4] = this.coefs[n5];
                this.coefs[n5] = bigInteger2;
                int n6 = this.lits[n4];
                this.lits[n4] = this.lits[n5];
                this.lits[n5] = n6;
            }
            this.sort(n, n4);
            this.sort(n4, n2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lits.length > 0) {
            stringBuffer.append(this.coefs[0]);
            stringBuffer.append(".");
            stringBuffer.append(Lits.toString(this.lits[0]));
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(this.lits[0]));
            stringBuffer.append("@");
            stringBuffer.append(this.voc.getLevel(this.lits[0]));
            stringBuffer.append("]");
            stringBuffer.append(" ");
            for (int i = 1; i < this.lits.length; ++i) {
                stringBuffer.append(" + ");
                stringBuffer.append(this.coefs[i]);
                stringBuffer.append(".");
                stringBuffer.append(Lits.toString(this.lits[i]));
                stringBuffer.append("[");
                stringBuffer.append(this.voc.valueToString(this.lits[i]));
                stringBuffer.append("@");
                stringBuffer.append(this.voc.getLevel(this.lits[i]));
                stringBuffer.append("]");
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.moreThan ? ">= " : "<= ");
            stringBuffer.append(this.degree);
        }
        return stringBuffer.toString();
    }

    public BigInteger resolve(int n, BigInteger bigInteger) {
        int n2;
        BigInteger bigInteger2;
        if (!$assertionsDisabled && n <= 1) {
            throw new AssertionError();
        }
        BigInteger[] bigIntegerArray = this.indexer.getIndex();
        if (bigIntegerArray[n ^ 1].signum() == 0) {
            this.logger.fine("pas de resolution");
            return bigInteger;
        }
        if (!$assertionsDisabled && this.slackIndex(bigInteger).signum() > 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.degree.signum() < 0) {
            throw new AssertionError();
        }
        BigInteger[] bigIntegerArray2 = new BigInteger[this.coefs.length];
        System.arraycopy(this.coefs, 0, bigIntegerArray2, 0, this.coefs.length);
        BigInteger bigInteger3 = this.degree;
        int n3 = -1;
        while (this.lits[++n3] != n) {
        }
        if (!$assertionsDisabled && this.lits[n3] != n) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bigIntegerArray2[n3] == BigInteger.ZERO) {
            throw new AssertionError();
        }
        BigInteger bigInteger4 = BigInteger.ONE.negate();
        BigInteger bigInteger5 = BigInteger.ZERO;
        BigInteger bigInteger6 = BigInteger.ZERO;
        BigInteger bigInteger7 = BigInteger.ZERO;
        int n4 = -1;
        do {
            this.logger.fine("Compteur de passages : " + ++n4);
            if (bigInteger4.signum() >= 0) {
                if (!$assertionsDisabled && bigInteger5.signum() <= 0) {
                    throw new AssertionError();
                }
                BigInteger bigInteger8 = this.reduceInConstraint(bigIntegerArray2, n3, bigInteger3);
                if (!($assertionsDisabled || bigInteger8.compareTo(bigInteger3) < 0 && bigInteger8.compareTo(BigInteger.ONE) >= 0)) {
                    throw new AssertionError();
                }
                bigInteger3 = bigInteger8;
            }
            if (!$assertionsDisabled && bigIntegerArray[n ^ 1].signum() <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && bigIntegerArray2[n3].signum() <= 0) {
                throw new AssertionError();
            }
            BigInteger bigInteger9 = WatchPb.ppcm(bigIntegerArray2[n3], bigIntegerArray[n ^ 1]);
            if (!$assertionsDisabled && bigInteger9.signum() <= 0) {
                throw new AssertionError();
            }
            bigInteger2 = bigInteger9.divide(bigIntegerArray[n ^ 1]);
            bigInteger7 = bigInteger9.divide(bigIntegerArray2[n3]);
            if (!$assertionsDisabled && bigInteger2.signum() <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && bigInteger7.signum() <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !bigInteger2.multiply(bigIntegerArray[n ^ 1]).equals(bigInteger7.multiply(bigIntegerArray2[n3]))) {
                throw new AssertionError();
            }
            bigInteger5 = this.slackConstraint(bigIntegerArray2, bigInteger3).multiply(bigInteger7);
            bigInteger6 = this.slackIndex(bigInteger).multiply(bigInteger2);
            if (!$assertionsDisabled && bigInteger6.signum() > 0) {
                throw new AssertionError();
            }
        } while ((bigInteger4 = bigInteger5.add(bigInteger6)).signum() >= 0);
        BigInteger bigInteger10 = bigInteger3.multiply(bigInteger7).add(bigInteger.multiply(bigInteger2));
        if (bigInteger2.compareTo(BigInteger.ONE) > 0) {
            for (int i = 2; i < bigIntegerArray.length; ++i) {
                bigIntegerArray[i] = bigIntegerArray[i].multiply(bigInteger2);
            }
        }
        for (int i = 0; i < this.lits.length; ++i) {
            int n5 = this.lits[i];
            BigInteger bigInteger11 = bigIntegerArray2[i].multiply(bigInteger7);
            if (bigIntegerArray[n5 ^ 1].compareTo(bigInteger11) <= 0) {
                bigIntegerArray[n5] = bigIntegerArray[n5].add(bigInteger11.subtract(bigIntegerArray[n5 ^ 1]));
                bigInteger10 = bigInteger10.subtract(bigIntegerArray[n5 ^ 1]);
                bigIntegerArray[n5 ^ 1] = BigInteger.ZERO;
            } else {
                if (!$assertionsDisabled && bigIntegerArray[n5].signum() != 0) {
                    throw new AssertionError();
                }
                bigIntegerArray[n5 ^ 1] = bigIntegerArray[n5 ^ 1].subtract(bigInteger11);
                bigInteger10 = bigInteger10.subtract(bigInteger11);
            }
            if (!$assertionsDisabled && bigIntegerArray[n5].signum() != 0 && bigIntegerArray[n5 ^ 1].signum() != 0) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && bigIntegerArray[n].signum() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bigIntegerArray[n ^ 1].signum() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bigInteger10.signum() <= 0) {
            throw new AssertionError();
        }
        BigInteger bigInteger12 = bigInteger10;
        for (n2 = 0; n2 < bigIntegerArray.length; ++n2) {
            bigIntegerArray[n2] = bigInteger10.min(bigIntegerArray[n2]);
            if (bigIntegerArray[n2].signum() <= 0) continue;
            bigInteger12 = bigInteger12.min(bigIntegerArray[n2]);
        }
        if (bigInteger12.equals(bigInteger10) && bigInteger12.compareTo(BigInteger.ONE) > 0) {
            bigInteger10 = BigInteger.ONE;
            for (n2 = 0; n2 < bigIntegerArray.length; ++n2) {
                if (bigIntegerArray[n2].signum() <= 0) continue;
                bigIntegerArray[n2] = bigInteger10.min(bigIntegerArray[n2]);
            }
        }
        if (!$assertionsDisabled && this.slackIndex(bigInteger10).signum() > 0) {
            throw new AssertionError();
        }
        return bigInteger10;
    }

    public void printIndex() {
        BigInteger[] bigIntegerArray = this.indexer.getIndex();
        this.logger.fine("Index : ");
        for (int i = 2; i < bigIntegerArray.length; ++i) {
            if (bigIntegerArray[i].signum() == 0) continue;
            this.logger.fine(" " + bigIntegerArray[i] + "." + Lits.toString(i) + "[" + this.voc.valueToString(i) + "@" + this.voc.getLevel(i) + "]");
        }
    }

    public int getBacktrackLevel(int n) {
        int n2;
        int n3;
        int n4 = n;
        if (!$assertionsDisabled && !this.isAssertive(n4)) {
            throw new AssertionError();
        }
        int n5 = -1;
        for (n3 = 0; n3 < this.lits.length; ++n3) {
            n2 = this.voc.getLevel(this.lits[n3]);
            if (n2 >= n4 || n2 <= n5) continue;
            if (this.isAssertive(n2)) {
                n4 = n2;
                continue;
            }
            n5 = n2;
        }
        n3 = 0;
        for (int i = 0; i < this.lits.length; ++i) {
            n2 = this.voc.getLevel(this.lits[i]);
            if (n2 <= n3 || n2 >= n4) continue;
            n3 = n2;
        }
        return n3;
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        BigInteger bigInteger = this.slackConstraint();
        for (int i = 0; i < this.lits.length; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || bigInteger.subtract(this.coefs[i]).signum() >= 0) continue;
            boolean bl = unitPropagationListener.enqueue(this.lits[i], this);
            if (!$assertionsDisabled && !bl) {
                throw new AssertionError();
            }
        }
    }

    public BigInteger getDegree() {
        return this.degree;
    }

    public void register() {
        block3: {
            if (!$assertionsDisabled && !this.learnt) {
                throw new AssertionError();
            }
            try {
                this.computeWatches();
            }
            catch (ContradictionException contradictionException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    protected static VecBigInt toVecBigInt(VecInt vecInt) {
        VecBigInt vecBigInt = new VecBigInt(vecInt.size());
        for (int i = 0; i < vecInt.size(); ++i) {
            vecBigInt.push(BigInteger.valueOf(vecInt.get(i)));
        }
        return vecBigInt;
    }

    protected static BigInteger toBigInt(int n) {
        return BigInteger.valueOf(n);
    }

    static {
        $assertionsDisabled = !WatchPb.class.desiredAssertionStatus();
        rand = new Random(91648253L);
    }
}

