/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.util.ArrayList;
import java.util.Collections;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.ILits23;
import org.sat4j.minisat.core.VarOrder;

public class JWOrder
extends VarOrder {
    private static final long serialVersionUID = 1L;
    private ILits23 lits;
    static final /* synthetic */ boolean $assertionsDisabled;

    private int computeWeight(int n) {
        int n2 = this.lits.nBinaryClauses(n);
        int n3 = this.lits.nBinaryClauses(n ^ 1);
        int n4 = this.lits.nTernaryClauses(n);
        int n5 = this.lits.nTernaryClauses(n ^ 1);
        return (n2 * n3 * 100 + n2 + n3) * 5 + n4 * n5 * 10 + n4 + n5;
    }

    public void setLits(ILits iLits) {
        super.setLits(iLits);
        this.lits = (ILits23)iLits;
    }

    public void init() {
        Temp temp;
        int n;
        super.init();
        ArrayList<Temp> arrayList = new ArrayList<Temp>(this.order.size());
        for (n = 1; n < this.order.size(); ++n) {
            temp = new Temp(this.order.get(n));
            arrayList.add(temp);
        }
        Collections.sort(arrayList);
        System.out.println(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            temp = (Temp)arrayList.get(n);
            this.order.set(n + 1, temp.id);
            int n2 = temp.id >> 1;
            this.varpos[n2] = n + 1;
            this.activity[((Temp)temp).id >> 1] = temp.count;
        }
        this.lastVar = 1;
    }

    public void updateVar(int n) {
        if (!$assertionsDisabled && n <= 1) {
            throw new AssertionError();
        }
        this.activity[n >> 1] = this.computeWeight(n);
        for (int i = this.varpos[n >> 1]; i > 1 && this.activity[this.order.get(i - 1) >> 1] < this.activity[n >> 1]; --i) {
            if (!$assertionsDisabled && this.order.get(i) != n && this.order.get(i) != (n ^ 1)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && i <= 1) {
                throw new AssertionError();
            }
            int n2 = this.order.get(i - 1);
            if (!$assertionsDisabled && this.varpos[n2 >> 1] != i - 1) {
                throw new AssertionError();
            }
            this.varpos[n2 >> 1] = i;
            this.varpos[n >> 1] = i - 1;
            this.order.set(i, n2);
            this.order.set(i - 1, n);
        }
    }

    static {
        $assertionsDisabled = !JWOrder.class.desiredAssertionStatus();
    }

    class Temp
    implements Comparable {
        private int id;
        private int count;

        Temp(int n) {
            this.id = n;
            this.count = JWOrder.this.computeWeight(n);
        }

        public int compareTo(Object object) {
            Temp temp = (Temp)object;
            if (this.count == 0) {
                return Integer.MAX_VALUE;
            }
            if (temp.count == 0) {
                return -1;
            }
            return temp.count - this.count;
        }

        public String toString() {
            return "" + this.id + "(" + this.count + ")";
        }
    }
}

