/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.util.ArrayList;
import java.util.Collections;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.ILits2;
import org.sat4j.minisat.core.VarOrder;

public class MyOrder
extends VarOrder {
    private static final long serialVersionUID = 1L;
    private ILits2 lits;

    public void setLits(ILits iLits) {
        super.setLits(iLits);
        this.lits = (ILits2)iLits;
    }

    public void init() {
        Temp temp;
        int n;
        super.init();
        ArrayList<Temp> arrayList = new ArrayList<Temp>(this.order.size());
        for (n = 1; n < this.order.size(); ++n) {
            temp = new Temp(this.order.get(n));
            arrayList.add(temp);
        }
        Collections.sort(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            temp = (Temp)arrayList.get(n);
            this.order.set(n + 1, temp.id);
            int n2 = temp.id >> 1;
            this.varpos[n2] = n + 1;
        }
        this.lastVar = 1;
    }

    class Temp
    implements Comparable {
        private int id;
        private int count;

        Temp(int n) {
            this.id = n;
            this.count = MyOrder.this.lits.nBinaryClauses(n) + MyOrder.this.lits.nBinaryClauses(n ^ 1);
        }

        public int compareTo(Object object) {
            Temp temp = (Temp)object;
            if (this.count == 0) {
                return Integer.MAX_VALUE;
            }
            if (temp.count == 0) {
                return -1;
            }
            return this.count - temp.count;
        }

        public String toString() {
            return "" + this.id + "(" + this.count + ")";
        }
    }
}

