/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import org.sat4j.minisat.core.ActivityComparator;
import org.sat4j.minisat.core.ActivityListener;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.Handle;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IntQueue;
import org.sat4j.minisat.core.Lbool;
import org.sat4j.minisat.core.Learner;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.minisat.core.VarOrder;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;
import org.sat4j.specs.Vec;
import org.sat4j.specs.VecInt;

public class Solver
implements ISolver,
UnitPropagationListener,
ActivityListener,
Learner,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double CLAUSE_RESCALE_FACTOR = 1.0E-20;
    private static final double CLAUSE_RESCALE_BOUND = 1.0E20;
    private final Vec constrs = new Vec();
    private final Vec learnts = new Vec();
    private double claInc = 1.0;
    private double claDecay = 1.0;
    private final IntQueue propQ = new IntQueue();
    protected final VecInt trail = new VecInt();
    private final VecInt trailLim = new VecInt();
    private int rootLevel;
    private int[] model = null;
    protected final ILits voc;
    private VarOrder order;
    private final Comparator comparator = new ActivityComparator();
    private final SolverStats stats = new SolverStats();
    private final LearningStrategy learner;
    protected final AssertingClauseGenerator analyzer;
    private boolean undertimeout;
    private int timeout = Integer.MAX_VALUE;
    protected final DataStructureFactory dsfactory;
    private final SearchParams params;
    private boolean[] seen = new boolean[0];
    private final VecInt preason = new VecInt();
    private final VecInt outLearnt = new VecInt();
    private final Vec tmp = new Vec();
    private final Handle learntConstraint = new Handle();
    private int oldNConstraints;
    private int oldNLearnts;
    private int oldTrail;
    private int oldTrailLim;
    static final /* synthetic */ boolean $assertionsDisabled;

    private VecInt dimacs2internal(VecInt vecInt) {
        VecInt vecInt2 = new VecInt(vecInt.size());
        for (int i = 0; i < vecInt.size(); ++i) {
            if (!($assertionsDisabled || vecInt.get(i) != 0 && Math.abs(vecInt.get(i)) <= this.voc.nVars())) {
                throw new AssertionError();
            }
            vecInt2.push(this.voc.getFromPool(vecInt.get(i)));
        }
        return vecInt2;
    }

    public Solver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy learningStrategy, DataStructureFactory dataStructureFactory) {
        this(assertingClauseGenerator, learningStrategy, dataStructureFactory, new SearchParams(), new VarOrder());
    }

    public Solver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy learningStrategy, DataStructureFactory dataStructureFactory, VarOrder varOrder) {
        this(assertingClauseGenerator, learningStrategy, dataStructureFactory, new SearchParams(), varOrder);
    }

    public Solver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy learningStrategy, DataStructureFactory dataStructureFactory, SearchParams searchParams) {
        this(assertingClauseGenerator, learningStrategy, dataStructureFactory, searchParams, new VarOrder());
    }

    public Solver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy learningStrategy, DataStructureFactory dataStructureFactory, SearchParams searchParams, VarOrder varOrder) {
        this.analyzer = assertingClauseGenerator;
        this.learner = learningStrategy;
        this.dsfactory = dataStructureFactory;
        this.dsfactory.setUnitPropagationListener(this);
        this.dsfactory.setLearner(this);
        this.order = varOrder;
        this.voc = dataStructureFactory.getVocabulary();
        varOrder.setLits(this.voc);
        this.params = searchParams;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    protected int nAssigns() {
        return this.trail.size();
    }

    public int nConstraints() {
        return this.constrs.size();
    }

    private int nLearnts() {
        return this.learnts.size();
    }

    public void learn(Constr constr) {
        this.learnts.push(constr);
        constr.setLearnt();
        constr.register();
        this.claBumpActivity(constr);
        ++this.stats.learnedclauses;
    }

    public int decisionLevel() {
        return this.trailLim.size();
    }

    public int newVar() {
        int n = this.voc.nVars() + 1;
        this.voc.ensurePool(n);
        this.seen = new boolean[n + 1];
        this.trail.ensure(n);
        this.trailLim.ensure(n);
        this.propQ.ensure(n);
        this.order.newVar();
        return n;
    }

    public int newVar(int n) {
        this.voc.ensurePool(n);
        this.order.newVar(n);
        this.seen = new boolean[n + 1];
        this.trail.ensure(n);
        this.trailLim.ensure(n);
        this.propQ.ensure(n);
        return this.voc.nVars();
    }

    public void addClause(VecInt vecInt) throws ContradictionException {
        VecInt vecInt2 = this.dimacs2internal(vecInt);
        this.addConstr(this.dsfactory.createClause(vecInt2));
    }

    public void addPseudoBoolean(VecInt vecInt, VecInt vecInt2, boolean bl, int n) throws ContradictionException {
        VecInt vecInt3 = this.dimacs2internal(vecInt);
        if (!$assertionsDisabled && vecInt3.size() != vecInt.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && vecInt.size() != vecInt2.size()) {
            throw new AssertionError();
        }
        this.addConstr(this.dsfactory.createPseudoBooleanConstraint(vecInt3, vecInt2, bl, n));
    }

    public void addAllClauses(Vec vec) throws ContradictionException {
        for (int i = 0; i < vec.size(); ++i) {
            this.addClause((VecInt)vec.get(i));
        }
    }

    public void addAtMost(VecInt vecInt, int n) throws ContradictionException {
        for (int i = 0; i < vecInt.size(); ++i) {
            vecInt.set(i, -vecInt.get(i));
        }
        this.addAtLeast(vecInt, vecInt.size() - n);
    }

    public void addAtLeast(VecInt vecInt, int n) throws ContradictionException {
        VecInt vecInt2 = this.dimacs2internal(vecInt);
        this.addConstr(this.dsfactory.createCardinalityConstraint(vecInt2, n));
    }

    public boolean simplifyDB() {
        Vec[] vecArray = new Vec[]{this.constrs, this.learnts};
        for (int i = 0; i < 2; ++i) {
            int n = 0;
            for (int j = 0; j < vecArray[i].size(); ++j) {
                if (((Constr)vecArray[i].get(j)).simplify()) {
                    ((Constr)vecArray[i].get(j)).remove();
                    continue;
                }
                vecArray[i].set(n++, vecArray[i].get(j));
            }
            vecArray[i].shrinkTo(n);
        }
        return true;
    }

    public int[] model() {
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        int[] nArray = new int[this.model.length];
        System.arraycopy(this.model, 0, nArray, 0, this.model.length);
        return nArray;
    }

    public boolean enqueue(int n) {
        return this.enqueue(n, null);
    }

    public boolean enqueue(int n, Constr constr) {
        if (!$assertionsDisabled && n <= 1) {
            throw new AssertionError();
        }
        if (!this.voc.isUnassigned(n)) {
            return !this.voc.isFalsified(n);
        }
        this.voc.satisfies(n);
        this.voc.setLevel(n, this.decisionLevel());
        this.voc.setReason(n, constr);
        this.trail.push(n);
        this.propQ.insert(n);
        return true;
    }

    public int analyze(Constr constr, Handle handle) {
        int n;
        if (!$assertionsDisabled && constr == null) {
            throw new AssertionError();
        }
        this.outLearnt.clear();
        if (!$assertionsDisabled && this.outLearnt.size() != 0) {
            throw new AssertionError();
        }
        for (n = 0; n < this.seen.length; ++n) {
            this.seen[n] = false;
        }
        this.analyzer.initAnalyze();
        n = -1;
        this.outLearnt.push(-1);
        int n2 = 0;
        do {
            this.preason.clear();
            if (!$assertionsDisabled && constr == null) {
                throw new AssertionError();
            }
            constr.calcReason(n, this.preason);
            if (constr.learnt()) {
                this.claBumpActivity(constr);
            }
            for (int i = 0; i < this.preason.size(); ++i) {
                int n3 = this.preason.get(i);
                if (this.seen[n3 >> 1]) continue;
                this.seen[n3 >> 1] = true;
                if (this.voc.getLevel(n3) == this.decisionLevel()) {
                    this.analyzer.onCurrentDecisionLevelLiteral(n3);
                    continue;
                }
                if (this.voc.getLevel(n3) <= 0) continue;
                this.outLearnt.push(n3 ^ 1);
                n2 = Math.max(n2, this.voc.getLevel(n3));
            }
            do {
                n = this.trail.last();
                constr = this.voc.getReason(n);
                this.undoOne();
            } while (!this.seen[n >> 1]);
        } while (this.analyzer.clauseNonAssertive(constr));
        this.outLearnt.set(0, n ^ 1);
        Constr constr2 = this.dsfactory.createUnregisteredClause(this.outLearnt);
        handle.obj = constr2;
        if (!$assertionsDisabled && n2 <= -1) {
            throw new AssertionError();
        }
        return n2;
    }

    protected void undoOne() {
        int n = this.trail.last();
        if (!$assertionsDisabled && n <= 1) {
            throw new AssertionError();
        }
        int n2 = n >> 1;
        this.voc.unassign(n);
        this.voc.setReason(n, null);
        this.voc.setLevel(n, -1);
        this.order.undo(n2);
        this.trail.pop();
        Vec vec = this.voc.undos(n);
        if (!$assertionsDisabled && vec == null) {
            throw new AssertionError();
        }
        while (vec.size() > 0) {
            ((Undoable)vec.last()).undo(n);
            vec.pop();
        }
    }

    public void claBumpActivity(Constr constr) {
        constr.incActivity(this.claInc);
        if (constr.getActivity() > 1.0E20) {
            this.claRescalActivity();
        }
        for (int i = 0; i < constr.size(); ++i) {
            this.varBumpActivity(constr.get(i));
        }
    }

    public void varBumpActivity(int n) {
        this.order.updateVar(n);
    }

    private void claRescalActivity() {
        for (int i = 0; i < this.learnts.size(); ++i) {
            ((Constr)this.learnts.get(i)).rescaleBy(1.0E-20);
        }
        this.claInc *= 1.0E-20;
    }

    public Constr propagate() {
        while (this.propQ.size() > 0) {
            ++this.stats.propagations;
            int n = this.propQ.dequeue();
            if (!$assertionsDisabled && n <= 1) {
                throw new AssertionError();
            }
            this.tmp.clear();
            this.voc.watches(n).moveTo(this.tmp);
            for (int i = 0; i < this.tmp.size(); ++i) {
                ++this.stats.inspects;
                if (((Propagatable)this.tmp.get(i)).propagate(this, n)) continue;
                for (int j = i + 1; j < this.tmp.size(); ++j) {
                    this.voc.watch(n, (Propagatable)this.tmp.get(j));
                }
                this.propQ.clear();
                return (Constr)this.tmp.get(i);
            }
        }
        return null;
    }

    void record(Constr constr) {
        constr.setLearnt();
        constr.assertConstraint(this);
        if (constr.size() == 1) {
            ++this.stats.learnedliterals;
        } else {
            this.learner.learns(constr);
        }
    }

    public boolean assume(int n) {
        if (!$assertionsDisabled && this.propQ.size() != 0) {
            throw new AssertionError();
        }
        this.trailLim.push(this.trail.size());
        return this.enqueue(n);
    }

    private void cancel() {
        if (!$assertionsDisabled && this.propQ.size() != 0 && this.undertimeout) {
            throw new AssertionError();
        }
        for (int i = this.trail.size() - this.trailLim.last(); i > 0; --i) {
            this.undoOne();
        }
        this.trailLim.pop();
    }

    protected void cancelUntil(int n) {
        while (this.decisionLevel() > n) {
            this.cancel();
        }
    }

    Lbool search(long l, long l2) {
        if (!$assertionsDisabled && this.rootLevel != this.decisionLevel()) {
            throw new AssertionError();
        }
        ++this.stats.starts;
        int n = 0;
        this.order.setVarDecay(1.0 / this.params.getVarDecay());
        this.claDecay = 1.0 / this.params.getClaDecay();
        do {
            int n2;
            Constr constr = this.propagate();
            if (!$assertionsDisabled && this.propQ.size() != 0) {
                throw new AssertionError();
            }
            if (constr != null) {
                ++this.stats.conflicts;
                ++n;
                if (this.decisionLevel() == this.rootLevel) {
                    return Lbool.FALSE;
                }
                if (!$assertionsDisabled && constr == null) {
                    throw new AssertionError();
                }
                n2 = this.analyze(constr, this.learntConstraint);
                if (!$assertionsDisabled && n2 >= this.decisionLevel()) {
                    throw new AssertionError();
                }
                this.cancelUntil(Math.max(n2, this.rootLevel));
                if (!($assertionsDisabled || this.decisionLevel() >= this.rootLevel && this.decisionLevel() >= n2)) {
                    throw new AssertionError();
                }
                if (this.learntConstraint.obj == null) {
                    return Lbool.FALSE;
                }
                this.record((Constr)this.learntConstraint.obj);
                this.learntConstraint.obj = null;
                this.decayActivities();
                continue;
            }
            if (this.decisionLevel() == 0) {
                ++this.stats.rootSimplifications;
                n2 = this.simplifyDB();
                if (!$assertionsDisabled && n2 == 0) {
                    throw new AssertionError();
                }
            }
            if (l2 >= 0L && (long)this.learnts.size() > l2) {
                this.reduceDB();
            }
            if (!$assertionsDisabled && this.nAssigns() > this.voc.nVars()) {
                throw new AssertionError();
            }
            if (this.nAssigns() == this.voc.nVars()) {
                this.modelFound();
                return Lbool.TRUE;
            }
            if ((long)n >= l) {
                this.cancelUntil(this.rootLevel);
                return Lbool.UNDEFINED;
            }
            ++this.stats.decisions;
            n2 = this.order.select();
            if (!$assertionsDisabled && n2 <= 1) {
                throw new AssertionError();
            }
            boolean bl = this.assume(n2);
            if (!$assertionsDisabled && !bl) {
                throw new AssertionError();
            }
        } while (this.undertimeout);
        return Lbool.UNDEFINED;
    }

    void modelFound() {
        this.model = new int[this.trail.size()];
        int n = 0;
        for (int i = 1; i <= this.voc.nVars(); ++i) {
            if (this.voc.isUnassigned(i)) continue;
            this.model[n++] = this.voc.isSatisfied(this.voc.getFromPool(i)) ? i : -i;
        }
        if (!$assertionsDisabled && n != this.model.length) {
            throw new AssertionError();
        }
        this.cancelUntil(this.rootLevel);
    }

    protected void reduceDB() {
        Constr constr;
        int n;
        double d = this.claInc / (double)this.learnts.size();
        this.sortOnActivity();
        int n2 = 0;
        for (n = 0; n < this.learnts.size() / 2; ++n) {
            constr = (Constr)this.learnts.get(n);
            if (!constr.locked()) {
                constr.remove();
                continue;
            }
            this.learnts.set(n2++, this.learnts.get(n));
        }
        while (n < this.learnts.size()) {
            constr = (Constr)this.learnts.get(n);
            if (!constr.locked() && constr.getActivity() < d) {
                constr.remove();
            } else {
                this.learnts.set(n2++, this.learnts.get(n));
            }
            ++n;
        }
        this.learnts.shrinkTo(n2);
    }

    private void sortOnActivity() {
        this.learnts.sort(this.comparator);
    }

    protected void decayActivities() {
        this.order.varDecayActivity();
        this.claDecayActivity();
    }

    private void claDecayActivity() {
        this.claInc *= this.claDecay;
    }

    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(new VecInt());
    }

    public boolean isSatisfiable(VecInt vecInt) throws TimeoutException {
        Lbool lbool = Lbool.UNDEFINED;
        double d = this.params.initConflictBound;
        double d2 = (double)this.nConstraints() * this.params.initLearntBoundConstraintFactor;
        this.stats.reset();
        this.order.init();
        this.model = null;
        if (this.propagate() != null) {
            this.cancelUntil(0);
            return false;
        }
        for (int i = 0; i < vecInt.size(); ++i) {
            if (this.assume(this.voc.getFromPool(vecInt.get(i))) && this.propagate() == null) continue;
            this.cancelUntil(0);
            return false;
        }
        this.rootLevel = this.decisionLevel();
        TimerTask timerTask = new TimerTask(){

            public void run() {
                Solver.this.undertimeout = false;
            }
        };
        this.undertimeout = true;
        Timer timer = new Timer(true);
        timer.schedule(timerTask, (long)this.timeout * 1000L);
        while (lbool == Lbool.UNDEFINED && this.undertimeout) {
            lbool = this.search(Math.round(d), Math.round(d2));
            d *= this.params.conflictBoundIncFactor;
            d2 *= this.params.learntBoundIncFactor;
        }
        this.cancelUntil(0);
        timer.cancel();
        if (!this.undertimeout) {
            throw new TimeoutException(" Timeout (" + this.timeout + "s) exceeded");
        }
        return lbool == Lbool.TRUE;
    }

    public SolverStats getStats() {
        return this.stats;
    }

    public VarOrder getOrder() {
        return this.order;
    }

    public void setOrder(VarOrder varOrder) {
        this.order = varOrder;
        this.order.setLits(this.voc);
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public void reset() {
        this.voc.resetPool();
        this.dsfactory.reset();
    }

    public int nVars() {
        return this.voc.nVars();
    }

    public void backUp() {
        if (!$assertionsDisabled && this.propQ.size() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.decisionLevel() != this.rootLevel) {
            throw new AssertionError();
        }
        this.oldNConstraints = this.nConstraints();
        this.oldNLearnts = this.nLearnts();
        this.oldTrail = this.trail.size();
        this.oldTrailLim = this.trailLim.size();
    }

    public void restore() {
        if (!$assertionsDisabled && this.oldTrailLim != this.trailLim.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.oldTrail > this.trail.size()) {
            throw new AssertionError();
        }
        while (this.nConstraints() > this.oldNConstraints) {
            ((Constr)this.constrs.last()).remove();
            this.constrs.pop();
        }
        while (this.nLearnts() > this.oldNLearnts) {
            ((Constr)this.learnts.last()).remove();
            this.learnts.pop();
        }
        while (this.trail.size() > this.oldTrail) {
            this.undoOne();
        }
        this.oldNConstraints = -1;
        this.oldNLearnts = -1;
        this.oldTrailLim = -1;
        this.oldTrail = -1;
    }

    public void addConstr(Constr constr) {
        if (constr != null) {
            this.constrs.push(constr);
        }
    }

    public DataStructureFactory getDSFactory() {
        return this.dsfactory;
    }

    public VecInt getOutLearnt() {
        return this.outLearnt;
    }

    public Constr getIthConstr(int n) {
        return (Constr)this.constrs.get(n);
    }

    static {
        $assertionsDisabled = !Solver.class.desiredAssertionStatus();
    }
}

