/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.Serializable;
import org.sat4j.minisat.core.ILits;
import org.sat4j.specs.VecInt;

public class VarOrder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double VAR_RESCALE_FACTOR = 1.0E-100;
    private static final double VAR_RESCALE_BOUND = 1.0E100;
    protected double[] activity = new double[1];
    protected int lastVar = 1;
    protected final VecInt order = new VecInt();
    private double varDecay = 1.0;
    private double varInc = 1.0;
    protected int[] varpos = new int[1];
    protected ILits lits;
    static final /* synthetic */ boolean $assertionsDisabled;

    public VarOrder() {
        this.order.push(-1);
    }

    public void setLits(ILits iLits) {
        this.lits = iLits;
    }

    public void newVar() {
        this.newVar(1);
    }

    public void newVar(int n) {
        int n2 = this.varpos.length + n;
        int[] nArray = new int[n2];
        double[] dArray = new double[n2];
        this.order.ensure(n2);
        int n3 = this.varpos.length;
        System.arraycopy(this.varpos, 0, nArray, 0, n3);
        System.arraycopy(this.activity, 0, dArray, 0, n3);
        for (int i = n3; i < n2; ++i) {
            if (!$assertionsDisabled && i <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && i > this.lits.nVars()) {
                throw new AssertionError((Object)("" + this.lits.nVars() + "/" + i));
            }
            this.order.push(this.lits.getFromPool(i) ^ 1);
            nArray[i] = i;
            dArray[i] = 0.0;
        }
        this.varpos = nArray;
        this.activity = dArray;
    }

    public int select() {
        if (!$assertionsDisabled && this.lastVar <= 0) {
            throw new AssertionError();
        }
        for (int i = this.lastVar; i < this.order.size(); ++i) {
            if (!$assertionsDisabled && i <= 0) {
                throw new AssertionError();
            }
            if (!this.lits.isUnassigned(this.order.get(i))) continue;
            this.lastVar = i;
            return this.order.get(i);
        }
        return -1;
    }

    public void setVarDecay(double d) {
        this.varDecay = d;
    }

    public void undo(int n) {
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= this.order.size()) {
            throw new AssertionError();
        }
        int n2 = this.varpos[n];
        if (n2 < this.lastVar) {
            this.lastVar = n2;
        }
        if (!$assertionsDisabled && this.lastVar <= 0) {
            throw new AssertionError();
        }
    }

    public void updateVar(int n) {
        if (!$assertionsDisabled && n <= 1) {
            throw new AssertionError();
        }
        int n2 = n >> 1;
        double d = this.activity[n2] = this.activity[n2] + this.varInc;
        if (d > 1.0E100) {
            this.varRescaleActivity();
        }
        for (int i = this.varpos[n >> 1]; i > 1 && this.activity[this.order.get(i - 1) >> 1] < this.activity[n >> 1]; --i) {
            if (!$assertionsDisabled && this.order.get(i) != n && this.order.get(i) != (n ^ 1)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && i <= 1) {
                throw new AssertionError();
            }
            int n3 = this.order.get(i - 1);
            if (!$assertionsDisabled && this.varpos[n3 >> 1] != i - 1) {
                throw new AssertionError();
            }
            this.varpos[n3 >> 1] = i;
            this.varpos[n >> 1] = i - 1;
            this.order.set(i, n3);
            this.order.set(i - 1, n);
        }
    }

    public void varDecayActivity() {
        this.varInc *= this.varDecay;
    }

    private void varRescaleActivity() {
        int n = 1;
        while (n < this.activity.length) {
            int n2 = n++;
            this.activity[n2] = this.activity[n2] * 1.0E-100;
        }
        this.varInc *= 1.0E-100;
    }

    public double varActivity(int n) {
        return this.activity[n >> 1];
    }

    public int numberOfInterestingVariables() {
        int n = 0;
        for (int i = 1; i < this.activity.length; ++i) {
            if (!(this.activity[i] > 1.0)) continue;
            ++n;
        }
        return n;
    }

    public void init() {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < this.order.size(); ++i) {
            int n = this.order.get(i);
            stringBuffer.append(n);
            stringBuffer.append("(");
            stringBuffer.append(this.activity[n >> 1]);
            stringBuffer.append(")");
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public ILits getVocabulary() {
        return this.lits;
    }

    static {
        $assertionsDisabled = !VarOrder.class.desiredAssertionStatus();
    }
}

